/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.web.rest;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.tenant.provisioning.model.EmailTemplate;
import io.meeds.tenant.provisioning.model.EmailTemplateDTO;
import io.meeds.tenant.provisioning.service.DeedEmailService;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import io.meeds.tenant.provisioning.web.rest.utils.EntityMapper;
import java.security.Principal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/provisioning/email"})
public class DeedEmailController {
    private static final Logger LOG = LoggerFactory.getLogger(DeedEmailController.class);
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private DeedEmailService deedEmailService;

    @PostMapping
    public void sendEmail(Principal principal, @RequestParam(value="nftId") long nftId, @RequestParam(value="subject") String subject, @RequestParam(value="content") String content) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        try {
            this.deedEmailService.sendEmail(nftId, subject, content, false);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOG.warn("Error sending email to tenant manager", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"templates"})
    public ResponseEntity<List<EmailTemplateDTO>> getEmailTemplates(Principal principal) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        List<EmailTemplate> emailTemplates = this.deedEmailService.getEmailTemplates();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body(EntityMapper.toDTO(emailTemplates));
    }

    @PostMapping(value={"templates"})
    public ResponseEntity<EmailTemplateDTO> createTemplate(Principal principal, @RequestBody EmailTemplateDTO emailTemplate) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (emailTemplate == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "emailTemplate object is mandatory");
        }
        if (StringUtils.isNotBlank((CharSequence)emailTemplate.getId())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "emailTemplate.id has to be empty");
        }
        try {
            EmailTemplate createdEmailTemplate = this.deedEmailService.createTemplate(EntityMapper.fromDTO(emailTemplate));
            return ResponseEntity.ok().body((Object)EntityMapper.toDTO(createdEmailTemplate));
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Id already exists");
        }
    }

    @PutMapping(value={"templates/{id}"})
    public ResponseEntity<EmailTemplateDTO> updateTemplate(Principal principal, @PathVariable(value="id") String id, @RequestBody EmailTemplateDTO emailTemplate) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "id is mandatory");
        }
        if (emailTemplate == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "emailTemplate object is mandatory");
        }
        emailTemplate.setId(id);
        try {
            EmailTemplate createdEmailTemplate = this.deedEmailService.updateTemplate(EntityMapper.fromDTO(emailTemplate));
            return ResponseEntity.ok().body((Object)EntityMapper.toDTO(createdEmailTemplate));
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"templates/{id}"})
    public void deleteTemplate(Principal principal, @PathVariable(value="id") String id) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "id is mandatory");
        }
        try {
            this.deedEmailService.deleteTemplate(id);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
    }
}

