/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.wom.api.constant.WomParsingException;
import java.text.DateFormat;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) throws WomParsingException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(value, resultClass);
        }
        catch (Exception e) {
            throw new WomParsingException("wom.unableToParseObject", e);
        }
    }

    public static final <T> T fromJsonStringNoCheckedEx(String value, Class<T> resultClass) throws WomParsingException {
        try {
            return JsonUtils.fromJsonString(value, resultClass);
        }
        catch (WomParsingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final String toJsonString(Object object) throws WomParsingException {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new WomParsingException("wom.unableToParseObject", e);
        }
    }

    public static final String toJsonStringNoCheckedEx(Object object) {
        try {
            return JsonUtils.toJsonString(object);
        }
        catch (WomParsingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.setDateFormat((DateFormat)new StdDateFormat().withTimeZone(TimeZone.getTimeZone("UTC")));
    }
}

