/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.tenant.metamask.RegistrationException;
import io.meeds.tenant.metamask.service.TenantManagerService;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.security.security.SecureRandomService;
import org.picocontainer.Startable;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class MetamaskLoginService
implements Startable {
    public static final String LOGIN_MESSAGE_ATTRIBUTE_NAME = "metamask_login_message";
    public static final String METAMASK_ALLOW_REGISTRATION_PARAM = "allow.registration";
    public static final String SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM = "secureRootAccessWithMetamask";
    public static final String ALLOWED_ROOT_ACCESS_WALLETS_PARAM = "allowedRootAccessWallets";
    protected static final Log LOG = ExoLogger.getLogger(MetamaskLoginService.class);
    private OrganizationService organizationService;
    private UserACL userACL;
    private SecureRandomService secureRandomService;
    private TenantManagerService tenantManagerService;
    private boolean allowUserRegistration;
    private boolean secureRootAccessWithMetamask;
    private List<String> allowedWallets = new ArrayList<String>();

    public MetamaskLoginService(OrganizationService organizationService, UserACL userACL, SecureRandomService secureRandomService, TenantManagerService tenantManagerService, InitParams params) {
        this.organizationService = organizationService;
        this.secureRandomService = secureRandomService;
        this.tenantManagerService = tenantManagerService;
        this.userACL = userACL;
        if (params != null) {
            if (params.containsKey((Object)METAMASK_ALLOW_REGISTRATION_PARAM)) {
                this.allowUserRegistration = Boolean.parseBoolean(params.getValueParam(METAMASK_ALLOW_REGISTRATION_PARAM).getValue());
            }
            if (params.containsKey((Object)SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM)) {
                this.secureRootAccessWithMetamask = Boolean.parseBoolean(params.getValueParam(SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM).getValue());
            }
            if (params.containsKey((Object)ALLOWED_ROOT_ACCESS_WALLETS_PARAM)) {
                String[] wallets = StringUtils.split((String)params.getValueParam(ALLOWED_ROOT_ACCESS_WALLETS_PARAM).getValue(), (String)",");
                Arrays.stream(wallets).forEach(address -> this.allowedWallets.add(address.trim().toLowerCase()));
            }
        }
    }

    public void start() {
        if (this.secureRootAccessWithMetamask) {
            try {
                User rootUser = this.organizationService.getUserHandler().findUserByName(this.userACL.getSuperUser());
                if (rootUser == null) {
                    LOG.warn((Object)"Root user wasn't found, can't regenerate password.");
                } else {
                    LOG.info((Object)"Regenerate root password to allow accessing it via Metamask only");
                    rootUser.setPassword(this.generateRandomToken());
                    this.organizationService.getUserHandler().saveUser(rootUser, false);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Can't secure root access", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    public boolean isAllowUserRegistration() {
        if (this.allowUserRegistration) {
            return true;
        }
        String tenantManagerAddress = this.tenantManagerService.getManagerAddress();
        if (StringUtils.isNotBlank((CharSequence)tenantManagerAddress)) {
            try {
                User tenantManager = this.organizationService.getUserHandler().findUserByName(tenantManagerAddress.toLowerCase());
                if (tenantManager == null) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("Error retrieving user with name {}", new Object[]{tenantManagerAddress, e});
            }
        }
        return this.allowUserRegistration;
    }

    public boolean isAllowUserRegistration(String walletAddress) {
        if (this.allowUserRegistration) {
            return true;
        }
        return this.tenantManagerService.isTenantManager(walletAddress);
    }

    public String getUserWithWalletAddress(String walletAddress) {
        if (this.secureRootAccessWithMetamask && this.allowedWallets.contains(walletAddress.toLowerCase())) {
            return this.userACL.getSuperUser();
        }
        try {
            User user = this.organizationService.getUserHandler().findUserByName(walletAddress.toLowerCase());
            if (user != null) {
                return user.getUserName();
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving username from walletAddress {}", new Object[]{walletAddress, e});
        }
        return null;
    }

    public boolean validateSignedMessage(String walletAddress, String rawMessage, String signedMessage) {
        if (StringUtils.isBlank((CharSequence)walletAddress) || StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
            return false;
        }
        try {
            BigInteger publicKey;
            String recoveredAddress;
            byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
            if (signatureBytes.length < 64) {
                return false;
            }
            byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
            byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
            byte v = signatureBytes[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((recoveredAddress = "0x" + Keys.getAddress((BigInteger)(publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))))).equalsIgnoreCase(walletAddress)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Error verifying signedPrefixed Message for wallet {}. Consider user as not authenticated.", new Object[]{walletAddress, e});
            return false;
        }
        return false;
    }

    public String generateLoginMessage(HttpSession session, boolean renew) {
        String token = this.getLoginMessage(session);
        if (token != null && !renew) {
            return token;
        }
        token = this.generateRandomToken();
        if (session != null) {
            session.setAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME, (Object)token);
        }
        return token;
    }

    public String generateLoginMessage(HttpSession session) {
        return this.generateLoginMessage(session, false);
    }

    public String getLoginMessage(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME);
    }

    public User registerUser(String username, String fullName, String email) throws RegistrationException {
        UserHandler userHandler = this.organizationService.getUserHandler();
        try {
            username = StringUtils.lowerCase((String)username);
            User user = userHandler.createUserInstance(username);
            this.validateUsername(username);
            this.validateAndSetFullName(user, fullName);
            this.validateAndSetEmail(user, email);
            userHandler.createUser(user, true);
            if (this.tenantManagerService.isTenantManager(user.getUserName())) {
                this.setTenantManagerRoles(user);
            }
            return user;
        }
        catch (RegistrationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error regitering user", (Throwable)e);
            throw new RegistrationException("REGISTRATION_ERROR");
        }
    }

    private void setTenantManagerRoles(User user) {
        List<String> tenantManagerRoles = this.tenantManagerService.getTenantManagerDefaultRoles();
        LOG.info((Object)"Tenant manager registered, setting its default memberships as manager.");
        for (String role : tenantManagerRoles) {
            if (!StringUtils.isNotBlank((CharSequence)role)) continue;
            LOG.info("Add Tenant manager membership {}.", new Object[]{role});
            if (StringUtils.contains((CharSequence)role, (CharSequence)":")) {
                String[] roleParts = StringUtils.split((String)role, (String)":");
                String membershipTypeId = roleParts[0];
                String groupId = roleParts[1];
                this.addUserToGroup(user, groupId, membershipTypeId);
                continue;
            }
            this.addUserToGroup(user, role, "*");
        }
    }

    private void addUserToGroup(User user, String groupId, String membershipTypeId) {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        MembershipHandler membershipHandler = this.organizationService.getMembershipHandler();
        MembershipTypeHandler membershipTypeHandler = this.organizationService.getMembershipTypeHandler();
        try {
            Group group = groupHandler.findGroupById(groupId);
            MembershipType membershipType = membershipTypeHandler.findMembershipType(membershipTypeId);
            if (group != null && membershipType != null) {
                membershipHandler.linkMembership(user, group, membershipType, true);
            } else if (group == null) {
                LOG.warn("Group with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{groupId, membershipTypeId + ":" + groupId});
            } else {
                LOG.warn("Membership Type with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{membershipTypeId, membershipTypeId + ":" + groupId});
            }
        }
        catch (Exception e) {
            LOG.warn("Error while adding user {} to role {}:{}", new Object[]{user.getUserName(), membershipTypeId, groupId, e});
        }
    }

    private void validateAndSetFullName(User user, String fullName) throws RegistrationException {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            throw new RegistrationException("FULLNAME_MANDATORY");
        }
        if (StringUtils.contains((CharSequence)fullName, (CharSequence)" ")) {
            Object[] fullNameParts = fullName.split(" ");
            user.setFirstName(StringUtils.join((Object[])fullNameParts, (String)" ", (int)0, (int)(fullNameParts.length - 1)));
            user.setLastName((String)fullNameParts[fullNameParts.length - 1]);
        } else {
            user.setLastName(fullName);
            user.setFirstName("");
        }
    }

    private void validateUsername(String username) throws Exception {
        User existingUser = this.organizationService.getUserHandler().findUserByName(username);
        if (existingUser != null) {
            throw new RegistrationException("USERNAME_ALREADY_EXISTS");
        }
    }

    private void validateAndSetEmail(User user, String email) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)email)) {
            int usersLength = 0;
            try {
                Query query = new Query();
                query.setEmail(email);
                ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
                usersLength = users == null ? 0 : users.getSize();
            }
            catch (RuntimeException e) {
                LOG.debug("Error retrieving users list with email {}. Thus, we will consider the email as already used", new Object[]{email, e});
                usersLength = 1;
            }
            if (usersLength > 0) {
                throw new RegistrationException("EMAIL_ALREADY_EXISTS");
            }
            user.setEmail(email);
        }
    }

    private String generateRandomToken() {
        SecureRandom secureRandom = this.secureRandomService.getSecureRandom();
        return secureRandom.nextLong() + "-" + secureRandom.nextLong() + "-" + secureRandom.nextLong();
    }
}

