/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TenantManagerStorage
extends ElasticClient {
    private static final String DEFAULT_ES_INDEX_NAME = "deed_tenant_manager";
    private static final String ES_INDEX_CLIENT_PROPERTY_NAME = "es.url";
    private static final String ES_INDEX_CLIENT_PROPERTY_USERNAME = "es.username";
    private static final String ES_INDEX_CLIENT_PROPERTY_PASSWORD = "es.password";
    private static final String ES_INDEX_CLIENT_PROPERTY_INDEX = "es.index";
    private static final String FALLBACK_ES_INDEX_CLIENT_PROPERTY_NAME = "exo.es.index.server.url";
    private static final String FALLBACK_ES_INDEX_CLIENT_PROPERTY_USERNAME = "exo.es.index.server.username";
    private static final String FALLBACK_ES_INDEX_CLIENT_PROPERTY_PASSWORD = "exo.es.index.server.password";
    private static final String STATUS_CODE_PARAM = "status";
    private String esIndexName;
    private String esUsername;
    private String esPassword;
    private ExoCache<String, String> deedPropertiesCache;

    public TenantManagerStorage(CacheService cacheService, ElasticIndexingAuditTrail elasticIndexingAuditTrail, InitParams params) {
        super(elasticIndexingAuditTrail);
        this.esIndexName = this.getParamValue(params, ES_INDEX_CLIENT_PROPERTY_INDEX);
        if (StringUtils.isBlank((String)this.esIndexName)) {
            this.esIndexName = DEFAULT_ES_INDEX_NAME;
        }
        this.esUsername = this.getParamValue(params, ES_INDEX_CLIENT_PROPERTY_USERNAME);
        this.esPassword = this.getParamValue(params, ES_INDEX_CLIENT_PROPERTY_PASSWORD);
        String esUrl = this.getParamValue(params, ES_INDEX_CLIENT_PROPERTY_NAME);
        if (StringUtils.isBlank((String)esUrl)) {
            esUrl = PropertyManager.getProperty((String)FALLBACK_ES_INDEX_CLIENT_PROPERTY_NAME);
            this.esUsername = PropertyManager.getProperty((String)FALLBACK_ES_INDEX_CLIENT_PROPERTY_USERNAME);
            this.esPassword = PropertyManager.getProperty((String)FALLBACK_ES_INDEX_CLIENT_PROPERTY_PASSWORD);
        }
        if (StringUtils.isNotBlank((String)esUrl)) {
            this.urlClient = esUrl;
        }
        this.deedPropertiesCache = cacheService.getCacheInstance("deed.properties");
        this.initHttpClient();
    }

    protected String getEsUsernameProperty() {
        return this.esUsername;
    }

    protected String getEsPasswordProperty() {
        return this.esPassword;
    }

    protected HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.getMaxConnections());
        return connectionManager;
    }

    public String getManagerAddress(String nftId) {
        return this.computeDeedProperties(nftId, "managerAddress");
    }

    public String getCityIndex(String nftId) {
        return this.computeDeedProperties(nftId, "cityIndex");
    }

    public String getCardType(String nftId) {
        return this.computeDeedProperties(nftId, "cardType");
    }

    private String computeDeedProperties(String nftId, String key) {
        String cacheKey = key + "-" + nftId;
        if (this.deedPropertiesCache.get((Serializable)((Object)cacheKey)) == null) {
            Map<String, String> deedProperties = this.getDeedProperties(nftId);
            deedProperties.forEach((propKey, propValue) -> this.deedPropertiesCache.put((Serializable)((Object)(propKey + "-" + nftId)), propValue));
        }
        return (String)this.deedPropertiesCache.get((Serializable)((Object)cacheKey));
    }

    public void setTenantStatus(String nftId, String tenantProvisioningStatus, String tenantStatus) {
        JSONObject patchProperties = new JSONObject();
        if (StringUtils.isNotBlank((String)tenantProvisioningStatus)) {
            patchProperties.put((Object)"provisioningStatus", (Object)tenantProvisioningStatus);
        }
        if (StringUtils.isNotBlank((String)tenantStatus)) {
            patchProperties.put((Object)"tenantStatus", (Object)tenantStatus);
        }
        JSONObject doc = new JSONObject();
        doc.put((Object)"doc", (Object)patchProperties);
        this.updateDeedProperties(nftId, doc.toJSONString());
    }

    private Map<String, String> getDeedProperties(String nftId) {
        Integer httpStatusCode;
        long startTime = System.currentTimeMillis();
        StringBuilder url = new StringBuilder(this.urlClient).append("/" + this.esIndexName).append("/_doc").append("/").append(nftId);
        ElasticResponse elasticResponse = this.sendHttpGetRequest(url.toString());
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (StringUtils.isBlank((String)response)) {
            this.auditTrail.logRejectedSearchOperation("search_type", this.esIndexName, Integer.valueOf(statusCode), response, System.currentTimeMillis() - startTime);
            return Collections.emptyMap();
        }
        JSONParser parser = new JSONParser();
        JSONObject json = null;
        try {
            json = (JSONObject)parser.parse(response);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
        }
        Long status = json.get((Object)STATUS_CODE_PARAM) == null ? null : (Long)json.get((Object)STATUS_CODE_PARAM);
        Integer n = httpStatusCode = status == null ? null : Integer.valueOf(status.intValue());
        if (ElasticIndexingAuditTrail.isError((Integer)httpStatusCode)) {
            throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
        }
        if (json.containsKey((Object)"found") && Boolean.TRUE.equals(json.get((Object)"found"))) {
            JSONObject deedProperties = (JSONObject)json.get((Object)"_source");
            HashMap<String, String> properties = new HashMap<String, String>();
            deedProperties.forEach((key, value) -> properties.put(String.valueOf(key), String.valueOf(value)));
            return properties;
        }
        return Collections.emptyMap();
    }

    private void updateDeedProperties(String nftId, String esQuery) {
        long startTime = System.currentTimeMillis();
        StringBuilder url = new StringBuilder(this.urlClient).append("/" + this.esIndexName).append("/_update").append("/").append(nftId);
        ElasticResponse elasticResponse = this.sendHttpPostRequest(url.toString(), esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (StringUtils.isBlank((String)response)) {
            this.auditTrail.logRejectedSearchOperation("search_type", this.esIndexName, Integer.valueOf(statusCode), response, System.currentTimeMillis() - startTime);
        } else {
            Integer httpStatusCode;
            JSONParser parser = new JSONParser();
            JSONObject json = null;
            try {
                json = (JSONObject)parser.parse(response);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
            Long status = json.get((Object)STATUS_CODE_PARAM) == null ? null : (Long)json.get((Object)STATUS_CODE_PARAM);
            Integer n = httpStatusCode = status == null ? null : Integer.valueOf(status.intValue());
            if (ElasticIndexingAuditTrail.isError((Integer)httpStatusCode)) {
                throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
            }
        }
    }

    private String getParamValue(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValueParam(paramName).getValue();
        }
        return null;
    }
}

