/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.tenant.metamask.storage.TenantManagerStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TenantManagerService {
    public static final String MANAGER_DEFAULT_ROLES_PARAM = "managerDefaultRoles";
    public static final String NFT_ID_PARAM = "nftId";
    protected static final Log LOG = ExoLogger.getLogger(TenantManagerService.class);
    private TenantManagerStorage tenantManagerStorage;
    private String nftId;
    private List<String> tenantManagerDefaultRoles = new ArrayList<String>();

    public TenantManagerService(TenantManagerStorage tenantManagerStorage, InitParams params) {
        this.tenantManagerStorage = tenantManagerStorage;
        this.tenantManagerDefaultRoles = this.getParamValues(params, MANAGER_DEFAULT_ROLES_PARAM);
        this.nftId = this.getParamValue(params, NFT_ID_PARAM);
    }

    public boolean isTenantManager(String address) {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            return this.tenantManagerStorage.isManagerAddress(this.nftId, address);
        }
        return false;
    }

    public List<String> getTenantManagerDefaultRoles() {
        return Collections.unmodifiableList(this.tenantManagerDefaultRoles);
    }

    public String getNftId() {
        return this.nftId;
    }

    private String getParamValue(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValueParam(paramName).getValue();
        }
        return null;
    }

    private List<String> getParamValues(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValuesParam(paramName).getValues();
        }
        return Collections.emptyList();
    }
}

