/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.tenant.service.TenantManagerService;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.security.SecureRandomService;
import org.picocontainer.Startable;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class MetamaskLoginService
implements Startable {
    public static final String LOGIN_MESSAGE_ATTRIBUTE_NAME = "metamask_login_message";
    public static final String SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM = "secureRootAccessWithMetamask";
    public static final String ALLOWED_ROOT_ACCESS_WALLETS_PARAM = "allowedRootAccessWallets";
    protected static final Log LOG = ExoLogger.getLogger(MetamaskLoginService.class);
    private SecuritySettingService securitySettingService;
    private OrganizationService organizationService;
    private UserACL userACL;
    private SecureRandomService secureRandomService;
    private TenantManagerService tenantManagerService;
    private AccountSetupService accountSetupService;
    private boolean secureRootAccessWithMetamask;
    private List<String> allowedRootWallets = new ArrayList<String>();

    public MetamaskLoginService(OrganizationService organizationService, UserACL userACL, SecureRandomService secureRandomService, TenantManagerService tenantManagerService, AccountSetupService accountSetupService, SecuritySettingService securitySettingService, InitParams params) {
        this.organizationService = organizationService;
        this.secureRandomService = secureRandomService;
        this.tenantManagerService = tenantManagerService;
        this.accountSetupService = accountSetupService;
        this.securitySettingService = securitySettingService;
        this.userACL = userACL;
        if (params != null) {
            if (params.containsKey((Object)SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM)) {
                this.secureRootAccessWithMetamask = Boolean.parseBoolean(params.getValueParam(SECURE_ROOT_ACCESS_WITH_METAMASK_PARAM).getValue());
            }
            if (params.containsKey((Object)ALLOWED_ROOT_ACCESS_WALLETS_PARAM)) {
                String[] wallets = StringUtils.split((String)params.getValueParam(ALLOWED_ROOT_ACCESS_WALLETS_PARAM).getValue(), (String)",");
                Arrays.stream(wallets).forEach(address -> this.allowedRootWallets.add(address.trim().toLowerCase()));
            }
        }
    }

    public void start() {
        if (this.secureRootAccessWithMetamask) {
            this.accountSetupService.setSkipSetup(true);
            this.secureRootPassword();
        }
    }

    public void stop() {
    }

    public boolean isAllowUserRegistration() {
        return this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN;
    }

    public boolean isAllowUserRegistration(String walletAddress) {
        if (this.isAllowUserRegistration()) {
            return true;
        }
        return this.isTenantManager(walletAddress);
    }

    public boolean isTenantManager(String walletAddress) {
        return this.tenantManagerService.isTenantManager(walletAddress);
    }

    public boolean isSuperUser(String walletAddress) {
        return this.secureRootAccessWithMetamask && this.allowedRootWallets.contains(walletAddress.toLowerCase());
    }

    public String getUserWithWalletAddress(String walletAddress) {
        if (this.secureRootAccessWithMetamask && this.allowedRootWallets.contains(walletAddress.toLowerCase())) {
            return this.userACL.getSuperUser();
        }
        try {
            User user = this.organizationService.getUserHandler().findUserByName(walletAddress.toLowerCase());
            if (user != null) {
                return user.getUserName();
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving username from walletAddress {}", new Object[]{walletAddress, e});
        }
        return null;
    }

    public boolean validateSignedMessage(String walletAddress, String rawMessage, String signedMessage) {
        if (StringUtils.isBlank((CharSequence)walletAddress) || StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
            return false;
        }
        try {
            BigInteger publicKey;
            String recoveredAddress;
            byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
            if (signatureBytes.length < 64) {
                return false;
            }
            byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
            byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
            byte v = signatureBytes[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((recoveredAddress = "0x" + Keys.getAddress((BigInteger)(publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))))).equalsIgnoreCase(walletAddress)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Error verifying signedPrefixed Message for wallet {}. Consider user as not authenticated.", new Object[]{walletAddress, e});
            return false;
        }
        return false;
    }

    public String generateLoginMessage(HttpSession session, boolean renew) {
        String token = this.getLoginMessage(session);
        if (token != null && !renew) {
            return token;
        }
        token = this.generateRandomToken();
        if (session != null) {
            session.setAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME, (Object)token);
        }
        return token;
    }

    public String generateLoginMessage(HttpSession session) {
        return this.generateLoginMessage(session, false);
    }

    public String getLoginMessage(HttpSession session) {
        return session == null ? null : (String)session.getAttribute(LOGIN_MESSAGE_ATTRIBUTE_NAME);
    }

    public boolean isDeedTenant() {
        try {
            return this.tenantManagerService.isTenant();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error checking whether the current installation is a Deed Tenant or not, return false", (Throwable)e);
            return false;
        }
    }

    public long getDeedId() {
        return this.tenantManagerService.getNftId();
    }

    private String generateRandomToken() {
        SecureRandom secureRandom = this.secureRandomService.getSecureRandom();
        return secureRandom.nextLong() + "-" + secureRandom.nextLong() + "-" + secureRandom.nextLong();
    }

    private void secureRootPassword() {
        try {
            User rootUser = this.organizationService.getUserHandler().findUserByName(this.userACL.getSuperUser());
            if (rootUser == null) {
                LOG.warn((Object)"Root user wasn't found, can't regenerate password.");
            } else {
                LOG.info((Object)"Regenerate root password to allow accessing it via Metamask only");
                rootUser.setPassword(this.generateRandomToken());
                this.organizationService.getUserHandler().saveUser(rootUser, false);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't secure root access", (Throwable)e);
        }
    }
}

