/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.metamask.service.MetamaskLoginService;
import io.meeds.tenant.model.DeedTenantHost;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.login.UIParamsExtension;

public class MetamaskLoginExtension
implements UIParamsExtension {
    private static final List<String> EXTENSION_NAMES = Collections.singletonList("LoginExtension");
    protected MetamaskLoginService metamaskLoginService;

    public MetamaskLoginExtension(MetamaskLoginService metamaskLoginService) {
        this.metamaskLoginService = metamaskLoginService;
    }

    public List<String> getExtensionNames() {
        return EXTENSION_NAMES;
    }

    public Map<String, Object> extendParameters(ControllerContext controllerContext, String extensionName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metamaskEnabled", true);
        HttpSession httpSession = controllerContext.getRequest().getSession(true);
        params.put("rawMessage", this.metamaskLoginService.generateLoginMessage(httpSession));
        this.addDeedTenantParameters(httpSession, params, false);
        return params;
    }

    protected void addDeedTenantParameters(HttpSession httpSession, Map<String, Object> params, boolean needManagerMail) {
        if (this.metamaskLoginService.isDeedTenant()) {
            params.put("nftId", this.metamaskLoginService.getDeedId());
            params.put("isDeedTenant", true);
            DeedTenantHost deedTenantHost = DeedTenantHost.getInstance();
            if (deedTenantHost != null) {
                params.put("cityIndex", deedTenantHost.getCityIndex());
                params.put("cardTypeIndex", deedTenantHost.getCardType());
                String walletAddress = (String)httpSession.getAttribute("username");
                if (needManagerMail && StringUtils.isNotBlank((CharSequence)walletAddress) && this.metamaskLoginService.isTenantManager(walletAddress)) {
                    params.put("isTenantManager", true);
                    if (StringUtils.isNotBlank((CharSequence)deedTenantHost.getManagerEmail())) {
                        params.put("tenantManagerEmail", deedTenantHost.getManagerEmail());
                    }
                }
            }
        }
    }
}

