/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import io.meeds.tenant.hub.service.PolygonContractGasProvider;
import io.meeds.tenant.hub.storage.HubIdentityStorage;
import io.meeds.tenant.hub.storage.HubWalletStorage;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReportPayload;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.TreeSet;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.JsonRpcError;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.TransactionReceiptProcessor;

@SpringBootTest(classes={HubWalletStorage.class})
@ExtendWith(value={MockitoExtension.class})
class HubWalletStorageTest {
    @MockBean
    private WalletAccountService walletAccountService;
    @MockBean
    private HubIdentityStorage hubIdentityStorage;
    @MockBean
    private CodecInitializer codecInitializer;
    @MockBean
    private PolygonContractGasProvider polygonContractGasProvider;
    @Autowired
    private HubWalletStorage hubWalletStorage;
    @Mock
    private Web3j web3j;
    @Mock
    private TransactionManager transactionManager;
    @Mock
    private TransactionReceiptProcessor transactionReceiptProcessor;
    @Mock
    private AbstractCodec codec;
    @Mock
    private GlobalSettings globalSettings;
    @Mock
    private ContractDetail contractDetail;
    private Credentials hubWalletCredentials = Credentials.create((String)"0x1da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private ECKeyPair hubWallet = this.hubWalletCredentials.getEcKeyPair();
    private String hubAddress = this.hubWalletCredentials.getAddress();
    private String rewardTokenAddress = "0x654d85047da64738c065d36e10b2adeb965000d0";
    private long rewardTokenNetworkId = 25641L;
    private String password = "password";
    private long periodStartTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long periodEndTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long reportId = 5L;
    private long uemNetworkId = 80001L;
    private Integer decimals = 18;
    private long deedId = 35L;
    private long usersCount = 125L;
    private long participantsCount = 85L;
    private long recipientsCount = 65L;
    private int achievementsCount = 55698;
    private int actionsCount = 656;
    private double tokensSent = 52.3365;
    private double topReceiverAmount = 4.6;
    private String uemAddress = "0x290b11b1ab6a31ff95490e4e0eeffec6402cce99";
    private String txHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";
    private Instant sentDate = Instant.now();
    private MockedStatic<WalletUtils> walletUtils;
    private MockedStatic<Contract> contract;

    HubWalletStorageTest() {
    }

    @BeforeEach
    void init() {
        this.walletUtils = Mockito.mockStatic(WalletUtils.class);
        this.contract = Mockito.mockStatic(Contract.class);
        this.walletUtils.when(WalletUtils::getNetworkId).thenReturn((Object)this.rewardTokenNetworkId);
        this.walletUtils.when(WalletUtils::getContractAddress).thenReturn((Object)this.rewardTokenAddress);
        this.walletUtils.when(() -> WalletUtils.toJsonString((Object)ArgumentMatchers.any())).thenCallRealMethod();
        this.walletUtils.when(() -> WalletUtils.fromJsonString((String)((String)ArgumentMatchers.any()), (Class)((Class)ArgumentMatchers.any()))).thenCallRealMethod();
    }

    @AfterEach
    void close() {
        this.walletUtils.close();
        this.contract.close();
    }

    @Test
    void getOrCreateHubAddressWhenExists() {
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        Assertions.assertEquals((Object)this.hubAddress, (Object)this.hubWalletStorage.getOrCreateHubAddress());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.codecInitializer, this.walletAccountService});
    }

    @Test
    void getOrCreateHubAddressWhenAdminWalletNotExists() {
        String createdHubAddress = this.hubWalletStorage.getOrCreateHubAddress();
        Assertions.assertNull((Object)createdHubAddress);
    }

    @Test
    void getOrCreateHubAddressWhenNotExists() {
        String newHubAddress = this.generateWallet();
        Assertions.assertEquals((Object)this.hubAddress.replace("0x", "").toLowerCase(), (Object)newHubAddress.replace("0x", "").toLowerCase());
        String createdHubAddress = this.hubWalletStorage.getOrCreateHubAddress();
        Assertions.assertEquals((Object)newHubAddress.replace("0x", "").toLowerCase(), (Object)createdHubAddress.replace("0x", "").toLowerCase());
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).saveHubWallet((String)ArgumentMatchers.argThat(address -> newHubAddress.replace("0x", "").equalsIgnoreCase(createdHubAddress.replace("0x", ""))), (String)ArgumentMatchers.argThat(Objects::nonNull));
    }

    @Test
    void getOrCreateHubAddressWhenError() {
        WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
        Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
        Mockito.when((Object)this.walletAccountService.getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin")).thenAnswer(invocation -> WalletUtils.toJsonString((Object)walletFile));
        Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenThrow(IllegalStateException.class);
        Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.getOrCreateHubAddress());
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage, (VerificationMode)Mockito.never())).saveHubWallet((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    void signHubMessage() throws WomException {
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        String signedMessage = this.hubWalletStorage.signHubMessage("rawMessage");
        Assertions.assertEquals((Object)"0x02c66a7f71d95d64b85ef051010cdda667f09d2ffc6119bbd05ad3c4ba2245c139b0ae4a259dcff1ddf97d7175550b1de3b9a743d59eaddb783f9b910f7a571b1b".replace("0x", "").toLowerCase(), (Object)signedMessage.replace("0x", "").toLowerCase());
    }

    @Test
    void sendReportTransaction() {
        this.walletUtils.when(WalletUtils::getSettings).thenReturn((Object)this.globalSettings);
        this.walletUtils.when(() -> WalletUtils.convertToDecimals((double)ArgumentMatchers.anyDouble(), (int)ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.globalSettings.getContractDetail()).thenReturn((Object)this.contractDetail);
        Mockito.when((Object)this.contractDetail.getDecimals()).thenReturn((Object)this.decimals);
        Mockito.when((Object)this.polygonContractGasProvider.getWeb3j()).thenReturn((Object)this.web3j);
        Mockito.when((Object)this.polygonContractGasProvider.getChainId()).thenReturn((Object)this.uemNetworkId);
        HubReportPayload reportPayload = this.newHubReportPayload();
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        this.hubWalletStorage.setTransactionManager(this.transactionManager);
        this.hubWalletStorage.setTransactionReceiptProcessor(this.transactionReceiptProcessor);
        BigInteger nonce = BigInteger.TWO;
        BigInteger estimatedGas = BigInteger.TEN;
        Mockito.when((Object)this.web3j.ethGetTransactionCount(this.hubAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenAnswer(args -> {
            EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
            Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)nonce);
            return request;
        });
        Mockito.when((Object)this.web3j.ethEstimateGas((Transaction)ArgumentMatchers.any())).thenAnswer(args -> {
            EthEstimateGas gasEstimate = (EthEstimateGas)Mockito.mock(EthEstimateGas.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)gasEstimate);
            Mockito.when((Object)gasEstimate.getAmountUsed()).thenReturn((Object)estimatedGas);
            return request;
        });
        BigInteger gasPrice = BigInteger.valueOf(31L);
        Mockito.when((Object)this.polygonContractGasProvider.getGasPrice((String)ArgumentMatchers.any())).thenReturn((Object)gasPrice);
        Mockito.when((Object)this.transactionManager.getFromAddress()).thenReturn((Object)this.hubAddress);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        TransactionReceipt receipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)this.transactionManager.sendTransaction((BigInteger)ArgumentMatchers.eq((Object)gasPrice), (BigInteger)ArgumentMatchers.eq((Object)BigDecimal.valueOf(estimatedGas.doubleValue()).multiply(BigDecimal.valueOf(1.2)).toBigInteger()), (String)ArgumentMatchers.eq((Object)this.uemAddress), ArgumentMatchers.anyString(), (BigInteger)ArgumentMatchers.eq((Object)BigInteger.ZERO))).thenReturn((Object)ethSendTransaction);
        Mockito.when((Object)this.transactionReceiptProcessor.waitForTransactionReceipt((String)ArgumentMatchers.any())).thenReturn((Object)receipt);
        Mockito.when((Object)receipt.isStatusOK()).thenReturn((Object)true);
        Mockito.when((Object)receipt.getLogs()).thenReturn(Collections.singletonList((Log)Mockito.mock(Log.class)));
        this.mockReportSentEventResponse();
        long createdReportId = this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId);
        Assertions.assertEquals((long)this.reportId, (long)createdReportId);
    }

    @Test
    void sendReportTransactionWhenReceiptError() {
        this.walletUtils.when(WalletUtils::getSettings).thenReturn((Object)this.globalSettings);
        this.walletUtils.when(() -> WalletUtils.convertToDecimals((double)ArgumentMatchers.anyDouble(), (int)ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.globalSettings.getContractDetail()).thenReturn((Object)this.contractDetail);
        Mockito.when((Object)this.contractDetail.getDecimals()).thenReturn((Object)this.decimals);
        Mockito.when((Object)this.polygonContractGasProvider.getWeb3j()).thenReturn((Object)this.web3j);
        Mockito.when((Object)this.polygonContractGasProvider.getChainId()).thenReturn((Object)this.uemNetworkId);
        HubReportPayload reportPayload = this.newHubReportPayload();
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        this.hubWalletStorage.setTransactionManager(this.transactionManager);
        this.hubWalletStorage.setTransactionReceiptProcessor(this.transactionReceiptProcessor);
        BigInteger nonce = BigInteger.TWO;
        BigInteger estimatedGas = BigInteger.TEN;
        Mockito.when((Object)this.web3j.ethGetTransactionCount(this.hubAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenAnswer(args -> {
            EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
            Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)nonce);
            return request;
        });
        Mockito.when((Object)this.web3j.ethEstimateGas((Transaction)ArgumentMatchers.any())).thenAnswer(args -> {
            EthEstimateGas gasEstimate = (EthEstimateGas)Mockito.mock(EthEstimateGas.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)gasEstimate);
            Mockito.when((Object)gasEstimate.getAmountUsed()).thenReturn((Object)estimatedGas);
            return request;
        });
        BigInteger gasPrice = BigInteger.valueOf(31L);
        Mockito.when((Object)this.polygonContractGasProvider.getGasPrice((String)ArgumentMatchers.any())).thenReturn((Object)gasPrice);
        Mockito.when((Object)this.transactionManager.getFromAddress()).thenReturn((Object)this.hubAddress);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Mockito.when((Object)ethSendTransaction.getTransactionHash()).thenReturn((Object)this.txHash);
        Mockito.when((Object)this.transactionManager.sendTransaction((BigInteger)ArgumentMatchers.eq((Object)gasPrice), (BigInteger)ArgumentMatchers.eq((Object)BigDecimal.valueOf(estimatedGas.doubleValue()).multiply(BigDecimal.valueOf(1.2)).toBigInteger()), (String)ArgumentMatchers.eq((Object)this.uemAddress), ArgumentMatchers.anyString(), (BigInteger)ArgumentMatchers.eq((Object)BigInteger.ZERO))).thenReturn((Object)ethSendTransaction);
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)"uem.sendReportFailedWithoutReceipt", (Object)exception.getMessage());
        TransactionReceipt receipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)this.transactionReceiptProcessor.waitForTransactionReceipt((String)ArgumentMatchers.any())).thenReturn((Object)receipt);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)"uem.sendReportTransactionFailed", (Object)exception.getMessage());
        String revertError = "uem.sendReportTransactionFailedCustomMessage";
        Mockito.when((Object)receipt.getStatus()).thenReturn((Object)revertError);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)revertError, (Object)exception.getMessage());
        Mockito.when((Object)receipt.getRevertReason()).thenReturn((Object)revertError);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)revertError, (Object)exception.getMessage());
        revertError = "wom.sendReportTransactionFailedCustomMessage";
        Mockito.when((Object)receipt.getRevertReason()).thenReturn((Object)revertError);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)revertError, (Object)exception.getMessage());
    }

    @Test
    void sendReportTransactionWhenEstimationError() {
        this.walletUtils.when(WalletUtils::getSettings).thenReturn((Object)this.globalSettings);
        this.walletUtils.when(() -> WalletUtils.convertToDecimals((double)ArgumentMatchers.anyDouble(), (int)ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.globalSettings.getContractDetail()).thenReturn((Object)this.contractDetail);
        Mockito.when((Object)this.contractDetail.getDecimals()).thenReturn((Object)this.decimals);
        Mockito.when((Object)this.polygonContractGasProvider.getWeb3j()).thenReturn((Object)this.web3j);
        Mockito.when((Object)this.polygonContractGasProvider.getChainId()).thenReturn((Object)this.uemNetworkId);
        HubReportPayload reportPayload = this.newHubReportPayload();
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        this.hubWalletStorage.setTransactionManager(this.transactionManager);
        this.hubWalletStorage.setTransactionReceiptProcessor(this.transactionReceiptProcessor);
        BigInteger nonce = BigInteger.TWO;
        Mockito.when((Object)this.web3j.ethGetTransactionCount(this.hubAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenAnswer(args -> {
            EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
            Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)nonce);
            return request;
        });
        String customRevertException = "uem.customRevertError";
        Mockito.when((Object)this.web3j.ethEstimateGas((Transaction)ArgumentMatchers.any())).thenAnswer(args -> {
            EthEstimateGas gasEstimate = (EthEstimateGas)Mockito.mock(EthEstimateGas.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)gasEstimate);
            Mockito.when((Object)gasEstimate.hasError()).thenReturn((Object)true);
            Mockito.when((Object)gasEstimate.getError()).thenReturn((Object)new Response.Error(0, customRevertException));
            return request;
        });
        BigInteger gasPrice = BigInteger.valueOf(31L);
        Mockito.when((Object)this.polygonContractGasProvider.getGasPrice((String)ArgumentMatchers.any())).thenReturn((Object)gasPrice);
        Mockito.when((Object)this.transactionManager.getFromAddress()).thenReturn((Object)this.hubAddress);
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)customRevertException, (Object)exception.getMessage());
    }

    @Test
    void sendReportTransactionWhenEstimationJsonRpcErrorInMessage() {
        this.walletUtils.when(WalletUtils::getSettings).thenReturn((Object)this.globalSettings);
        this.walletUtils.when(() -> WalletUtils.convertToDecimals((double)ArgumentMatchers.anyDouble(), (int)ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.globalSettings.getContractDetail()).thenReturn((Object)this.contractDetail);
        Mockito.when((Object)this.contractDetail.getDecimals()).thenReturn((Object)this.decimals);
        Mockito.when((Object)this.polygonContractGasProvider.getWeb3j()).thenReturn((Object)this.web3j);
        Mockito.when((Object)this.polygonContractGasProvider.getChainId()).thenReturn((Object)this.uemNetworkId);
        HubReportPayload reportPayload = this.newHubReportPayload();
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        this.hubWalletStorage.setTransactionManager(this.transactionManager);
        this.hubWalletStorage.setTransactionReceiptProcessor(this.transactionReceiptProcessor);
        BigInteger nonce = BigInteger.TWO;
        Mockito.when((Object)this.web3j.ethGetTransactionCount(this.hubAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenAnswer(args -> {
            EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
            Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)nonce);
            return request;
        });
        BigInteger gasPrice = BigInteger.valueOf(35L);
        Mockito.when((Object)this.polygonContractGasProvider.getGasPrice((String)ArgumentMatchers.any())).thenReturn((Object)gasPrice);
        Mockito.when((Object)this.transactionManager.getFromAddress()).thenReturn((Object)this.hubAddress);
        String customRevertException = "uem.customRevertExceptionInMessage";
        Mockito.when((Object)this.web3j.ethEstimateGas((Transaction)ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonRpcError(0, customRevertException, null)});
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)customRevertException, (Object)exception.getMessage());
    }

    @Test
    void sendReportTransactionWhenEstimationJsonRpcErrorInData() {
        this.walletUtils.when(WalletUtils::getSettings).thenReturn((Object)this.globalSettings);
        this.walletUtils.when(() -> WalletUtils.convertToDecimals((double)ArgumentMatchers.anyDouble(), (int)ArgumentMatchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.globalSettings.getContractDetail()).thenReturn((Object)this.contractDetail);
        Mockito.when((Object)this.contractDetail.getDecimals()).thenReturn((Object)this.decimals);
        Mockito.when((Object)this.polygonContractGasProvider.getWeb3j()).thenReturn((Object)this.web3j);
        Mockito.when((Object)this.polygonContractGasProvider.getChainId()).thenReturn((Object)this.uemNetworkId);
        HubReportPayload reportPayload = this.newHubReportPayload();
        Mockito.when((Object)this.hubIdentityStorage.getHubWallet()).thenAnswer(invocation -> {
            WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
            Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
            Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
            Mockito.when((Object)this.codec.decode((String)ArgumentMatchers.any())).thenAnswer(args -> args.getArgument(0));
            return WalletUtils.toJsonString((Object)walletFile);
        });
        this.hubWalletStorage.setTransactionManager(this.transactionManager);
        this.hubWalletStorage.setTransactionReceiptProcessor(this.transactionReceiptProcessor);
        BigInteger nonce = BigInteger.TWO;
        Mockito.when((Object)this.web3j.ethGetTransactionCount(this.hubAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenAnswer(args -> {
            EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
            Request request = (Request)Mockito.mock(Request.class);
            Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
            Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)nonce);
            return request;
        });
        BigInteger gasPrice = BigInteger.valueOf(31L);
        Mockito.when((Object)this.polygonContractGasProvider.getGasPrice((String)ArgumentMatchers.any())).thenReturn((Object)gasPrice);
        Mockito.when((Object)this.transactionManager.getFromAddress()).thenReturn((Object)this.hubAddress);
        String customRevertException = "uem.customRevertExceptionInData";
        Mockito.when((Object)this.web3j.ethEstimateGas((Transaction)ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonRpcError(0, null, (Object)customRevertException)});
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubWalletStorage.sendReportTransaction(reportPayload, this.uemAddress, this.uemNetworkId));
        Assertions.assertEquals((Object)customRevertException, (Object)exception.getMessage());
    }

    public String generateWallet() {
        WalletFile walletFile = Wallet.createLight((String)this.password, (ECKeyPair)this.hubWallet);
        Mockito.when((Object)this.codecInitializer.getCodec()).thenReturn((Object)this.codec);
        Mockito.when((Object)this.codec.encode((String)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.walletAccountService.getAdminAccountPassword()).thenReturn((Object)this.password);
        Mockito.when((Object)this.walletAccountService.getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin")).thenAnswer(invocation -> WalletUtils.toJsonString((Object)walletFile));
        Assertions.assertNotNull((Object)this.walletAccountService.getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin"));
        return walletFile.getAddress();
    }

    void mockReportSentEventResponse() {
        EventValues eventValues = new EventValues(Arrays.asList(new Address(this.hubAddress), new Uint256(this.reportId)), null);
        this.contract.when(() -> Contract.staticExtractEventParameters((Event)((Event)ArgumentMatchers.any()), (Log)((Log)ArgumentMatchers.any()))).thenReturn((Object)eventValues);
    }

    public HubReportPayload newHubReportPayload() {
        return new HubReportPayload(this.reportId, this.hubAddress, this.deedId, this.fromDate(), this.toDate(), this.sentDate, RewardPeriodType.WEEK.name(), this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.tokensSent, this.topReceiverAmount, this.transactions());
    }

    private Instant toDate() {
        return Instant.ofEpochSecond(this.periodEndTime);
    }

    private Instant fromDate() {
        return Instant.ofEpochSecond(this.periodStartTime);
    }

    private TreeSet<String> transactions() {
        TreeSet<String> transactions = new TreeSet<String>();
        transactions.add(this.txHash);
        return transactions;
    }
}

