/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.HubController;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.WomConnectionRequest;
import jakarta.servlet.Filter;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={HubController.class, PortalAuthenticationManager.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
class HubControllerTest {
    private static final String TEST_USER = "testUser";
    private static final String TEST_PASSWORD = "testPassword";
    public static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private HubService hubService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @Mock
    private HubTenant hub;
    private MockMvc mockMvc;

    HubControllerTest() {
    }

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void testGetHubWhenAnonymous() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hub", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void testGetHubWhenExistsAndAnonymous() throws Exception {
        Mockito.lenient().when((Object)this.hubService.getHub(false)).thenReturn((Object)this.hub);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hub", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void testGetHubNotExistsWhenAdministrator() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void testGetHubWhenExists() throws Exception {
        Mockito.when((Object)this.hubService.getHub(false)).thenReturn((Object)this.hub);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void testConnectToWomWithoutBody() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    void testConnectToWomWithEmptyBody() throws Exception {
        WomConnectionRequest connectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    void testConnectToWomWithEmptyMandatoryField() throws Exception {
        WomConnectionRequest connectionRequest = new WomConnectionRequest();
        connectionRequest.setDeedId(2L);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        connectionRequest.setDeedManagerAddress("0x");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        connectionRequest.setSignedMessage("signedMessage");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        connectionRequest.setToken("token");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void testConnectToWomWhenException() throws Exception {
        WomConnectionRequest connectionRequest = new WomConnectionRequest();
        connectionRequest.setDeedId(2L);
        connectionRequest.setDeedManagerAddress("0x");
        connectionRequest.setSignedMessage("signedMessage");
        connectionRequest.setToken("token");
        Mockito.when((Object)this.hubService.connectToWoM(connectionRequest)).thenThrow(WomException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hub", (Object[])new Object[0]).with(this.testAdministrator()).content(HubControllerTest.asJsonString(connectionRequest)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isServiceUnavailable());
    }

    private RequestPostProcessor testAdministrator() {
        return SecurityMockMvcRequestPostProcessors.user((String)TEST_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("rewarding")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

