/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.service;

import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.hub.storage.HubIdentityStorage;
import io.meeds.tenant.hub.storage.HubWalletStorage;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.wiki.model.Page;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={HubService.class})
@ExtendWith(value={MockitoExtension.class})
class HubServiceTest {
    private static final String PUBLIC_DESCRIPTION_CMS_SETTING_NAME = "publicDescription";
    @MockBean
    private HubIdentityStorage hubIdentityStorage;
    @MockBean
    private HubWalletStorage hubWalletStorage;
    @MockBean
    private BrandingService brandingService;
    @MockBean
    private WomClientService womServiceClient;
    @MockBean
    private CMSService cmsService;
    @MockBean
    private LocaleConfigService localeConfigService;
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private NotePageViewService notePageViewService;
    @MockBean
    private ListenerService listenerService;
    @Mock
    private HubTenant hub;
    @Mock
    private PortalConfig portalConfig;
    @Mock
    private CMSSetting setting;
    @Mock
    private LocaleConfig localeConfig;
    @Mock
    private Page note;
    @Mock
    private Logo logo;
    @Autowired
    private HubService hubService;
    private long deedId = 35L;
    private short city = 1;
    private short cardType = (short)3;
    private String deedManagerAddress = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private String tokenId = "16968669685-8666328585-877411225";
    private String companyName = "companyName";
    private String defaultLanguage = "fr";
    private String noteContent = "Description";
    private Map<String, String> themeStyle = Collections.singletonMap("primaryColor", "#554863");
    private String hubAddress = "0x33f2694eC1eB5EEC902e6EA1De0A905aAcBaBb49";
    private String womAddress = "0x3Ef2694eC1eB5EEC902e6EA1De0A905aAcBaBb49";
    private String uemAddress = "0x290b11b1ab6a31fF95490e4e0EeffEC6402cce99";
    private long networkId = 80001L;
    private String rawMessage = "rawMessage";
    private String signedMessage = "signedMessage";

    HubServiceTest() {
    }

    @Test
    void getHubAddress() {
        String address = this.hubService.getHubAddress();
        Assertions.assertNull((Object)address);
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        address = this.hubService.getHubAddress();
        Assertions.assertEquals((Object)this.hubAddress, (Object)address);
    }

    @Test
    void isConnected() {
        Assertions.assertFalse((boolean)this.hubService.isConnected());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertFalse((boolean)this.hubService.isConnected());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Assertions.assertFalse((boolean)this.hubService.isConnected());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.hubService.isConnected());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertFalse((boolean)this.hubService.isConnected());
    }

    @Test
    void getHub() {
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertEquals((Object)this.hub, (Object)this.hubService.getHub());
    }

    @Test
    void getHubNoRefresh() {
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertEquals((Object)this.hub, (Object)this.hubService.getHub(false));
    }

    void getHubWithRefresh() {
        Mockito.when((Object)this.hubIdentityStorage.getHub(true)).thenReturn((Object)this.hub);
        Assertions.assertEquals((Object)this.hub, (Object)this.hubService.getHub(true));
    }

    @Test
    void getDeedId() {
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedId());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedId());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedId());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertEquals((long)this.deedId, (long)this.hubService.getDeedId());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedId());
    }

    @Test
    void getDeedCity() {
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedCity());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedCity());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.hub.getCity()).thenReturn((Object)this.city);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedCity());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertEquals((short)this.city, (short)this.hubService.getDeedCity());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedCity());
    }

    @Test
    void getDeedType() {
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedType());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedType());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.hub.getType()).thenReturn((Object)this.cardType);
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedType());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertEquals((short)this.cardType, (short)this.hubService.getDeedType());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertEquals((long)-1L, (long)this.hubService.getDeedType());
    }

    @Test
    void isDeedManager() {
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(null));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
        Mockito.when((Object)this.hub.getDeedManagerAddress()).thenReturn((Object)this.deedManagerAddress);
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Assertions.assertTrue((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(null));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager("0x0000000000000000000000000000000000000000"));
        Assertions.assertTrue((boolean)this.hubService.isDeedManager(this.deedManagerAddress.toUpperCase()));
        Assertions.assertTrue((boolean)this.hubService.isDeedManager(this.deedManagerAddress.toLowerCase()));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress.replace("1", "2")));
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress));
    }

    @Test
    void isDeedManagerByNftId() throws WomException {
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(null, this.deedId));
        Assertions.assertFalse((boolean)this.hubService.isDeedManager(this.deedManagerAddress, this.deedId));
        Mockito.when((Object)this.womServiceClient.isDeedManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.hubService.isDeedManager(this.deedManagerAddress, this.deedId));
    }

    @Test
    void generateWomToken() throws WomException {
        Assertions.assertNull((Object)this.hubService.generateWomToken());
        Mockito.when((Object)this.hubService.generateWomToken()).thenReturn((Object)this.tokenId);
        Assertions.assertEquals((Object)this.tokenId, (Object)this.hubService.generateWomToken());
    }

    @Test
    void getHubJoinDate() {
        Assertions.assertNull((Object)this.hubService.getHubJoinDate());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertNull((Object)this.hubService.getHubJoinDate());
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertNull((Object)this.hubService.getHubJoinDate());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Assertions.assertEquals((Object)this.hub.getJoinDate(), (Object)this.hubService.getHubJoinDate());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertNull((Object)this.hubService.getHubJoinDate());
    }

    @Test
    void getDeedManager() {
        Assertions.assertNull((Object)this.hubService.getDeedManager());
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Assertions.assertNull((Object)this.hubService.getDeedManager());
        Mockito.when((Object)this.hub.getDeedManagerAddress()).thenReturn((Object)this.deedManagerAddress);
        Assertions.assertNull((Object)this.hubService.getDeedManager());
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Assertions.assertNull((Object)this.hubService.getDeedManager());
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
        Assertions.assertEquals((Object)this.deedManagerAddress, (Object)this.hubService.getDeedManager());
        Mockito.when((Object)this.hub.getUntilDate()).thenReturn((Object)Instant.now().minusSeconds(1L));
        Assertions.assertNull((Object)this.hubService.getDeedManager());
    }

    @Test
    void connectToWoM() throws WomException {
        Mockito.when((Object)this.hubWalletStorage.getOrCreateHubAddress()).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        this.setHubCardProperties();
        WomConnectionResponse response = new WomConnectionResponse(this.deedId, this.hubAddress, this.womAddress, this.uemAddress, this.networkId);
        Mockito.when((Object)this.womServiceClient.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenReturn((Object)response);
        Mockito.when((Object)this.womServiceClient.generateToken()).thenReturn((Object)this.tokenId);
        WomConnectionRequest connectionRequest = new WomConnectionRequest(null, null, this.rawMessage, this.tokenId);
        this.hubService.connectToWoM(connectionRequest);
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).saveHubConnectionResponse((WomConnectionResponse)ArgumentMatchers.argThat(connectionResponse -> connectionResponse != null && connectionResponse.equals((Object)response)));
        ((WomClientService)Mockito.verify((Object)this.womServiceClient, (VerificationMode)Mockito.never())).saveHubAvatar((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any());
        Mockito.when((Object)this.logo.getData()).thenReturn((Object)new byte[3]);
        this.hubService.connectToWoM(connectionRequest);
        ((WomClientService)Mockito.verify((Object)this.womServiceClient, (VerificationMode)Mockito.never())).saveHubAvatar((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any());
        Mockito.when((Object)this.brandingService.getLogo()).thenReturn((Object)this.logo);
        this.hubService.connectToWoM(connectionRequest);
        ((WomClientService)Mockito.verify((Object)this.womServiceClient)).saveHubAvatar((String)ArgumentMatchers.eq((Object)this.hubAddress), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (InputStream)ArgumentMatchers.any());
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage, (VerificationMode)Mockito.atLeast((int)1))).getHub(true);
    }

    @Test
    void disconnectFromWomWhenDisconnected() {
        WomDisconnectionRequest disconnectionRequest = new WomDisconnectionRequest(this.hubAddress, null, this.deedManagerAddress, this.signedMessage, this.rawMessage, this.tokenId);
        Assertions.assertThrows(WomException.class, () -> this.hubService.disconnectFromWom(disconnectionRequest));
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).refreshHubIdentity();
    }

    @Test
    void disconnectFromWomWhenErrorThrown() throws WomException {
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        this.setHubConnected();
        WomDisconnectionRequest disconnectionRequest = new WomDisconnectionRequest(this.hubAddress, null, this.deedManagerAddress, this.signedMessage, this.rawMessage, this.tokenId);
        Mockito.when((Object)this.womServiceClient.disconnectFromWom(disconnectionRequest)).thenThrow(WomException.class);
        Assertions.assertThrows(WomException.class, () -> this.hubService.disconnectFromWom(disconnectionRequest));
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).refreshHubIdentity();
        ((WomClientService)Mockito.verify((Object)this.womServiceClient)).disconnectFromWom(disconnectionRequest);
    }

    @Test
    void disconnectFromWom() throws WomException {
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        this.setHubConnected();
        WomDisconnectionRequest disconnectionRequest = new WomDisconnectionRequest(this.hubAddress, this.signedMessage, this.deedManagerAddress, this.signedMessage, this.rawMessage, this.tokenId);
        this.hubService.disconnectFromWom(disconnectionRequest);
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).refreshHubIdentity();
        ((WomClientService)Mockito.verify((Object)this.womServiceClient)).disconnectFromWom(disconnectionRequest);
    }

    @Test
    void updateHubCardWhenNotConnected() throws WomException {
        this.hubService.updateHubCard();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.womServiceClient});
    }

    @Test
    void updateHubCardWhenChanged() throws WomException {
        Mockito.when((Object)this.hubIdentityStorage.getHubAddress()).thenReturn((Object)this.hubAddress);
        this.setHubConnected();
        this.setHubCardProperties();
        long logoUpdateTime = System.currentTimeMillis();
        Mockito.when((Object)this.brandingService.getLogo()).thenReturn((Object)this.logo);
        Mockito.when((Object)this.logo.getData()).thenReturn((Object)new byte[3]);
        Mockito.when((Object)this.logo.getUpdatedDate()).thenReturn((Object)logoUpdateTime);
        Mockito.when((Object)this.womServiceClient.generateToken()).thenReturn((Object)this.tokenId);
        Mockito.when((Object)this.hub.clone()).thenAnswer(invocation -> this.cloneHub(this.hub));
        this.hubService.updateHubCard();
        ((WomClientService)Mockito.verify((Object)this.womServiceClient)).saveHub((Hub)ArgumentMatchers.eq((Object)this.hub), ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)this.tokenId));
        ((HubIdentityStorage)Mockito.verify((Object)this.hubIdentityStorage)).saveHubAvatarUpdateTime(logoUpdateTime);
    }

    private void setHubConnected() {
        Mockito.when((Object)this.hubIdentityStorage.getHub(false)).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getDeedId()).thenReturn((Object)this.deedId);
    }

    private void setHubCardProperties() throws WomException {
        Mockito.when((Object)this.hubWalletStorage.signHubMessage((String)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.brandingService.getCompanyName()).thenReturn((Object)this.companyName);
        Mockito.when((Object)this.brandingService.getThemeStyle()).thenReturn(this.themeStyle);
        Mockito.when((Object)this.layoutService.getPortalConfig("public")).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        Mockito.when((Object)this.cmsService.getSetting("notePage", "publicHubSummary")).thenReturn((Object)this.setting);
        Mockito.when((Object)this.setting.getName()).thenReturn((Object)PUBLIC_DESCRIPTION_CMS_SETTING_NAME);
        Mockito.when((Object)this.localeConfig.getLanguage()).thenReturn((Object)this.defaultLanguage);
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.localeConfig);
        Mockito.when((Object)this.notePageViewService.getNotePage(this.setting.getName(), this.defaultLanguage)).thenReturn((Object)this.note);
        Mockito.when((Object)this.note.getContent()).thenReturn((Object)this.noteContent);
    }

    private HubTenant cloneHub(HubTenant hub) {
        return new HubTenant(hub.getDeedId(), hub.getCity(), hub.getType(), hub.getAddress(), hub.getName(), hub.getDescription(), hub.getUrl(), hub.getColor(), hub.getHubOwnerAddress(), hub.getDeedOwnerAddress(), hub.getDeedManagerAddress(), hub.getCreatedDate(), hub.getUntilDate(), hub.getJoinDate(), hub.getUpdatedDate(), hub.getUsersCount(), hub.getRewardsPeriodType(), hub.getRewardsPerPeriod(), hub.isConnected(), hub.getOwnerClaimableAmount(), hub.getManagerClaimableAmount(), hub.getWomServerUrl(), hub.getAdminAddress(), hub.getWomAddress(), hub.getUemAddress(), hub.getNetworkId(), hub.getAvatarUpdateTime());
    }
}

