/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.service;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.tenant.hub.constant.HubReportStatusType;
import io.meeds.tenant.hub.model.HubReportLocalStatus;
import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.tenant.hub.service.HubReportService;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.hub.storage.HubReportStorage;
import io.meeds.tenant.hub.storage.HubWalletStorage;
import io.meeds.tenant.hub.utils.EntityMapper;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.utils.WalletUtils;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.HubReportVerifiableData;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.web3j.crypto.Hash;

@SpringBootTest(classes={HubReportService.class})
@ExtendWith(value={MockitoExtension.class})
class HubReportServiceTest {
    private static final Pageable PAGEABLE = Pageable.ofSize((int)10);
    @MockBean
    private OrganizationService organizationService;
    @MockBean
    private RewardReportService rewardReportService;
    @MockBean
    private RealizationService realizationService;
    @MockBean
    private RuleService ruleService;
    @MockBean
    private HubService hubService;
    @MockBean
    private WomClientService womServiceClient;
    @MockBean
    private HubWalletStorage hubWalletStorage;
    @MockBean
    private HubReportStorage hubReportStorage;
    @MockBean
    private ListenerService listenerService;
    @Mock
    private RewardReport rewardReport;
    @Mock
    private RewardPeriod rewardPeriod;
    @Mock
    private TransactionDetail transaction;
    @Mock
    private HubTenant hub;
    @Mock
    private UserHandler userHandler;
    @Mock
    private ListAccess<User> listAccess;
    @Autowired
    private HubReportService hubReportService;
    private long periodStartTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long periodEndTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long reportId = 5L;
    private long rewardId = 7L;
    private short city = 1;
    private short cardType = (short)3;
    private short mintingPower = (short)120;
    private long maxUsers = Long.MAX_VALUE;
    private int ownerMintingPercentage = 60;
    private double fixedRewardIndex = 0.005446;
    private double ownerFixedIndex = 0.0032676;
    private double tenantFixedIndex = 0.0021784;
    private double lastPeriodUemRewardAmount = 84.0;
    private double uemRewardAmount = 90.0;
    private Instant updatedDate = Instant.now();
    private boolean fraud = false;
    private long periodId = 2L;
    private long deedId = 35L;
    private long usersCount = 125L;
    private long participantsCount = 85L;
    private long recipientsCount = 65L;
    private int achievementsCount = 55698;
    private int actionsCount = 76698;
    private double tokensSent = 52.3365;
    private double topReceiverAmount = 12.35;
    private String tokenAddress = "0x334d85047da64738c065d36e10b2adeb965000d0";
    private long tokenNetworkId = 1L;
    private long networkId = 80001L;
    private String uemAddress = "0x290b11b1ab6a31ff95490e4e0eeffec6402cce99";
    private String hubAddress = "0x290b11b1ab6a31ff95490e4e0eeffec6402cce99";
    private String deedManagerAddress = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private String ownerAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private String txHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";
    private Instant sentDate = Instant.now();
    private MockedStatic<WalletUtils> walletUtils;

    HubReportServiceTest() {
    }

    @BeforeEach
    void init() {
        this.walletUtils = Mockito.mockStatic(WalletUtils.class);
        this.walletUtils.when(WalletUtils::getNetworkId).thenReturn((Object)this.tokenNetworkId);
        this.walletUtils.when(WalletUtils::getContractAddress).thenReturn((Object)this.tokenAddress);
    }

    @AfterEach
    void close() {
        this.walletUtils.close();
    }

    @Test
    void sendReport() throws Exception {
        HubReportLocalStatus report = this.hubReportService.sendReport(this.periodId);
        Assertions.assertNull((Object)report, (String)"Shouldn't send report when Hub reward not found");
        Mockito.when((Object)this.rewardReportService.getRewardReportByPeriodId(this.periodId)).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.rewardReport.getPeriod()).thenReturn((Object)this.rewardPeriod);
        report = this.hubReportService.sendReport(this.periodId);
        Assertions.assertNull((Object)report, (String)"Shouldn't send report when not connected yet");
        Mockito.when((Object)this.hubService.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hubService.getHub(true)).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hubService.getHubAddress()).thenReturn((Object)this.hubAddress);
        Mockito.lenient().when((Object)this.hub.getAddress()).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hub.getUemAddress()).thenReturn((Object)this.uemAddress);
        Mockito.when((Object)this.hub.getNetworkId()).thenReturn((Object)this.networkId);
        Mockito.when((Object)this.hubService.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.userHandler.findAllUsers(UserStatus.ENABLED)).thenReturn(this.listAccess);
        Mockito.when((Object)this.listAccess.getSize()).thenReturn((Object)((int)this.usersCount));
        Mockito.when((Object)this.hubReportStorage.getSentDate(this.rewardPeriod)).thenReturn((Object)this.sentDate);
        report = this.hubReportService.sendReport(this.periodId);
        Assertions.assertNull((Object)report, (String)"Shouldn't send report when not completely processed yet");
        Mockito.when((Object)this.rewardReport.isCompletelyProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.rewardReport.getValidRewardCount()).thenReturn((Object)this.recipientsCount);
        Mockito.when((Object)this.rewardReport.getTokensSent()).thenReturn((Object)this.tokensSent);
        Mockito.when((Object)this.rewardReport.getValidRewards()).thenReturn(Collections.singleton(new WalletReward(1L, null, this.transaction, 0L, 0.0, 0.0, null, 0)));
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        Mockito.when((Object)this.rewardPeriod.getStartDateInSeconds()).thenReturn((Object)this.periodStartTime);
        Mockito.when((Object)this.rewardPeriod.getEndDateInSeconds()).thenReturn((Object)this.periodEndTime);
        Mockito.when((Object)this.rewardPeriod.getRewardPeriodType()).thenReturn((Object)RewardPeriodType.WEEK);
        Mockito.when((Object)this.transaction.getHash()).thenReturn((Object)this.txHash);
        Mockito.when((Object)this.transaction.getContractAmount()).thenReturn((Object)this.topReceiverAmount);
        Mockito.when((Object)this.transaction.isSucceeded()).thenReturn((Object)true);
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(), (Date)ArgumentMatchers.any())).thenReturn((Object)this.participantsCount);
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.argThat(filter -> filter != null && filter.getEarnerType() == IdentityType.USER && filter.getStatuses().contains(RealizationStatus.ACCEPTED) && filter.getFromDate().getTime() / 1000L == this.periodStartTime && filter.getToDate().getTime() / 1000L == this.periodEndTime))).thenReturn((Object)this.achievementsCount);
        Mockito.when((Object)this.ruleService.countRules((RuleFilter)ArgumentMatchers.any())).thenReturn((Object)this.actionsCount);
        Mockito.when((Object)this.hubWalletStorage.sendReportTransaction((HubReportPayload)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)this.reportId);
        HubReport hubReport = this.newHubReport();
        Mockito.when((Object)this.womServiceClient.saveReport((HubReportVerifiableData)ArgumentMatchers.any())).thenReturn((Object)hubReport);
        String signature = "0x22235879963145";
        String hash = StringUtils.lowerCase((String)Hash.sha3((String)signature));
        Mockito.when((Object)this.hubWalletStorage.signHubMessage((String)ArgumentMatchers.any())).thenReturn((Object)signature);
        report = this.hubReportService.sendReport(this.periodId);
        Assertions.assertNotNull((Object)report, (String)"Shouldn't send report when not completely processed yet");
        ((HubWalletStorage)Mockito.verify((Object)this.hubWalletStorage)).sendReportTransaction(this.newHubReportPayload(), this.uemAddress, this.networkId);
        ((HubReportStorage)Mockito.verify((Object)this.hubReportStorage)).saveStatus(this.rewardPeriod, HubReportStatusType.SENDING.name());
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("deed.tenant.report.sending", (Object)this.rewardPeriod.getId(), null);
        ((HubReportStorage)Mockito.verify((Object)this.hubReportStorage)).saveReportPeriodId(this.rewardPeriod, this.reportId);
        ((HubReportStorage)Mockito.verify((Object)this.hubReportStorage)).saveStatus(this.rewardPeriod, HubReportStatusType.SENT.name());
        ((HubReportStorage)Mockito.verify((Object)this.hubReportStorage)).saveSentDate((RewardPeriod)ArgumentMatchers.eq((Object)this.rewardPeriod), (Instant)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("deed.tenant.report.sent", (Object)this.rewardPeriod.getId(), (Object)this.reportId);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast("deed.tenant.report.error", (Object)this.rewardPeriod.getId(), null);
        ((WomClientService)Mockito.verify((Object)this.womServiceClient)).saveReport(new HubReportVerifiableData(hash, signature, (HubReportPayload)hubReport));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("deed.tenant.report.persistedInServer", (Object)this.reportId, null);
        Mockito.when((Object)this.hubWalletStorage.sendReportTransaction((HubReportPayload)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenThrow(IllegalStateException.class);
        Assertions.assertThrows(IllegalStateException.class, () -> this.hubReportService.sendReport(this.periodId));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("deed.tenant.report.error", (Object)this.rewardPeriod.getId(), null);
    }

    @Test
    void getReportWithRefreshWhenNoReportId() {
        Assertions.assertThrows(WomException.class, () -> this.hubReportService.getReport(this.periodId, true));
    }

    @Test
    void getReportWithRefreshWhenReportIdExistsButNotOnWom() {
        Mockito.when((Object)this.hubReportStorage.getReportId(this.periodId)).thenReturn((Object)this.reportId);
        Assertions.assertThrows(WomException.class, () -> this.hubReportService.getReport(this.periodId, true));
    }

    @Test
    void getReportWithRefreshWhenReportIdExists() throws WomException {
        Mockito.when((Object)this.hubReportStorage.getReportId(this.periodId)).thenReturn((Object)this.reportId);
        Mockito.when((Object)this.womServiceClient.retrieveReport(this.reportId)).thenAnswer(invocation -> this.newHubReport());
        Mockito.when((Object)this.rewardReportService.getRewardReportByPeriodId(this.periodId)).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.hubService.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hubService.getHub()).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hubService.getHubAddress()).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hubService.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.hubReportStorage.getSentDate(this.rewardPeriod)).thenReturn((Object)this.sentDate);
        Mockito.when((Object)this.transaction.getHash()).thenReturn((Object)this.txHash);
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(), (Date)ArgumentMatchers.any())).thenReturn((Object)this.participantsCount);
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.argThat(filter -> filter != null && filter.getEarnerType() == IdentityType.USER && filter.getStatuses().contains(RealizationStatus.ACCEPTED) && filter.getFromDate().getTime() / 1000L == this.periodStartTime && filter.getToDate().getTime() / 1000L == this.periodEndTime))).thenReturn((Object)this.achievementsCount);
        HubReportLocalStatus report = this.hubReportService.getReport(this.periodId, true);
        Assertions.assertEquals((Object)EntityMapper.toHubLocalReport((HubReportPayload)this.newHubReport(), (long)this.periodId, (long)this.reportId, (boolean)HubReportStatusType.SENT.isCanRefresh(), (boolean)HubReportStatusType.SENT.isCanSend(), (HubReportStatusType)HubReportStatusType.SENT, null), (Object)report);
    }

    @Test
    void getReportWithoutRefreshWhenNoReward() {
        Assertions.assertThrows(WomException.class, () -> this.hubReportService.getReport(this.periodId, false));
    }

    @Test
    void getReportNotSentToWomWithLocalRewardReport() throws Exception {
        Mockito.when((Object)this.rewardReportService.getRewardReportByPeriodId(this.periodId)).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.rewardReport.getPeriod()).thenReturn((Object)this.rewardPeriod);
        Mockito.when((Object)this.hubService.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hubService.getHub()).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hubService.getHubAddress()).thenReturn((Object)this.hubAddress);
        Mockito.lenient().when((Object)this.hub.getAddress()).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hubService.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.userHandler.findAllUsers(UserStatus.ENABLED)).thenReturn(this.listAccess);
        Mockito.when((Object)this.listAccess.getSize()).thenReturn((Object)((int)this.usersCount));
        Mockito.when((Object)this.hubReportStorage.getSentDate(this.rewardPeriod)).thenReturn((Object)this.sentDate);
        Mockito.when((Object)this.rewardReport.getValidRewardCount()).thenReturn((Object)this.recipientsCount);
        Mockito.when((Object)this.rewardReport.getTokensSent()).thenReturn((Object)this.tokensSent);
        Mockito.when((Object)this.rewardReport.getValidRewards()).thenReturn(Collections.singleton(new WalletReward(1L, null, this.transaction, 0L, 0.0, 0.0, null, 0)));
        Mockito.lenient().when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        Mockito.when((Object)this.rewardPeriod.getStartDateInSeconds()).thenReturn((Object)this.periodStartTime);
        Mockito.when((Object)this.rewardPeriod.getEndDateInSeconds()).thenReturn((Object)this.periodEndTime);
        Mockito.when((Object)this.rewardPeriod.getRewardPeriodType()).thenReturn((Object)RewardPeriodType.WEEK);
        Mockito.when((Object)this.transaction.getHash()).thenReturn((Object)this.txHash);
        Mockito.when((Object)this.transaction.getContractAmount()).thenReturn((Object)this.topReceiverAmount);
        Mockito.when((Object)this.transaction.isSucceeded()).thenReturn((Object)true);
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(), (Date)ArgumentMatchers.any())).thenReturn((Object)this.participantsCount);
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.argThat(filter -> filter != null && filter.getEarnerType() == IdentityType.USER && filter.getStatuses().contains(RealizationStatus.ACCEPTED) && filter.getFromDate().getTime() / 1000L == this.periodStartTime && filter.getToDate().getTime() / 1000L == this.periodEndTime))).thenReturn((Object)this.achievementsCount);
        Mockito.when((Object)this.ruleService.countRules((RuleFilter)ArgumentMatchers.any())).thenReturn((Object)this.actionsCount);
        HubReport hubReport = this.newHubReport();
        hubReport.setDeedId(-1L);
        HubReportLocalStatus report = this.hubReportService.getReport(this.periodId, false);
        Assertions.assertEquals((Object)EntityMapper.toHubLocalReport((HubReportPayload)hubReport, (long)0L, (long)0L, (boolean)false, (boolean)false, (HubReportStatusType)HubReportStatusType.INVALID, null), (Object)report);
        Mockito.when((Object)this.hubReportStorage.getStatus(this.rewardPeriod)).thenReturn((Object)"SENT");
        Mockito.when((Object)this.hubReportStorage.getReportId(this.rewardPeriod)).thenReturn((Object)this.reportId);
        Mockito.when((Object)this.hubReportStorage.getPeriodKey(this.rewardPeriod)).thenReturn((Object)this.periodId);
        hubReport = this.newHubReport();
        report = this.hubReportService.getReport(this.periodId, false);
        Assertions.assertEquals((Object)EntityMapper.toHubLocalReport((HubReportPayload)hubReport, (long)this.periodId, (long)this.reportId, (boolean)false, (boolean)false, (HubReportStatusType)HubReportStatusType.SENT, null), (Object)report);
    }

    @Test
    void getReportsWhenNoLocalRewards() {
        Page reports = this.hubReportService.getReports(PAGEABLE);
        Assertions.assertNotNull((Object)reports.getContent());
        Assertions.assertEquals((int)0, (int)reports.getContent().size());
    }

    @Test
    void getReportsWhenLocalRewardsNotSent() {
        Mockito.when((Object)this.rewardReportService.findRewardReportPeriods(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(this.rewardPeriod)));
        Page reports = this.hubReportService.getReports(PAGEABLE);
        Assertions.assertNotNull((Object)reports.getContent());
        Assertions.assertEquals((int)0, (int)reports.getContent().size());
    }

    @Test
    void getReportsWhenLocalRewardsSent() {
        Mockito.when((Object)this.rewardReportService.findRewardReportPeriods(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(this.rewardPeriod)));
        Mockito.when((Object)this.rewardReportService.getRewardReportByPeriodId(this.periodId)).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.hubService.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hubService.getHub()).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hubService.getHubAddress()).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hubService.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.hubReportStorage.getSentDate(this.rewardPeriod)).thenReturn((Object)this.sentDate);
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(), (Date)ArgumentMatchers.any())).thenReturn((Object)this.participantsCount);
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.argThat(filter -> filter != null && filter.getEarnerType() == IdentityType.USER && filter.getStatuses().contains(RealizationStatus.ACCEPTED) && filter.getFromDate().getTime() / 1000L == this.periodStartTime && filter.getToDate().getTime() / 1000L == this.periodEndTime))).thenReturn((Object)this.achievementsCount);
        Mockito.when((Object)this.ruleService.countRules((RuleFilter)ArgumentMatchers.any())).thenReturn((Object)this.actionsCount);
        Mockito.when((Object)this.hubReportStorage.getStatus(this.rewardPeriod)).thenReturn((Object)"SENT");
        Mockito.when((Object)this.hubReportStorage.getReportId(this.rewardPeriod)).thenReturn((Object)this.reportId);
        Mockito.when((Object)this.hubReportStorage.getPeriodKey(this.rewardPeriod)).thenReturn((Object)this.periodId);
        Page reports = this.hubReportService.getReports(PAGEABLE);
        Assertions.assertNotNull((Object)reports);
        Assertions.assertEquals((int)0, (int)reports.getContent().size());
    }

    private HubReportPayload newHubReportPayload() {
        return new HubReportPayload(this.reportId, StringUtils.lowerCase((String)this.hubAddress), this.deedId, this.fromDate(), this.toDate(), this.sentDate, RewardPeriodType.WEEK.name(), this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, StringUtils.lowerCase((String)this.tokenAddress), this.tokenNetworkId, this.tokensSent, this.topReceiverAmount, this.transactions());
    }

    private HubReport newHubReport() {
        return new HubReport(this.reportId, this.hubAddress, this.deedId, this.fromDate(), this.toDate(), this.sentDate, RewardPeriodType.WEEK.name(), this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.tokenAddress, this.tokenNetworkId, this.tokensSent, this.topReceiverAmount, this.transactions(), this.rewardId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedManagerAddress, this.ownerAddress, this.ownerMintingPercentage, this.fixedRewardIndex, this.ownerFixedIndex, this.tenantFixedIndex, this.fraud, this.lastPeriodUemRewardAmount, this.uemRewardAmount, this.updatedDate);
    }

    private Instant toDate() {
        return Instant.ofEpochSecond(this.periodEndTime);
    }

    private Instant fromDate() {
        return Instant.ofEpochSecond(this.periodStartTime);
    }

    private TreeSet<String> transactions() {
        TreeSet<String> transactions = new TreeSet<String>();
        transactions.add(this.transaction.getHash());
        return transactions;
    }
}

