/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.tenant.hub.storage.HubIdentityStorage;
import io.meeds.wallet.service.WalletTokenAdminService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.WomConnectionResponse;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={HubIdentityStorage.class})
@ExtendWith(value={MockitoExtension.class})
class HubIdentityStorageTest {
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private WomClientService womServiceClient;
    @MockBean
    private WalletTokenAdminService walletTokenAdminService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private HubIdentityStorage hubIdentityStorage;
    @Mock
    private Identity hubIdentity;
    @Mock
    private Hub hubFromWom;
    private Profile hubProfile;
    private String hubIdentityId = "1542";
    private String hubAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private short city = 1;
    private short cardType = (short)3;
    private double managerClaimableAmount = 0.225;
    private double ownerClaimableAmount = 0.225;
    private Instant createdDate = Instant.now();
    private Instant updatedDate = Instant.now();
    private Instant joinDate = Instant.now();
    private long deedId = 35L;
    private long usersCount = 125L;
    private double rewardsPerPeriod = 100.0;
    private String rewardsPeriodType = "WEEK";
    private String deedManagerAddress = "0xB36b174DC531B8055631A4E8d32f44eADC1B9695";
    private String color = "#544863";
    private String name = "name";
    private String url = "url";
    private String description = "description";
    private String ownerAddress = "0x27D282d1e7e790df596f50a234602d9e761d22aa";
    private String hubOwnerAddress = "0x609a6F01b7976439603356e41d5456b42df957b7";

    HubIdentityStorageTest() {
    }

    @BeforeEach
    void init() {
        this.hubIdentityStorage.refreshHubIdentity();
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("WALLET_HUB", "HUB")).thenReturn((Object)this.hubIdentity);
        this.hubProfile = new Profile(this.hubIdentity);
        this.hubProfile.setProperty("HUB_ADDRESS", (Object)this.hubAddress);
        Mockito.lenient().when((Object)this.hubIdentity.getProfile()).thenReturn((Object)this.hubProfile);
        Mockito.lenient().when((Object)this.hubIdentity.getId()).thenReturn((Object)this.hubIdentityId);
    }

    @Test
    void getHubWhenNotExistsInWom() {
        this.hubProfile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)this.hubIdentity.getProfile()).thenReturn((Object)this.hubProfile);
        Mockito.when((Object)this.hubProfile.getProperty((String)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.hubProfile.getProperty("HUB_ADDRESS")).thenReturn((Object)this.hubAddress);
        Mockito.when((Object)this.hubProfile.getProperty("HUB_NAME")).thenReturn((Object)("{\"name\":\"" + this.name + "\"}"));
        Mockito.when((Object)this.hubProfile.getIdentity()).thenReturn((Object)this.hubIdentity);
        Mockito.when((Object)this.hubProfile.getIdentity().getId()).thenReturn((Object)this.hubIdentityId);
        HubTenant hub = this.hubIdentityStorage.getHub();
        Assertions.assertNotNull((Object)hub);
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("DEED_ID");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("DEED_CITY");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("DEED_TYPE");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("DEED_OWNER_ADDRESS");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("DEED_MANAGER_ADDRESS");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_END_JOIN_DATE");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_PERIOD_TYPE");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_REWARDS_AMOUNT");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_OWNER_CLAIMABLE_AMOUNT");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_MANAGER_CLAIMABLE_AMOUNT");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_USERS_COUNT");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_ENABLED");
        ((Profile)Mockito.verify((Object)this.hubProfile)).removeProperty("HUB_AVATAR_UPDATE_TIME");
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_NAME");
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_DESCRIPTION");
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_URL");
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_OWNER_ADDRESS");
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_CREATED_DATE");
        ((Profile)Mockito.verify((Object)this.hubProfile, (VerificationMode)Mockito.never())).removeProperty("HUB_UPDATED_DATE");
        Assertions.assertEquals((Object)this.hubAddress, (Object)hub.getAddress());
    }

    @Test
    void getHubWhenExistsInWomButDisconnected() throws WomException {
        Mockito.when((Object)this.womServiceClient.getHub(this.hubAddress, false)).thenReturn((Object)this.hubFromWom);
        Mockito.when((Object)this.hubFromWom.getCity()).thenReturn((Object)this.city);
        Mockito.when((Object)this.hubFromWom.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.hubFromWom.getType()).thenReturn((Object)this.cardType);
        Mockito.when((Object)this.hubFromWom.getColor()).thenReturn((Object)this.color);
        Mockito.when((Object)this.hubFromWom.getCreatedDate()).thenReturn((Object)this.createdDate);
        Mockito.when((Object)this.hubFromWom.getUpdatedDate()).thenReturn((Object)this.updatedDate);
        Mockito.when((Object)this.hubFromWom.getHubOwnerAddress()).thenReturn((Object)this.hubOwnerAddress);
        Mockito.when((Object)this.hubFromWom.getDeedManagerAddress()).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.hubFromWom.getDeedOwnerAddress()).thenReturn((Object)this.ownerAddress);
        Mockito.when((Object)this.hubFromWom.getDescription()).thenReturn(Collections.singletonMap("en", this.description));
        Mockito.when((Object)this.hubFromWom.getName()).thenReturn(Collections.singletonMap("en", this.name));
        Mockito.when((Object)this.hubFromWom.getJoinDate()).thenReturn((Object)this.joinDate);
        Mockito.when((Object)this.hubFromWom.getManagerClaimableAmount()).thenReturn((Object)this.managerClaimableAmount);
        Mockito.when((Object)this.hubFromWom.getOwnerClaimableAmount()).thenReturn((Object)this.ownerClaimableAmount);
        Mockito.when((Object)this.hubFromWom.getRewardsPeriodType()).thenReturn((Object)this.rewardsPeriodType);
        Mockito.when((Object)this.hubFromWom.getRewardsPerPeriod()).thenReturn((Object)this.rewardsPerPeriod);
        Mockito.when((Object)this.hubFromWom.getUrl()).thenReturn((Object)this.url);
        Mockito.when((Object)this.hubFromWom.getUsersCount()).thenReturn((Object)this.usersCount);
        HubTenant hub = this.hubIdentityStorage.getHub();
        Assertions.assertNotNull((Object)hub);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.never())).updateProfile(this.hubProfile);
        this.hubProfile.setProperty("HUB_NAME", (Object)("{\"name\":\"" + this.name + "\"}"));
        this.hubIdentityStorage.refreshHubIdentity();
        hub = this.hubIdentityStorage.getHub();
        Assertions.assertNotNull((Object)hub);
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
        Assertions.assertFalse((boolean)hub.isConnected());
        Assertions.assertEquals((Object)this.hubAddress, (Object)hub.getAddress());
        Assertions.assertEquals((long)this.deedId, (long)hub.getDeedId());
        Assertions.assertEquals((short)this.city, (short)hub.getCity());
        Assertions.assertEquals((short)this.cardType, (short)hub.getType());
        Assertions.assertEquals((Object)this.color, (Object)hub.getColor());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.hubOwnerAddress), (Object)hub.getHubOwnerAddress());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.ownerAddress), (Object)hub.getDeedOwnerAddress());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.deedManagerAddress), (Object)hub.getDeedManagerAddress());
        Assertions.assertEquals(Collections.singletonMap("en", this.description), (Object)hub.getDescription());
        Assertions.assertEquals(Collections.singletonMap("en", this.name), (Object)hub.getName());
        Assertions.assertEquals((long)this.joinDate.getEpochSecond(), (long)hub.getJoinDate().getEpochSecond());
        Assertions.assertEquals((double)this.managerClaimableAmount, (double)hub.getManagerClaimableAmount());
        Assertions.assertEquals((double)this.ownerClaimableAmount, (double)hub.getOwnerClaimableAmount());
        Assertions.assertEquals((Object)this.rewardsPeriodType, (Object)hub.getRewardsPeriodType());
        Assertions.assertEquals((double)this.rewardsPerPeriod, (double)hub.getRewardsPerPeriod());
        Assertions.assertEquals((Object)this.url, (Object)hub.getUrl());
        Assertions.assertEquals((long)this.usersCount, (long)hub.getUsersCount());
    }

    @Test
    void getHubWhenExistsInWomWhenConnected() throws WomException {
        Mockito.when((Object)this.womServiceClient.getHub(this.hubAddress, false)).thenReturn((Object)this.hubFromWom);
        Mockito.when((Object)this.hubFromWom.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hubFromWom.getCity()).thenReturn((Object)this.city);
        Mockito.when((Object)this.hubFromWom.getDeedId()).thenReturn((Object)this.deedId);
        Mockito.when((Object)this.hubFromWom.getType()).thenReturn((Object)this.cardType);
        Mockito.when((Object)this.hubFromWom.getColor()).thenReturn((Object)this.color);
        Mockito.when((Object)this.hubFromWom.getCreatedDate()).thenReturn((Object)this.createdDate);
        Mockito.when((Object)this.hubFromWom.getUpdatedDate()).thenReturn((Object)this.updatedDate);
        Mockito.when((Object)this.hubFromWom.getHubOwnerAddress()).thenReturn((Object)this.hubOwnerAddress);
        Mockito.when((Object)this.hubFromWom.getDeedManagerAddress()).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.hubFromWom.getDeedOwnerAddress()).thenReturn((Object)this.ownerAddress);
        Mockito.when((Object)this.hubFromWom.getDescription()).thenReturn(Collections.singletonMap("en", this.description));
        Mockito.when((Object)this.hubFromWom.getName()).thenReturn(Collections.singletonMap("en", this.name));
        Mockito.when((Object)this.hubFromWom.getJoinDate()).thenReturn((Object)this.joinDate);
        Mockito.when((Object)this.hubFromWom.getManagerClaimableAmount()).thenReturn((Object)this.managerClaimableAmount);
        Mockito.when((Object)this.hubFromWom.getOwnerClaimableAmount()).thenReturn((Object)this.ownerClaimableAmount);
        Mockito.when((Object)this.hubFromWom.getRewardsPeriodType()).thenReturn((Object)this.rewardsPeriodType);
        Mockito.when((Object)this.hubFromWom.getRewardsPerPeriod()).thenReturn((Object)this.rewardsPerPeriod);
        Mockito.when((Object)this.hubFromWom.getUrl()).thenReturn((Object)this.url);
        Mockito.when((Object)this.hubFromWom.getUsersCount()).thenReturn((Object)this.usersCount);
        HubTenant hub = this.hubIdentityStorage.getHub();
        Assertions.assertNotNull((Object)hub);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.never())).updateProfile(this.hubProfile);
        this.hubProfile.setProperty("HUB_NAME", (Object)("{\"name\":\"" + this.name + "\"}"));
        this.hubIdentityStorage.refreshHubIdentity();
        hub = this.hubIdentityStorage.getHub();
        Assertions.assertNotNull((Object)hub);
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
        Assertions.assertTrue((boolean)hub.isConnected());
        Assertions.assertEquals((Object)this.hubAddress, (Object)hub.getAddress());
        Assertions.assertEquals((long)this.deedId, (long)hub.getDeedId());
        Assertions.assertEquals((short)this.city, (short)hub.getCity());
        Assertions.assertEquals((short)this.cardType, (short)hub.getType());
        Assertions.assertEquals((Object)this.color, (Object)hub.getColor());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.hubOwnerAddress), (Object)hub.getHubOwnerAddress());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.ownerAddress), (Object)hub.getDeedOwnerAddress());
        Assertions.assertEquals((Object)StringUtils.lowerCase((String)this.deedManagerAddress), (Object)hub.getDeedManagerAddress());
        Assertions.assertEquals(Collections.singletonMap("en", this.description), (Object)hub.getDescription());
        Assertions.assertEquals(Collections.singletonMap("en", this.name), (Object)hub.getName());
        Assertions.assertEquals((long)this.joinDate.getEpochSecond(), (long)hub.getJoinDate().getEpochSecond());
        Assertions.assertEquals((double)this.managerClaimableAmount, (double)hub.getManagerClaimableAmount());
        Assertions.assertEquals((double)this.ownerClaimableAmount, (double)hub.getOwnerClaimableAmount());
        Assertions.assertEquals((Object)this.rewardsPeriodType, (Object)hub.getRewardsPeriodType());
        Assertions.assertEquals((double)this.rewardsPerPeriod, (double)hub.getRewardsPerPeriod());
        Assertions.assertEquals((Object)this.url, (Object)hub.getUrl());
        Assertions.assertEquals((long)this.usersCount, (long)hub.getUsersCount());
    }

    @Test
    void getHubAddress() {
        Assertions.assertEquals((Object)this.hubAddress, (Object)this.hubIdentityStorage.getHubAddress());
        this.hubProfile.removeProperty("HUB_ADDRESS");
        Assertions.assertNull((Object)this.hubIdentityStorage.getHubAddress());
    }

    @Test
    void getHubWallet() {
        Assertions.assertNull((Object)this.hubIdentityStorage.getHubWallet());
        String wallet = "Wallet";
        this.hubProfile.setProperty("HUB_WALLET", (Object)wallet);
        Assertions.assertEquals((Object)wallet, (Object)this.hubIdentityStorage.getHubWallet());
    }

    @Test
    void saveHubWallet() {
        String wallet = "Wallet";
        this.hubIdentityStorage.saveHubWallet(this.hubAddress, wallet);
        Assertions.assertEquals((Object)wallet, (Object)this.hubProfile.getProperty("HUB_WALLET"));
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
    }

    @Test
    void saveHubConnectionResponse() {
        String womAddress = "womAddress";
        String uemAddress = "uemAddress";
        long networkId = 12L;
        WomConnectionResponse connectionResponse = new WomConnectionResponse();
        connectionResponse.setWomAddress(womAddress);
        connectionResponse.setUemAddress(uemAddress);
        connectionResponse.setNetworkId(networkId);
        this.hubIdentityStorage.saveHubConnectionResponse(connectionResponse);
        Assertions.assertEquals((Object)womAddress, (Object)this.hubProfile.getProperty("WOM_CONTRACT_ADDRESS"));
        Assertions.assertEquals((Object)uemAddress, (Object)this.hubProfile.getProperty("UEM_CONTRACT_ADDRESS"));
        Assertions.assertEquals((Object)networkId, (Object)this.hubProfile.getProperty("WOM_NETWORK_ID"));
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
    }

    @Test
    void saveHubAvatarUpdateTime() {
        long avatarUpdateTime = System.currentTimeMillis();
        this.hubIdentityStorage.saveHubAvatarUpdateTime(avatarUpdateTime);
        Assertions.assertEquals((Object)String.valueOf(avatarUpdateTime), (Object)this.hubProfile.getProperty("HUB_AVATAR_UPDATE_TIME"));
        ((IdentityManager)Mockito.verify((Object)this.identityManager)).updateProfile(this.hubProfile);
    }
}

