/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.authenticator;

import io.meeds.tenant.metamask.authenticator.MetamaskAuthenticator;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={MetamaskAuthenticator.class})
class MetamaskAuthenticatorTest {
    private static final String PASSWORD = "password";
    private static final String USERNAME = "username";
    @MockBean
    private MetamaskLoginService metamaskLoginService;
    @MockBean
    private Authenticator authenticator;
    @Autowired
    private MetamaskAuthenticator metamaskAuthenticator;

    MetamaskAuthenticatorTest() {
    }

    @Test
    void testValidateInvalidCredentialsCount() {
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(null));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[0]));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(USERNAME)}));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(null)}));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new PasswordCredential(PASSWORD)}));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new PasswordCredential(null)}));
    }

    @Test
    void testValidateInvalidPassword() {
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(null), new PasswordCredential(null)}));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(USERNAME), new PasswordCredential(PASSWORD)}));
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(USERNAME), new PasswordCredential("password@password@password")}));
    }

    @Test
    void testValidateNotExistingUser() {
        String walletAddress = "walletAddress";
        String otherUserName = "otherUserName";
        String rawMessage = "rawMessage";
        String signedMessage = "signedMessage";
        String composedPassword = walletAddress + "@" + rawMessage + "@" + signedMessage;
        Mockito.when((Object)this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage)).thenReturn((Object)true);
        Assertions.assertNull((Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(walletAddress), new PasswordCredential(composedPassword)}));
        Mockito.when((Object)this.metamaskLoginService.getUserWithWalletAddress(walletAddress)).thenReturn((Object)otherUserName);
        Assertions.assertEquals((Object)otherUserName, (Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(walletAddress), new PasswordCredential(composedPassword)}));
    }

    @Test
    void testValidateWithDifferentUsernameAsResult() {
        String walletAddress = "walletAddress";
        String rawMessage = "rawMessage";
        String signedMessage = "signedMessage";
        String username = USERNAME;
        Mockito.when((Object)this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage)).thenReturn((Object)true);
        Mockito.when((Object)this.metamaskLoginService.getUserWithWalletAddress(walletAddress)).thenReturn((Object)username);
        Assertions.assertEquals((Object)username, (Object)this.metamaskAuthenticator.validateUser(new Credential[]{new UsernameCredential(walletAddress), new PasswordCredential(walletAddress + "@" + rawMessage + "@" + signedMessage)}));
    }
}

