/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.listener;

import io.meeds.tenant.metamask.listener.NewMetamaskCreatedUserListener;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.service.WalletAccountService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={NewMetamaskCreatedUserListener.class})
class NewMetamaskCreatedUserListenerTest {
    @MockBean
    OrganizationService organizationService;
    @MockBean
    WalletAccountService walletAccountService;
    @MockBean
    IdentityManager identityManager;
    @Autowired
    NewMetamaskCreatedUserListener listener;

    NewMetamaskCreatedUserListenerTest() {
    }

    @Test
    void testNewMetamaskCreatedUserListenerWhenWalletExists() throws Exception {
        String username = "0x8714924ADEdB61b790d639F19c3D6F0FE2Cb7576";
        Wallet wallet = new Wallet();
        Mockito.when((Object)this.walletAccountService.getWalletByAddress(username)).thenReturn((Object)wallet);
        UserImpl user = new UserImpl(username);
        this.listener.postSave((User)user, true);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.identityManager});
        ((WalletAccountService)Mockito.verify((Object)this.walletAccountService, (VerificationMode)Mockito.times((int)0))).saveWallet((Wallet)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void testNewMetamaskCreatedUserListener() throws Exception {
        String username = "0x8714924ADEdB61b790d639F19c3D6F0FE2Cb7576";
        String identityId = "2554";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)identityId);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)identity);
        Wallet wallet = (Wallet)Mockito.mock(Wallet.class);
        Mockito.when((Object)this.walletAccountService.createWalletInstance(WalletProvider.METAMASK, username, Long.valueOf(identity.getId()).longValue())).thenReturn((Object)wallet);
        Mockito.when((Object)this.walletAccountService.saveWallet((Wallet)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> invocation.getArgument(0));
        UserImpl user = new UserImpl("not an address");
        this.listener.postSave((User)user, true);
        ((WalletAccountService)Mockito.verify((Object)this.walletAccountService, (VerificationMode)Mockito.times((int)0))).saveWallet((Wallet)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        user = new UserImpl(username);
        this.listener.postSave((User)user, false);
        ((WalletAccountService)Mockito.verify((Object)this.walletAccountService, (VerificationMode)Mockito.times((int)0))).saveWallet((Wallet)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        this.listener.postSave((User)user, true);
        ((WalletAccountService)Mockito.verify((Object)this.walletAccountService, (VerificationMode)Mockito.times((int)1))).saveWallet((Wallet)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }
}

