/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.metamask.FakeTestException;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import jakarta.servlet.http.HttpSession;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.picketlink.idm.api.SecureRandomProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={MetamaskLoginService.class})
class MetamaskLoginServiceTest {
    static final String SUPER_USER = "superUser";
    @MockBean
    private SecuritySettingService securitySettingService;
    @MockBean
    private OrganizationService organizationService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private SecureRandomProvider secureRandomProvider;
    @MockBean
    private AccountSetupService accountSetupService;
    @MockBean
    private HubService hubService;
    @MockBean
    private UserHandler userHandler;
    @Autowired
    MetamaskLoginService metamaskLoginService;

    MetamaskLoginServiceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.userAcl.getSuperUser()).thenReturn((Object)SUPER_USER);
    }

    @Test
    void testDontSetRootPasswordOnStartup() {
        this.metamaskLoginService.setAllowedRootWallets(Collections.emptyList());
        this.metamaskLoginService.init();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.organizationService});
    }

    @Test
    void testSetRootPasswordOnStartup() throws Exception {
        this.metamaskLoginService.init();
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.times((int)0))).saveUser((User)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userHandler.findUserByName(SUPER_USER)).thenReturn((Object)user);
        this.mockSecureRandomService();
        this.metamaskLoginService.setAllowedRootWallets(Collections.singletonList("0xAddress"));
        this.metamaskLoginService.init();
        ((User)Mockito.verify((Object)user, (VerificationMode)Mockito.times((int)1))).setPassword("1-2-3");
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.times((int)1))).saveUser(user, false);
    }

    @Test
    void testIsAllowUserRegistration() {
        Assertions.assertFalse((boolean)this.metamaskLoginService.isAllowUserRegistration());
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        Assertions.assertTrue((boolean)this.metamaskLoginService.isAllowUserRegistration());
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.RESTRICTED);
        Assertions.assertFalse((boolean)this.metamaskLoginService.isAllowUserRegistration());
    }

    @Test
    void testIsAddressAllowedToRegister() {
        String managerAddress = "managerAddress";
        Assertions.assertFalse((boolean)this.metamaskLoginService.isAllowUserRegistration(managerAddress));
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        Assertions.assertTrue((boolean)this.metamaskLoginService.isAllowUserRegistration(managerAddress));
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.RESTRICTED);
        Assertions.assertFalse((boolean)this.metamaskLoginService.isAllowUserRegistration(managerAddress));
        Mockito.when((Object)this.hubService.isDeedManager(managerAddress)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.metamaskLoginService.isAllowUserRegistration(managerAddress));
        Assertions.assertFalse((boolean)this.metamaskLoginService.isAllowUserRegistration("anyOtherAddress"));
    }

    @Test
    void testGetUserWithWalletAddress() throws Exception {
        String managerAddress = "managerAddress";
        Assertions.assertNull((Object)this.metamaskLoginService.getUserWithWalletAddress(managerAddress));
        Assertions.assertFalse((boolean)this.metamaskLoginService.isSuperUser(managerAddress));
        this.metamaskLoginService.setAllowedRootWallets(Collections.singletonList(managerAddress));
        try {
            Assertions.assertEquals((Object)SUPER_USER, (Object)this.metamaskLoginService.getUserWithWalletAddress(managerAddress));
            Assertions.assertTrue((boolean)this.metamaskLoginService.isSuperUser(managerAddress));
            Assertions.assertFalse((boolean)this.metamaskLoginService.isSuperUser("managerAddress2"));
        }
        finally {
            this.metamaskLoginService.setAllowedRootWallets(Collections.emptyList());
        }
        Assertions.assertNull((Object)this.metamaskLoginService.getUserWithWalletAddress(managerAddress));
        User user = (User)Mockito.mock(User.class);
        this.whenFindUserByName(managerAddress).thenReturn((Object)user);
        String managerUsername = "anotherUsername";
        Mockito.when((Object)user.getUserName()).thenReturn((Object)managerUsername);
        Assertions.assertEquals((Object)managerUsername, (Object)this.metamaskLoginService.getUserWithWalletAddress(managerAddress));
        this.whenFindUserByName(managerAddress).thenThrow(new Throwable[]{new FakeTestException()});
        Assertions.assertNull((Object)this.metamaskLoginService.getUserWithWalletAddress(managerAddress));
    }

    @Test
    void testValidateSignedMessage() {
        String walletAddress = "0x927f51a2996Ff74d1C380F92DC9006b53A225CeF";
        String rawMessage = "-2037692822791791745-3891968992033463560-1384458414145506416";
        String signedMessage = "0x92874882ac3b2292dc4a05af2f0eceac48fee97392a26d8bc9002159c35279ac0b72729cbdd6e864696782176a39a5cdfbca45c3eec5b34e1f82d2a906356a7d1c";
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage(null, rawMessage, signedMessage));
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage(walletAddress, null, signedMessage));
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, null));
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, walletAddress));
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage(walletAddress, walletAddress, signedMessage));
        Assertions.assertFalse((boolean)this.metamaskLoginService.validateSignedMessage("0x12eF3db2F4F2F2ace676d9EAABFaE4d98EFdA9f5", rawMessage, signedMessage));
        Assertions.assertTrue((boolean)this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage));
    }

    @Test
    void testGenerateLoginMessage() {
        this.mockSecureRandomService();
        Assertions.assertNotNull((Object)this.metamaskLoginService.generateLoginMessage(null));
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        String token = this.metamaskLoginService.generateLoginMessage(session);
        Assertions.assertNotNull((Object)token);
        ((HttpSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).setAttribute("metamask_login_message", (Object)token);
        Mockito.when((Object)session.getAttribute("metamask_login_message")).thenReturn((Object)token);
        String token2 = this.metamaskLoginService.generateLoginMessage(session);
        Assertions.assertEquals((Object)token, (Object)token2);
        token2 = this.metamaskLoginService.generateLoginMessage(session, false);
        Assertions.assertEquals((Object)token, (Object)token2);
        token2 = this.metamaskLoginService.generateLoginMessage(session, true);
        Assertions.assertNotEquals((Object)token, (Object)token2);
        ((HttpSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).setAttribute("metamask_login_message", (Object)token2);
    }

    private void mockSecureRandomService() {
        SecureRandom secureRandom = (SecureRandom)Mockito.mock(SecureRandom.class);
        Mockito.when((Object)this.secureRandomProvider.getSecureRandom()).thenReturn((Object)secureRandom);
        final AtomicLong index = new AtomicLong();
        Mockito.when((Object)secureRandom.nextLong()).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                return index.incrementAndGet();
            }
        });
    }

    private OngoingStubbing<User> whenFindUserByName(String managerAddress) throws Exception {
        return Mockito.when((Object)this.userHandler.findUserByName(managerAddress.toLowerCase()));
    }
}

