/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import io.meeds.tenant.metamask.web.MetamaskLoginExtension;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.web.ControllerContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={MetamaskLoginExtension.class})
class MetamaskLoginExtensionTest {
    @MockBean
    private MetamaskLoginService metamaskLoginService;
    @MockBean
    private ExoFeatureService exoFeatureService;
    @MockBean
    private HubService hubService;
    @Autowired
    private MetamaskLoginExtension metamaskLoginExtension;

    MetamaskLoginExtensionTest() {
    }

    @Test
    void testGetExtensionName() {
        Assertions.assertEquals(Collections.singletonList("LoginExtension"), (Object)this.metamaskLoginExtension.getExtensionNames());
    }

    @Test
    void testExtendParameters() {
        String rawMessage = "rawMessage";
        ControllerContext controllerContext = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)controllerContext.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getSession(ArgumentMatchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)this.exoFeatureService.isActiveFeature("metamaskLogin")).thenReturn((Object)true);
        Mockito.when((Object)this.metamaskLoginService.generateLoginMessage(session)).thenReturn((Object)rawMessage);
        Map extendParameters = this.metamaskLoginExtension.extendParameters(controllerContext, null);
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((Object)true, extendParameters.get("metamaskEnabled"));
        Assertions.assertEquals((Object)rawMessage, extendParameters.get("rawMessage"));
    }

    @Test
    void testDisableExtension() {
        String rawMessage = "rawMessage";
        ControllerContext controllerContext = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)controllerContext.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getSession(ArgumentMatchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)this.metamaskLoginService.generateLoginMessage(session)).thenReturn((Object)rawMessage);
        Mockito.when((Object)this.exoFeatureService.isActiveFeature("metamaskLogin")).thenReturn((Object)false);
        Map extendParameters = this.metamaskLoginExtension.extendParameters(controllerContext, null);
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((Object)false, extendParameters.get("metamaskEnabled"));
    }
}

