/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web.filter;

import io.meeds.tenant.metamask.FakeTestException;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import io.meeds.tenant.metamask.web.filter.MetamaskSignInFilter;
import io.meeds.tenant.metamask.web.filter.MetamaskSignInFilterDefinition;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.filter.FilterDefinition;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class MetamaskSignInFilterTest {
    private static final String CONTEXT_PATH = "/portal";
    private static final String USERNAME = "fakeUser";
    @Mock
    private WebAppController webAppController;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private RemindPasswordTokenService remindPasswordTokenService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private JavascriptConfigService javascriptConfigService;
    @Mock
    private SkinService skinService;
    @Mock
    private MetamaskLoginService metamaskLoginService;
    @Mock
    private ControllerContext controllerContext;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain chain;
    @Mock
    private ServletContext servletContext;
    @Mock
    private HttpSession session;
    @Mock
    private RequestDispatcher requestDispatcher;
    private PortalContainer container;
    private MetamaskSignInFilter filter;

    MetamaskSignInFilterTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new Object[]{this.metamaskLoginService, this.request, this.response, this.chain, this.servletContext, this.requestDispatcher});
        this.container = (PortalContainer)Mockito.mock(PortalContainer.class);
        Mockito.when((Object)this.container.getPortalContext()).thenReturn((Object)this.servletContext);
        this.filter = (MetamaskSignInFilter)Mockito.spy((Object)new MetamaskSignInFilter(this.container, this.remindPasswordTokenService, this.localeConfigService, this.brandingService, this.javascriptConfigService, this.skinService, this.metamaskLoginService));
    }

    @Test
    void testFilterDefinition() {
        MetamaskSignInFilterDefinition filterDefinition = new MetamaskSignInFilterDefinition(this.container, this.remindPasswordTokenService, this.localeConfigService, this.brandingService, this.javascriptConfigService, this.skinService, this.metamaskLoginService);
        Filter testFilter = filterDefinition.getFilter();
        Assert.assertNotNull((Object)testFilter);
        Assert.assertEquals(MetamaskSignInFilter.class, (Object)testFilter.getClass());
        List filterDefinitions = filterDefinition.getFilterDefinitions();
        Assert.assertNotNull((Object)filterDefinitions);
        Assert.assertEquals((long)1L, (long)filterDefinitions.size());
        Assert.assertNotNull(filterDefinitions.get(0));
        Assert.assertEquals(MetamaskSignInFilter.class, (Object)((FilterDefinition)filterDefinitions.get(0)).getFilter().getClass());
    }

    @Test
    void testNotForwardToSetupWhenNotDeedOwner() throws IOException, ServletException {
        Mockito.lenient().when((Object)this.metamaskLoginService.isAllowUserRegistration((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)USERNAME);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((ServletContext)Mockito.verify((Object)this.servletContext, (VerificationMode)Mockito.never())).getRequestDispatcher((String)ArgumentMatchers.any());
    }

    @Test
    void testCannotDisplayRegisterFormWhenSingedIn() throws IOException, ServletException {
        Mockito.lenient().when((Object)this.metamaskLoginService.isAllowUserRegistration((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)"SIGNED_MESSAGE@fakePassword");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)USERNAME);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.servletContext});
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Test
    void testContinueFilterChainEvenWhenErrorOccurs() throws IOException, ServletException {
        Mockito.lenient().when((Object)this.metamaskLoginService.isAllowUserRegistration((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.request.getParameter((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new FakeTestException()});
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.servletContext});
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Test
    void testCannotDisplayRegisterFormWhenDisabled() throws Exception {
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)USERNAME);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.servletContext});
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect((String)ArgumentMatchers.any());
    }

    @Test
    void testCannotDisplayRegisterFormWhenCredentialsNotValidated() throws Exception {
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)"fakePassword");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.servletContext});
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect((String)ArgumentMatchers.any());
    }

    @Test
    void testProceedToLoginWhenUserAlreadyRegistered() throws Exception {
        String walletAddress = USERNAME;
        String rawMessageToSign = "rawMessage";
        String signedMessage = "signedMessage";
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)walletAddress);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)("SIGNED_MESSAGE@" + signedMessage));
        Mockito.when((Object)this.metamaskLoginService.getUserWithWalletAddress(walletAddress)).thenReturn((Object)walletAddress);
        Mockito.when((Object)this.metamaskLoginService.getLoginMessage((HttpSession)ArgumentMatchers.any())).thenReturn((Object)rawMessageToSign);
        String compoundPassword = this.filter.getCompoundPassword(this.request);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect((String)ArgumentMatchers.any());
        ((ServletContext)Mockito.verify((Object)this.servletContext, (VerificationMode)Mockito.never())).getRequestDispatcher((String)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)ArgumentMatchers.argThat(servletRequest -> StringUtils.equals((CharSequence)walletAddress, (CharSequence)servletRequest.getParameter("username")) && StringUtils.equals((CharSequence)compoundPassword, (CharSequence)servletRequest.getParameter("password"))), (ServletResponse)ArgumentMatchers.any());
    }

    @Test
    void testFailToRegisterWhenNoUsernameInSession() throws Exception {
        Mockito.lenient().when((Object)this.metamaskLoginService.isAllowUserRegistration((String)ArgumentMatchers.any())).thenReturn((Object)true);
        String walletAddress = USERNAME;
        String rawMessageToSign = "rawMessage";
        String signedMessage = "signedMessage";
        Mockito.when((Object)this.request.getParameter("username")).thenReturn((Object)walletAddress);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)("SIGNED_MESSAGE@" + signedMessage));
        Mockito.when((Object)this.metamaskLoginService.getLoginMessage((HttpSession)ArgumentMatchers.any())).thenReturn((Object)rawMessageToSign);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.servletContext});
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect((String)ArgumentMatchers.any());
    }
}

