/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.integration.proxy;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.constant.TenantProvisioningStatus;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.service.ListenerService;
import io.meeds.deeds.service.TenantService;
import io.meeds.tenant.integration.SpringIntegration;
import io.meeds.tenant.integration.service.TenantServiceFacade;
import io.meeds.tenant.model.DeedTenantHost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="io.meeds.tenant.integration.service.TenantServiceFacade")
public class TenantServiceFacadeImpl
implements TenantServiceFacade {
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ListenerService listenerService;

    public DeedTenantHost getDeedTenant(long nftId) {
        if (nftId >= 0L && DeedTenantHost.getInstance() == null) {
            DeedTenant deedTenant = this.tenantService.getDeedTenant(nftId);
            if (deedTenant == null) {
                try {
                    deedTenant = this.tenantService.buildDeedTenantFromBlockchain(nftId);
                }
                catch (ObjectNotFoundException e) {
                    throw new IllegalStateException("Deed with NFT " + nftId + " doesn't exist on Blockchain");
                }
            }
            if (deedTenant != null) {
                boolean isProvisioned = deedTenant.getTenantProvisioningStatus() != null && deedTenant.getTenantProvisioningStatus() != TenantProvisioningStatus.STOP_CONFIRMED;
                return DeedTenantHost.setInstance((long)deedTenant.getNftId(), (short)deedTenant.getCityIndex(), (short)deedTenant.getCardType(), (boolean)isProvisioned, (String)deedTenant.getManagerAddress(), (String)deedTenant.getManagerEmail());
            }
        }
        return null;
    }

    @SpringIntegration
    public boolean isTenantManager(String address, long nftId) {
        return this.tenantService.isDeedManager(address, nftId);
    }

    public void initMetaverseIntegration() {
        this.listenerService.enable();
    }
}

