(function($, webNotif) {
  var IntranetNotification = {
      portletId : 'UIIntranetNotificationsPortlet',
      popupItem : null,
      delta : 65,
      hasMore : false,
      portlet : null,
      scrollBottom : function() {
        return $(document).height() - $(window).scrollTop() - $(window).height();
      },
      init : function() {
        var me = IntranetNotification;
        me.portlet = $('#' + me.portletId);
        //
        me.markAllReadLink = me.portlet.find('div#MarkAllAsReadLink:first').text();
        me.popupItem = me.portlet.find('ul.displayItems:first');
        me.popupItem.find('li').each(function(i) {
          me.applyAction($(this));
        });
        me.dataLoadMore = me.portlet.find('#ShowMoreLoader');
        me.hasMore = me.dataLoadMore.data('more');
        me.removeNotifURL = me.portlet.find('#removeNotif').text();
        me.addNotifURL = me.portlet.find('#addNotif').text();
        // Do not load more when open/reload browser
        $(window).on('beforeunload', function(){
          $(window).scrollTop(0);
        });
        // Only run scroll to load more when the DOM is fully loaded.
        $(document).ready(function() {
          me.initIndicator();
        });
        //
        if(me.hasMore == false) {
          me.portlet.find('div.bottomContainer').hide();
        }
        if(me.popupItem.find('li.unread').length > 0) {
          me.portlet.find('.actionMark:first').addClass('enabled');
        }
        // markAllRead
        me.portlet.find("#markAllReadLink").click(function(evt) {
          evt.stopPropagation();
          webNotif.ajaxReq(me.markAllReadLink, function() {
            webNotif.markAllRead();
          });
        });
      },
      initIndicator : function() {
        var me = IntranetNotification;
        //
        $('#UISiteBody').scroll(function(e) {
          // wait 200ms before call load more.
          if (me.T) {
            clearTimeout(me.T);
          }
          me.T = setTimeout(me.processScroll, 200);
        });
      },
      processScroll : function() {
        var me = IntranetNotification;
        if (me.hasMore && (me.scrollBottom() <= me.delta)) {
          me.hasMore = false;
          var loadAnimation = me.portlet.find('div.loadingIndicator:first').show();
          //
          webNotif.ajaxReq(me.dataLoadMore.data('url'), function(data) {
            loadAnimation.hide();
            var html = data.context;
            if (html && html.length > 0) {
              me.popupItem.append($('<ul></ul>').html(html).find('li'));
              me.popupItem.find('li').each(function(i) {
                me.applyAction($(this));
              });
            }
            //
            me.hasMore = data.hasMore;
            if(me.hasMore == false) {
              me.portlet.find('div.bottomContainer').hide();
            }
          });
        }
      },
      applyAction : function(item) {
        var me = IntranetNotification;
        item.find('.contentSmall:first').on('click', function(evt) {
          evt.stopPropagation();
          // mark read
          webNotif.markItemRead($(this).parents('li:first')).openURL($(this).data('link'));
        });
        // remove 'remove-icon'
        item.find('.remove-item').remove();
        // click action
        item.find('.action-item').off('click').on('click', function(evt) {
          evt.stopPropagation();
          webNotif.doAction($(this));
        });
        // cancel action
        item.find('.cancel-item').off('click').on('click', function(evt) {
          evt.stopPropagation();
          var id = $(this).parents('li:first').data('id');
          webNotif.doCancelAction(id, me.appendCSRFToken($(this).data('rest')));
        });

        var comment = item.find('.comment')[0];
        var commentNoHtml = item.find('.commentNoHtml')[0];
        var readMore = item.find('.readMore')[0];

        if (comment) {
            if (comment.offsetWidth < comment.scrollWidth || comment.offsetHeight < comment.scrollHeight) {
                $(comment).hide();
                $(commentNoHtml).html(comment.textContent + "...");
                $(commentNoHtml).show();
                $(readMore).show();

                $(readMore).on('click', function(evt) {
                    $(comment).show();
                    $(readMore).hide();
                    $(commentNoHtml).hide();
                    $(comment).css("max-height", "none");
                    evt.stopPropagation();
                });
            } else {
                $(readMore).hide();
            }
        }

        return item;
      },
      appendMessage : function(message) {
        var newItem = $($('<ul></ul>').html(message.body).html());
        var id = newItem.data('id');
        newItem.find('.remove-item').remove();
        //
        var existItem = IntranetNotification.popupItem.find('li[data-id=' + id + ']');
        var isExisting = existItem.length > 0;
        if (isExisting) {
          // this process only mentions case like or comment,
          // the content must be updated and NotificationID still kept
          existItem.hide();
          existItem.replaceWith(newItem);
        } else {
          IntranetNotification.popupItem.prepend(newItem.hide());
        }
        webNotif.showElm(IntranetNotification.applyAction(newItem));
        //
        webNotif.ajaxReq(IntranetNotification.addNotifURL);
        //
        IntranetNotification.portlet.find('.actionMark:first').addClass('enabled');
        IntranetNotification.popupItem.find('li.no-items').hide();
      },
      doCancelAction : function(object) {
        var elm = IntranetNotification.portlet.find('li[data-id=' + object.id + ']');
        webNotif.removeElm(elm, function(elm) {
          var ul = elm.parents('ul:first');
          if (ul.find('li').length == 2) {
            ul.find('li.no-items').show();
          }
        });
        //
        webNotif.ajaxReq(IntranetNotification.removeNotifURL);
      },
      markAllRead : function() {
        IntranetNotification.portlet.find('ul.displayItems:first').find('li.unread').removeClass('unread');
        IntranetNotification.portlet.find('.actionMark:first').removeClass('enabled');
      },
      appendCSRFToken : function(url) {
        url.indexOf('?') >= 0 ? url += '&' : url += '?';
        url += 'portal:csrf=' + eXo.env.portal.csrfToken;
        return url;
      }
  };
  //
  webNotif.register(IntranetNotification);
  return IntranetNotification;
})(gj, webNotifications);
