package org.exoplatform.social.service.malwareDetection.job;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.service.malwareDetection.MalwareDetectionService;

@DisallowConcurrentExecution
public class MalwareDetectionJob implements Job {
  private static final Log LOG = ExoLogger.getLogger(MalwareDetectionJob.class);

  @Override
  public void execute(JobExecutionContext context) throws JobExecutionException {
    MalwareDetectionService malwareDetectionService = CommonsUtils.getService(MalwareDetectionService.class);
    LOG.info("Start process malware detection");
    malwareDetectionService.checkAndProcessNewInfectedItems();
    LOG.info("End process malware detection");
  }

}
