/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.exception;

import java.util.ResourceBundle;

abstract public class ExoException extends Exception
{
   static final public int FATAL = 0;

   static final public int ERROR = 1;

   static final public int WARN = 2;

   static final public int INFO = 3;

   private int severity_ = INFO;

   public int getSeverity()
   {
      return severity_;
   }

   public void setSeverity(int severity)
   {
      severity_ = severity;
   }

   abstract public String getMessage(ResourceBundle res);

   abstract public String getExceptionDescription();

   abstract public String getErrorCode();
}
