/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.jpa;

import org.junit.AfterClass;
import org.junit.BeforeClass;

import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailDigestDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailParamDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailQueueDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.settings.jpa.SettingContextDAO;
import org.exoplatform.settings.jpa.SettingScopeDAO;
import org.exoplatform.settings.jpa.SettingsDAO;

public class CommonsDAOJPAImplTest extends BaseCommonsTestCase {
  protected SettingContextDAO settingContextDAO;

  protected SettingScopeDAO   settingScopeDAO;

  protected SettingsDAO       settingsDAO;

  protected MailDigestDAO     mailDigestDAO;

  protected MailNotifDAO      mailNotifDAO;

  protected MailParamDAO      mailParamsDAO;

  protected MailQueueDAO      mailQueueDAO;

  protected WebNotifDAO       webNotifDAO;

  protected WebParamsDAO      webParamsDAO;

  protected WebUsersDAO       webUsersDAO;

  public void setUp() throws Exception {
    super.setUp();

    // make sure data are well initialized for each test

    DataInitializer dataInitializer = getService(DataInitializer.class);
    dataInitializer.initData();

    // Init DAO
    settingContextDAO = getService(SettingContextDAO.class);
    settingScopeDAO = getService(SettingScopeDAO.class);
    settingsDAO = getService(SettingsDAO.class);
    mailDigestDAO = getService(MailDigestDAO.class);
    mailNotifDAO = getService(MailNotifDAO.class);
    mailParamsDAO = getService(MailParamDAO.class);
    mailQueueDAO = getService(MailQueueDAO.class);
    webNotifDAO = getService(WebNotifDAO.class);
    webParamsDAO = getService(WebParamsDAO.class);
    webUsersDAO = getService(WebUsersDAO.class);

    // Clean Data
    cleanDB();
  }

  public void testInit() {
    assertNotNull(settingContextDAO);
    assertNotNull(settingScopeDAO);
    assertNotNull(settingsDAO);
    assertNotNull(mailDigestDAO);
    assertNotNull(mailNotifDAO);
    assertNotNull(mailParamsDAO);
    assertNotNull(mailQueueDAO);
    assertNotNull(webNotifDAO);
    assertNotNull(webParamsDAO);
    assertNotNull(webUsersDAO);
  }

  public void tearDown() throws Exception {
    // Clean Data
    cleanDB();
    super.tearDown();
  }

  @BeforeClass
  @Override
  protected void beforeRunBare() {
    if (System.getProperty("gatein.test.output.path") == null) {
      System.setProperty("gatein.test.output.path", System.getProperty("java.io.tmpdir"));
    }
    super.beforeRunBare();
  }

  @AfterClass
  @Override
  protected void afterRunBare() {
    super.afterRunBare();
  }

  private void cleanDB() {
    settingsDAO.deleteAll();
    restartTransaction();
    settingScopeDAO.deleteAll();
    restartTransaction();
    settingContextDAO.deleteAll();
    restartTransaction();

    mailParamsDAO.deleteAll();
    restartTransaction();
    mailDigestDAO.deleteAll();
    restartTransaction();
    mailNotifDAO.deleteAll();
    restartTransaction();

    webParamsDAO.deleteAll();
    restartTransaction();
    webUsersDAO.deleteAll();
    restartTransaction();
    webNotifDAO.deleteAll();
    restartTransaction();

    mailQueueDAO.deleteAll();
    restartTransaction();
  }
}
