/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.notification.template;

import java.util.Locale;

import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;

public class SimpleElement implements Element {

  /**
   * The language
   */
  private String language;
  /**
   * The template
   */
  private String template;
  
  /**
   * The template configure
   */
  private PluginConfig pluginConfig;
  
  /**
   * need add new line tag
   */
  private boolean newLine = false;
  
  public SimpleElement() {
    this.language = Locale.ENGLISH.getLanguage();
  }
  
  @Override
  public String getLanguage() {
    return language;
  }

  @Override
  public ElementVisitor accept(ElementVisitor visitor) {
    return visitor.visit(this);
  }

  @Override
  public String getTemplate() {
    return this.template;
  }

  @Override
  public Element language(String language) {
    this.language = language;
    return this;
  }

  @Override
  public Element template(String template) {
    this.template = template;
    return this;
  }
  
  @Override
  public Element config(PluginConfig templateConfig) {
    this.pluginConfig = templateConfig;
    return this;
  }
  
  
  @Override
  public String toString() {
    return "[language = " + this.language +"; template = " + this.template + "]";
  }

  @Override
  public PluginConfig getPluginConfig() {
    return this.pluginConfig;
  }

  @Override
  public Element addNewLine(boolean needNewLine) {
    this.newLine = needNewLine;
    return this;
  }

  @Override
  public boolean isNewLine() {
    return this.newLine;
  }
}