/*
 * This file is part of the Meeds project (https://meeds.io/).
 * 
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import './initComponents.js';
import './services.js';

// get overrided components if exists
if (extensionRegistry) {
  const components = extensionRegistry.loadComponents('UserSettingSecurity');
  if (components && components.length > 0) {
    components.forEach(cmp => {
      Vue.component(cmp.componentName, cmp.componentOptions);
    });
  }
}

//getting language of user
const lang = eXo && eXo.env.portal.language || 'en';

//should expose the locale ressources as REST API 
const url = `/social/i18n/locale.portlet.social.UserSettings?lang=${lang}`;

const appId = 'UserSettingSecurity';

document.dispatchEvent(new CustomEvent('displayTopBarLoading'));

export function init(ssoEnabled, isEmailEditable) {
  if (!isEmailEditable && ssoEnabled) {
    Vue.prototype.$updateApplicationVisibility(false, document.querySelector(`#${appId}`));
  } else {
    exoi18n.loadLanguageAsync(lang, url).then(i18n => {
      const appElement = document.createElement('div');
      appElement.id = appId;
  
      Vue.createApp({
        data: {
          ssoEnabled,
          isEmailEditable,
        },
        mounted() {
          document.dispatchEvent(new CustomEvent('hideTopBarLoading'));
        },
        template: `<user-setting-security id="${appId}" v-cacheable />`,
        i18n,
        vuetify: Vue.prototype.vuetifyOptions,
      }, appElement, 'User Settings Security');
    });
  }
}
