/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.frameworks.cometd.ext;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;

@Path("/transfer/")
public class TransferMessages
   implements ResourceContainer
{

   @POST
   @Path("/ext/sendprivatemessage/")
   @Consumes(MediaType.APPLICATION_JSON)
   public Response sendMessage(DelegateMessage transportData)
   {
      ContinuationServiceDelegate transport = getCometdTransport();
      transport.sendMessage(transportData.getExoId(), transportData.getChannel(), transportData.getMessage(),
               transportData.getId());
      return Response.ok().build();
   }

   @POST
   @Path("/ext/sendbroadcastmessage/")
   @Consumes(MediaType.APPLICATION_JSON)
   public Response sendBroadcastMessage(DelegateMessage data)
   {
      ContinuationServiceDelegate transport = getCometdTransport();
      transport.sendBroadcastMessage(data.getChannel(), data.getMessage(), data.getId());
      return Response.ok().build();
   }

   private ContinuationServiceDelegate getCometdTransport()
   {
      ExoContainer container = ExoContainerContext.getCurrentContainer();
      ContinuationServiceDelegate transport =
               (ContinuationServiceDelegate) container.getComponentInstanceOfType(ContinuationServiceDelegate.class);
      return transport;
   }

}
