/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.search.dao.impl;

import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

import java.util.List;

public class IndexingOperationDAOImpl extends GenericDAOJPAImpl<IndexingOperation, Long> implements IndexingOperationDAO {

  @Override
  @ExoTransactional
  public List<IndexingOperation> findAllFirst(Integer maxResults) {
      return getEntityManager()
              .createNamedQuery("IndexingOperation.findAll", IndexingOperation.class)
              .setMaxResults(maxResults)
              .getResultList();
  }

  @Override
  @ExoTransactional
  public void deleteAllIndexingOperationsHavingIdLessThanOrEqual(long id) {
    getEntityManager()
        .createNamedQuery("IndexingOperation.deleteAllIndexingOperationsHavingIdLessThanOrEqual")
        .setParameter("id", id)
        .executeUpdate();
  }

  @Override
  public List<IndexingOperation> findAll(int offset, int limit) {
    return getEntityManager()
        .createNamedQuery("IndexingOperation.findAll", IndexingOperation.class)
        .setFirstResult(offset)
        .setMaxResults(limit)
        .getResultList();
  }
}

