/*
 * This file is part of the Meeds project (https://meeds.io/).
 * 
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
import './initComponents.js';

// get overrided components if exists
if (extensionRegistry) {
  const components = extensionRegistry.loadComponents('SpaceCreation');
  if (components && components.length > 0) {
    components.forEach(cmp => {
      Vue.component(cmp.componentName, cmp.componentOptions);
    });
  }
}

//getting language of user
const lang = eXo?.env?.portal?.language || 'en';

//should expose the locale ressources as REST API 
const url = `/social/i18n/locale.portlet.social.SpaceCreation?lang=${lang}`;

export function init(appId, settings, isAdministrator, saveSettingsUrl, spaceTemplates) {
  exoi18n.loadLanguageAsync(lang, url).then(i18n => {
    // init Vue app when locale ressources are ready
    if (!settings.labelTranslations) {
      settings.labelTranslations = {};
    }
    if (!settings.spaceTemplateIds.length) {
      if (spaceTemplates?.length) {
        settings.spaceTemplateIds = spaceTemplates.map(t => t.id);
      } else {
        settings.spaceTemplateIds = [];
      }
    }
    if (!settings.spaceCreationTemplateChoice) {
      settings.spaceCreationTemplateChoice = 'anyTemplate';
    }
    Vue.createApp({
      data: {
        settings,
        isAdministrator,
        saveSettingsUrl,
        availableSpaceTemplates: spaceTemplates
      },
      computed: {
        label() {
          return this.settings.labelTranslations?.[eXo.env.portal.language] || this.settings.labelTranslations?.[eXo.env.portal.defaultLanguage] || this.$t('space.creation.instantiation.create.button');
        },
        spaceTemplates() {
          return this.availableSpaceTemplates.filter(t => !this.settings?.spaceTemplateIds || this.settings?.spaceTemplateIds?.includes?.(t.id));
        },
      },
      template: `<space-creation id="${appId}" />`,
      i18n,
      vuetify: Vue.prototype.vuetifyOptions,
    }, `#${appId}`, 'Space Creation');
  });
}
