/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ActivitySearchProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ActivitySearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ActivitySearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private final ConfigurationManager configurationManager;
    private final ActivitySearchProcessor activitySearchProcessor;
    private final IdentityManager identityManager;
    private final ActivityStorage activityStorage;
    private final ElasticSearchingClient client;
    private String index;
    private String searchType;
    private String searchQueryFilePath;
    private String searchQuery;

    public ActivitySearchConnector(ActivitySearchProcessor activitySearchProcessor, IdentityManager identityManager, ActivityStorage activityStorage, ConfigurationManager configurationManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.activitySearchProcessor = activitySearchProcessor;
        this.identityManager = identityManager;
        this.activityStorage = activityStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<ActivitySearchResult> search(Identity viewerIdentity, ActivitySearchFilter filter, long offset, long limit) {
        if (viewerIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((String)filter.getTerm())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Set<Long> streamFeedOwnerIds = this.activityStorage.getStreamFeedOwnerIds(viewerIdentity);
        String esQuery = this.buildQueryStatement(streamFeedOwnerIds, filter, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index, this.searchType);
        return this.buildResult(jsonResponse, viewerIdentity, streamFeedOwnerIds);
    }

    private String buildQueryStatement(Set<Long> streamFeedOwnerIds, ActivitySearchFilter filter, long offset, long limit) {
        String term = this.removeSpecialCharacters(filter.getTerm());
        List termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if ((word = word.trim()).length() > 5) {
                word = word + "~1";
            }
            return word;
        }).collect(Collectors.toList());
        String termQuery = StringUtils.join(termsQuery, (String)" AND ");
        return this.retrieveSearchQuery().replaceAll("@term@", term).replaceAll("@term_query@", termQuery).replaceAll("@permissions@", StringUtils.join(streamFeedOwnerIds, (String)",")).replaceAll("@offset@", String.valueOf(offset)).replaceAll("@limit@", String.valueOf(limit));
    }

    private List<ActivitySearchResult> buildResult(String jsonResponse, Identity viewerIdentity, Set<Long> streamFeedOwnerIds) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<ActivitySearchResult> results = new ArrayList<ActivitySearchResult>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                ActivitySearchResult activitySearchResult = new ActivitySearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                Long id = this.parseLong(hitSource, "id");
                Long posterId = this.parseLong(hitSource, "posterId");
                Long parentId = this.parseLong(hitSource, "parentId");
                Long streamOwner = this.parseLong(hitSource, "streamOwner");
                if (!streamFeedOwnerIds.contains(streamOwner)) {
                    LOG.warn("Activity '{}' is returned in seach result while it's not permitted to user {}. Ignore it.", new Object[]{id, viewerIdentity.getId()});
                    continue;
                }
                Long postedTime = this.parseLong(hitSource, "postedTime");
                Long lastUpdatedTime = (Long)hitSource.get((Object)"lastUpdatedDate");
                String body = (String)hitSource.get((Object)"body");
                String type = (String)hitSource.get((Object)"type");
                JSONObject hightlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                JSONArray bodyExcepts = (JSONArray)hightlightSource.get((Object)"body");
                String[] bodyExceptsArray = (String[])bodyExcepts.toArray((Object[])new String[0]);
                List<String> excerpts = Arrays.asList(bodyExceptsArray);
                if (parentId == null) {
                    activitySearchResult.setId(id);
                    if (lastUpdatedTime != null) {
                        activitySearchResult.setLastUpdatedTime(lastUpdatedTime);
                    }
                    if (postedTime != null) {
                        activitySearchResult.setPostedTime(postedTime);
                    }
                    if (streamOwner != null) {
                        Identity streamOwnerIdentity = this.identityManager.getIdentity(streamOwner.toString());
                        activitySearchResult.setStreamOwner(streamOwnerIdentity);
                    }
                    if (posterId != null) {
                        Identity posterIdentity = this.identityManager.getIdentity(posterId.toString());
                        activitySearchResult.setPoster(posterIdentity);
                    }
                    activitySearchResult.setBody(body);
                    activitySearchResult.setType(type);
                    activitySearchResult.setExcerpts(excerpts);
                } else {
                    ActivitySearchResult commentSearchResult = new ActivitySearchResult();
                    commentSearchResult.setId(id);
                    if (lastUpdatedTime != null) {
                        commentSearchResult.setLastUpdatedTime(lastUpdatedTime);
                    }
                    if (postedTime != null) {
                        commentSearchResult.setPostedTime(postedTime);
                    }
                    if (streamOwner != null) {
                        Identity streamOwnerIdentity = this.identityManager.getIdentity(streamOwner.toString());
                        commentSearchResult.setStreamOwner(streamOwnerIdentity);
                    }
                    if (posterId != null) {
                        Identity posterIdentity = this.identityManager.getIdentity(posterId.toString());
                        commentSearchResult.setPoster(posterIdentity);
                    }
                    commentSearchResult.setBody(body);
                    commentSearchResult.setType(type);
                    commentSearchResult.setExcerpts(excerpts);
                    activitySearchResult.setComment(commentSearchResult);
                    this.activitySearchProcessor.formatSearchResult(commentSearchResult);
                    this.transformActivityToResult(activitySearchResult, parentId);
                }
                results.add(activitySearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing activity search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private void transformActivityToResult(ActivitySearchResult activitySearchResult, Long parentId) {
        ActivityStream activityStream;
        ExoSocialActivity activity = this.activityStorage.getActivity(parentId.toString());
        activitySearchResult.setType(activity.getType());
        activitySearchResult.setId(Long.parseLong(activity.getId()));
        if (activity.getUpdated() != null) {
            activitySearchResult.setLastUpdatedTime(activity.getUpdated().getTime());
        }
        if (activity.getPostedTime() != null) {
            activitySearchResult.setPostedTime(activity.getPostedTime());
        }
        if ((activityStream = activity.getActivityStream()) != null) {
            String prettyId = activityStream.getPrettyId();
            String providerId = activityStream.getType().getProviderId();
            Identity streamOwnerIdentity = this.identityManager.getOrCreateIdentity(providerId, prettyId);
            activitySearchResult.setStreamOwner(streamOwnerIdentity);
        }
        if (activity.getPosterId() != null) {
            Identity posterIdentity = this.identityManager.getIdentity(activity.getPosterId());
            activitySearchResult.setPoster(posterIdentity);
        }
        if (StringUtils.isNotBlank((String)activity.getTitle())) {
            activitySearchResult.setBody(activity.getTitle());
        } else {
            activitySearchResult.setBody(activity.getBody());
        }
        this.activitySearchProcessor.formatSearchResult(activitySearchResult);
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((String)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replaceAll("'", " ");
        return string;
    }
}

