/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonStack;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;

public class JsonParserImpl
implements JsonParser {
    private JsonHandler eventHandler;
    private final JsonStack<JsonUtils.JsonToken> stack = new JsonStack();
    private PushbackReader pushbackReader;

    @Override
    public void parse(Reader reader, JsonHandler eventHandler) throws JsonException {
        this.pushbackReader = new PushbackReader(reader);
        this.eventHandler = eventHandler;
        this.stack.clear();
        char c = '\u0000';
        while ((c = this.next()) != '\u0000') {
            if (c == '{') {
                this.readObject();
                continue;
            }
            if (c == '[') {
                this.readArray();
                continue;
            }
            throw new JsonException("Syntax error. Unexpected '" + c + "'. Must be '{'.");
        }
        if (!this.stack.isEmpty()) {
            throw new JsonException("Syntax error. Missing one or more close bracket(s).");
        }
    }

    @Override
    public void parse(InputStream sream, JsonHandler eventHandler) throws JsonException {
        this.parse(new InputStreamReader(sream, JsonUtils.DEFAULT_CHARSET), eventHandler);
    }

    private void readObject() throws JsonException {
        char c = '\u0000';
        this.eventHandler.startObject();
        this.stack.push(JsonUtils.JsonToken.object);
        block11: while (true) {
            c = this.next();
            switch (c) {
                case '\u0000': {
                    throw new JsonException("Syntax error. Unexpected end of object. Object must end by '}'.");
                }
                case '{': {
                    this.readObject();
                    continue block11;
                }
                case '}': {
                    this.eventHandler.endObject();
                    if (JsonUtils.JsonToken.object != this.stack.pop()) {
                        throw new JsonException("Syntax error. Unexpected end of object.");
                    }
                    c = this.next();
                    switch (c) {
                        case '\u0000': {
                            break;
                        }
                        case ',': 
                        case ']': 
                        case '}': {
                            this.back(c);
                            break;
                        }
                        default: {
                            throw new JsonException("Syntax error. Excpected for ',' or ']' or '}' but found '" + c + "'.");
                        }
                    }
                    return;
                }
                case '[': {
                    this.readArray();
                    continue block11;
                }
                case ',': {
                    continue block11;
                }
            }
            this.back(c);
            this.readKey();
            this.next(':');
            c = this.next();
            this.back(c);
            if (c == '{' || c == '[') continue;
            this.readValue();
        }
    }

    private void readArray() throws JsonException {
        char c = '\u0000';
        this.eventHandler.startArray();
        this.stack.push(JsonUtils.JsonToken.array);
        block11: while (true) {
            c = this.next();
            switch (c) {
                case '\u0000': {
                    throw new JsonException("Syntax error. Unexpected end of array. Array must end by ']'.");
                }
                case ']': {
                    this.eventHandler.endArray();
                    if (JsonUtils.JsonToken.array != this.stack.pop()) {
                        throw new JsonException("Syntax error. Unexpected end of array.");
                    }
                    c = this.next();
                    switch (c) {
                        case '\u0000': {
                            break;
                        }
                        case ',': 
                        case ']': 
                        case '}': {
                            this.back(c);
                            break;
                        }
                        default: {
                            throw new JsonException("Syntax error. Excpected for ',' or ']' or '}' but found '" + c + "'.");
                        }
                    }
                    return;
                }
                case '[': {
                    this.readArray();
                    continue block11;
                }
                case '{': {
                    this.readObject();
                    continue block11;
                }
                case ',': {
                    continue block11;
                }
            }
            this.back(c);
            this.readValue();
        }
    }

    private void readKey() throws JsonException {
        char c = this.next();
        if (c != '\"') {
            throw new JsonException("Syntax error. Key must start from quote, but found '" + c + "'.");
        }
        this.back(c);
        String s = new String(this.nextString());
        if (s.length() == 2) {
            throw new JsonException("Missing key.");
        }
        this.eventHandler.key(s.substring(1, s.length() - 1));
    }

    private void readValue() throws JsonException {
        char c = this.next();
        this.back(c);
        if (c == '\"') {
            this.eventHandler.characters(this.nextString());
        } else {
            CharArrayWriter cw = new CharArrayWriter();
            while ("{[,]}\"".indexOf(c = this.next()) < 0) {
                if (c == '\u0000') {
                    throw new JsonException("Unexpected end of stream.");
                }
                cw.append(c);
            }
            this.back(c);
            this.eventHandler.characters(cw.toCharArray());
        }
        c = this.next(",]}");
        this.back(c);
    }

    private char next() throws JsonException {
        try {
            int c = 0;
            while ((c = this.pushbackReader.read()) != -1) {
                if (c == 47) {
                    c = this.pushbackReader.read();
                    if (c == 47) {
                        while ((c = this.pushbackReader.read()) != -1 && c != 10 && c != 13) {
                        }
                        continue;
                    }
                    if (c == 42) {
                        while ((c = this.pushbackReader.read()) != 42 || (c = this.pushbackReader.read()) != 47) {
                            if (c != -1) continue;
                            throw new JsonException("Syntax error. Missing end of comment.");
                        }
                        continue;
                    }
                    this.back((char)c);
                    return '/';
                }
                if (c != -1 && c <= 32) continue;
            }
            return c == -1 ? (char)'\u0000' : (char)c;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    private char nextAny() throws JsonException {
        try {
            int c = this.pushbackReader.read();
            return c == -1 ? (char)'\u0000' : (char)c;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    private char next(char c) throws JsonException {
        char n = this.next();
        if (n != c) {
            throw new JsonException("Expected for '" + c + "' but found '" + n + "'.");
        }
        return n;
    }

    private char next(String s) throws JsonException {
        char n = this.next();
        if (s.indexOf(n) >= 0) {
            return n;
        }
        char[] ch = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (char c : ch) {
            if (i > 0) {
                sb.append(" or ");
            }
            ++i;
            sb.append('\'').append(c).append('\'');
        }
        throw new JsonException("Expected for " + sb.toString() + " but found '" + n + "'.");
    }

    private char[] next(int n) throws JsonException {
        char[] buff = new char[n];
        try {
            int i = this.pushbackReader.read(buff);
            if (i == -1) {
                throw new JsonException("Unexpected end of stream.");
            }
            return buff;
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    private char[] nextString() throws JsonException {
        CharArrayWriter cw = new CharArrayWriter();
        char c = this.nextAny();
        cw.append(c);
        block13: while (true) {
            c = this.nextAny();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw new JsonException("Syntax error. Unterminated string.");
                }
                case '\\': {
                    c = this.nextAny();
                    switch (c) {
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            throw new JsonException("Syntax error. Unterminated string");
                        }
                        case 'n': {
                            cw.append('\n');
                            continue block13;
                        }
                        case 'r': {
                            cw.append('\r');
                            continue block13;
                        }
                        case 'b': {
                            cw.append('\b');
                            continue block13;
                        }
                        case 't': {
                            cw.append('\t');
                            continue block13;
                        }
                        case 'f': {
                            cw.append('\f');
                            continue block13;
                        }
                        case 'u': {
                            String s = new String(this.next(4));
                            cw.append((char)Integer.parseInt(s, 16));
                            continue block13;
                        }
                    }
                    cw.append(c);
                    continue block13;
                }
            }
            cw.append(c);
            if (c == '\"') break;
        }
        return cw.toCharArray();
    }

    private void back(char c) throws JsonException {
        try {
            this.pushbackReader.unread(c);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }
}

