/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

public class SkinResourceRequestHandler
extends WebRequestHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";
    private final SkinService skinService;

    public SkinResourceRequestHandler(SkinService skinService) {
        this.skinService = skinService;
    }

    public String getHandlerName() {
        return "skin";
    }

    public boolean execute(final ControllerContext context) throws Exception {
        long cssLastModified;
        String compressParam = context.getParameter(ResourceRequestHandler.COMPRESS_QN);
        boolean compress = "min".equals(compressParam);
        final HttpServletResponse response = context.getResponse();
        long ifModifiedSince = context.getRequest().getDateHeader(IF_MODIFIED_SINCE);
        if (this.isNotModified(ifModifiedSince, cssLastModified = this.skinService.getLastModified(context))) {
            response.setStatus(304);
            return true;
        }
        response.setContentType("text/css; charset=UTF-8");
        ServletOutputStream out = response.getOutputStream();
        final BinaryOutput output = new BinaryOutput((OutputStream)out){
            final /* synthetic */ OutputStream val$out;
            {
                this.val$out = outputStream;
            }

            public Charset getCharset() {
                return UTF_8;
            }

            public void write(byte b) throws IOException {
                this.val$out.write(b);
            }

            public void write(byte[] bytes) throws IOException {
                this.val$out.write(bytes);
            }

            public void write(byte[] bytes, int off, int len) throws IOException {
                this.val$out.write(bytes, off, len);
            }
        };
        ResourceRenderer renderer = new ResourceRenderer(){

            @Override
            public BinaryOutput getOutput() {
                return output;
            }

            @Override
            public void setExpiration(long seconds) {
                if (seconds > 0L) {
                    response.addHeader("Cache-Control", "max-age=" + seconds + ",s-maxage=" + seconds);
                } else {
                    response.setHeader("Cache-Control", "no-cache");
                }
                long lastModified = SkinResourceRequestHandler.this.skinService.getLastModified(context);
                response.setDateHeader(SkinResourceRequestHandler.LAST_MODIFIED, lastModified);
                response.setDateHeader(SkinResourceRequestHandler.EXPIRES, System.currentTimeMillis() + 604800000L);
            }
        };
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        try {
            if (this.skinService.renderCSS(context, renderer, compress)) {
                return true;
            }
            this.log.warn((Object)("CSS " + resource + " not found"));
            return false;
        }
        catch (Exception e) {
            if (!(e instanceof SocketException)) {
                if (e.getClass().toString().contains("ClientAbortException")) {
                    return true;
                }
                this.log.error((Object)("Could not render css " + resource), (Throwable)e);
            }
            return false;
        }
    }

    private boolean isNotModified(long ifModifedSince, long lastModified) {
        return !PropertyManager.isDevelopping() && ifModifedSince >= lastModified;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }
}

