/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.List;

public class ExpressionOperator
extends ASTCssNode {
    private Operator operator;

    public ExpressionOperator(HiddenTokenAwareTree underlyingStructure) {
        this(underlyingStructure, Operator.EMPTY_OPERATOR);
    }

    public ExpressionOperator(HiddenTokenAwareTree underlyingStructure, Operator operator) {
        super(underlyingStructure);
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.EXPRESSION_OPERATOR;
    }

    public String toString() {
        return "" + this.operator.getSymbol();
    }

    @Override
    public ExpressionOperator clone() {
        return (ExpressionOperator)super.clone();
    }

    public static enum Operator {
        SOLIDUS("/"),
        COMMA(","),
        STAR("*"),
        EMPTY_OPERATOR("' '"),
        MINUS("-"),
        PLUS("+");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

