/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.portal.config.GroupVisibilityPlugin;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpacesAdministrationService;

public class SpaceCreationInvitationGroupVisibilityPlugin
extends GroupVisibilityPlugin {
    public static final String MANAGER = "manager";
    public static final String ANY = "*";
    private UserACL userACL;
    private SpacesAdministrationService spacesAdministrationService;
    private List<String> spacesAdministratorsGroups;

    public SpaceCreationInvitationGroupVisibilityPlugin(UserACL userACL, SpacesAdministrationService spacesAdministrationService) {
        this.userACL = userACL;
        this.spacesAdministrationService = spacesAdministrationService;
    }

    public boolean hasPermission(Identity userIdentity, Group group) {
        if (this.userACL.getSuperUser().equals(userIdentity.getUserId()) || userIdentity.getMemberships().stream().anyMatch(userMembership -> userMembership.getGroup().equals(this.userACL.getAdminGroups()))) {
            return true;
        }
        Collection userMemberships = userIdentity.getMemberships();
        if (this.spacesAdministratorsGroups == null) {
            this.spacesAdministratorsGroups = this.spacesAdministrationService.getSpacesAdministratorsMemberships().stream().map(membershipEntry -> membershipEntry.getGroup()).collect(Collectors.toList());
        }
        return userMemberships.stream().anyMatch(userMembership -> !((!group.getId().startsWith("/spaces/") && !group.getId().equals("/spaces") || !this.spacesAdministratorsGroups.contains(userMembership.getGroup()) && !userMembership.getGroup().equals(group.getId()) && !userMembership.getGroup().startsWith(group.getId() + "/")) && (!userMembership.getGroup().equals(group.getId()) && !userMembership.getGroup().startsWith(group.getId() + "/") || !userMembership.getMembershipType().equals(ANY) && !userMembership.getMembershipType().equals(MANAGER))));
    }
}

