/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Qualifier;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.AbstractContainer;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.context.ContextManager;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.spi.DefinitionByName;
import org.exoplatform.container.spi.DefinitionByQualifier;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.container.spi.InterceptorChainFactoryProvider;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoContainer
extends AbstractContainer {
    private static final long serialVersionUID = -8068506531004854036L;
    private static volatile String PROFILES;
    private static Set<String> SET_PROFILES;
    protected final AtomicBoolean stopping = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean ctxManagerLoaded = new AtomicBoolean();
    private ContextManager ctxManager;
    protected static final Log LOG;
    private final Map<String, ComponentLifecyclePlugin> componentLifecylePlugin_ = new HashMap<String, ComponentLifecyclePlugin>();
    private final List<ContainerLifecyclePlugin> containerLifecyclePlugin_ = new ArrayList<ContainerLifecyclePlugin>();
    protected final ExoContainerContext context = new ExoContainerContext(this, this.getClass().getSimpleName());
    protected final ExoContainer parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getProfilesFromProperty() {
        String profiles = PropertyManager.getProperty((String)"exo.profiles");
        if ((profiles != null || PROFILES == null) && (profiles == null || profiles.equals(PROFILES))) return SET_PROFILES;
        Class<ExoContainer> clazz = ExoContainer.class;
        synchronized (ExoContainer.class) {
            if ((profiles != null || PROFILES == null) && (profiles == null || profiles.equals(PROFILES))) return SET_PROFILES;
            SET_PROFILES = ExoContainer.getProfiles(profiles);
            PROFILES = profiles;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SET_PROFILES;
        }
    }

    public static Set<String> getProfiles() {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        if (currentContainer == null) {
            LOG.warn((Object)"No container detected in current thread, return default containers profiles");
            return ExoContainer.getProfilesFromProperty();
        }
        ConfigurationManager manager = currentContainer.getComponentInstanceOfType(ConfigurationManager.class);
        return manager.getProfiles();
    }

    public static boolean hasProfileInProperty(String profileName) {
        return ExoContainer.getProfilesFromProperty().contains(profileName);
    }

    public static boolean hasProfile(String profileName) {
        return ExoContainer.getProfiles().contains(profileName);
    }

    private static Set<String> getProfiles(String profileList) {
        HashSet<String> profiles = new HashSet<String>();
        if (profileList != null) {
            for (String profile : profileList.split(",")) {
                profiles.add(profile.trim());
            }
        }
        return Collections.unmodifiableSet(profiles);
    }

    public ExoContainer() {
        this((ExoContainer)null);
    }

    public ExoContainer(ExoContainer parent) {
        this.parent = parent;
        this.delegate = InterceptorChainFactoryProvider.getInterceptorChainFactory().getInterceptorChain(this, parent);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExoContainer.this.registerComponentInstance(ExoContainer.this.context);
                return null;
            }
        });
    }

    public ExoContainerContext getContext() {
        return this.context;
    }

    private static String getPluginName(ContainerLifecyclePlugin plugin) {
        String name = plugin.getName();
        if (name == null || name.length() == 0) {
            name = plugin.getClass().getName();
        }
        return name;
    }

    protected void initContainerInternal() {
        ConfigurationManager manager = this.getComponentInstanceOfType(ConfigurationManager.class);
        ContainerUtil.addContainerLifecyclePlugin(this, manager);
        ContainerUtil.addComponentLifecyclePlugin(this, manager);
        ContainerUtil.addComponents(this, manager);
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.initContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
        Collection<ExternalComponentPlugins> unusedPlugins = this.getExternalComponentPluginsUnused();
        if (unusedPlugins != null && PropertyManager.isDevelopping()) {
            for (ExternalComponentPlugins plugins : unusedPlugins) {
                LOG.warn("Some external plugins has for target '{}' which is unknown, please configure it or define the annotation 'DefinitionByType' to enable the auto-registration on the target", new Object[]{plugins.getTargetComponent()});
            }
        }
    }

    @Override
    public synchronized void dispose() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeDisposed()) {
            this.destroyContainerInternal();
            super.dispose();
            this.disposed.set(true);
        }
    }

    public synchronized void start(boolean init) {
        if (init) {
            this.initialize();
        }
        this.start();
    }

    @Override
    public synchronized void initialize() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeInitialized()) {
            super.initialize();
            this.initContainerInternal();
            this.initialized.set(true);
        }
    }

    @Override
    public synchronized void start() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeStarted()) {
            super.start();
            this.startContainerInternal();
            this.started.set(true);
        }
    }

    @Override
    public synchronized void stop() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (this.canBeStopped()) {
            this.stopping.set(true);
            this.stopContainerInternal();
            super.stop();
            this.started.set(false);
        }
    }

    private void startContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.startContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    private void stopContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.stopContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    private void destroyContainerInternal() {
        for (ContainerLifecyclePlugin plugin : this.containerLifecyclePlugin_) {
            try {
                plugin.destroyContainer(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurs with the ContainerLifecyclePlugin '" + ExoContainer.getPluginName(plugin) + "'"), (Throwable)e);
            }
        }
    }

    public void addComponentLifecylePlugin(ComponentLifecyclePlugin plugin) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        List<String> list = plugin.getManageableComponents();
        for (String component : list) {
            this.componentLifecylePlugin_.put(component, plugin);
        }
    }

    public void addContainerLifecylePlugin(ContainerLifecyclePlugin plugin) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.containerLifecyclePlugin_.add(plugin);
    }

    protected Configuration getConfiguration() {
        ConfigurationManager cm = this.getComponentInstanceOfType(ConfigurationManager.class);
        return cm == null ? null : cm.getConfiguration();
    }

    protected Collection<ExternalComponentPlugins> getExternalComponentPluginsUnused() {
        Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            return null;
        }
        ArrayList<ExternalComponentPlugins> result = null;
        Iterator<ExternalComponentPlugins> it = configuration.getExternalComponentPluginsIterator();
        while (it.hasNext()) {
            boolean toAdd;
            ExternalComponentPlugins plugins;
            block9: {
                plugins = it.next();
                toAdd = false;
                String target = plugins.getTargetComponent();
                if (target == null) {
                    toAdd = true;
                } else if (configuration.getComponent(target) == null) {
                    try {
                        Class c = ClassLoading.loadClass((String)target, ExoContainer.class);
                        if (!c.isAnnotation() && this.getComponentAdapterOfType(c) == null) {
                            toAdd = true;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!LOG.isTraceEnabled()) break block9;
                        LOG.trace("The class {} could not be found", new Object[]{target});
                    }
                }
            }
            if (!toAdd) continue;
            if (result == null) {
                result = new ArrayList<ExternalComponentPlugins>();
            }
            result.add(plugins);
        }
        return result;
    }

    protected void unregisterAllComponents() {
        Collection<ComponentAdapter<?>> adapters = this.getComponentAdapters();
        for (ComponentAdapter<?> adapter : adapters) {
            this.unregisterComponent(adapter.getComponentKey());
        }
    }

    public <T> ComponentAdapter<T> registerComponentImplementation(Class<T> componentImplementation) throws ContainerException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public <T> ComponentAdapter<T> registerComponentInstance(T componentInstance) throws ContainerException {
        return this.registerComponentInstance(componentInstance.getClass(), componentInstance);
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public ComponentAdapter<?> getComponentAdapter(Object componentKey) {
        return this.getComponentAdapter(componentKey, Object.class);
    }

    public Object getComponentInstance(Object componentKey) {
        return this.getComponentInstance(componentKey, Object.class);
    }

    @Managed
    @ManagedName(value="RegisteredComponentNames")
    @ManagedDescription(value="Return the list of the registered component names")
    public Set<String> getRegisteredComponentNames() throws ContainerException {
        HashSet<String> names = new HashSet<String>();
        Collection<ComponentAdapter<?>> adapters = this.getComponentAdapters();
        for (ComponentAdapter<?> adapter : adapters) {
            Object key = adapter.getComponentKey();
            String name = String.valueOf(key);
            names.add(name);
        }
        return names;
    }

    public ExoContainer getParent() {
        return this.parent;
    }

    public boolean canBeStarted() {
        return !this.disposed.get() && !this.started.get();
    }

    public boolean canBeStopped() {
        return !this.disposed.get() && this.started.get();
    }

    public boolean canBeDisposed() {
        return !this.disposed.get();
    }

    protected boolean canBeInitialized() {
        return !this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager getContextManager() {
        if (this.ctxManagerLoaded.get()) {
            return this.ctxManager;
        }
        ExoContainer exoContainer = this;
        synchronized (exoContainer) {
            if (this.ctxManagerLoaded.get()) {
                return this.ctxManager;
            }
            this.ctxManager = this.getComponentInstanceOfType(ContextManager.class, false);
            this.ctxManagerLoaded.set(true);
        }
        return this.ctxManager;
    }

    public boolean isContextManagerLoaded() {
        return this.ctxManagerLoaded.get();
    }

    public <T> T getComponentInstanceOfType(Class<T> componentType) {
        return this.getComponentInstanceOfType(componentType, true);
    }

    @Override
    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        T result = super.getComponentInstanceOfType(componentType, autoRegistration);
        if (result != null || !autoRegistration) {
            return result;
        }
        if (componentType.isAnnotationPresent(DefinitionByType.class) && this.autoRegister(DefinitionType.TYPE, null, componentType)) {
            return super.getComponentInstanceOfType(componentType, false);
        }
        return result;
    }

    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType) {
        return this.getComponentAdapterOfType(componentType, true);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> result = super.getComponentAdapterOfType(componentType, autoRegistration);
        if (result != null || !autoRegistration) {
            return result;
        }
        if (componentType.isAnnotationPresent(DefinitionByType.class) && this.autoRegister(DefinitionType.TYPE, null, componentType)) {
            return super.getComponentAdapterOfType(componentType, false);
        }
        return result;
    }

    private <T> boolean autoRegister(final DefinitionType definitionType, final Object componentKey, final Class<T> componentType) {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class<?> type;
                Class[] containers;
                if (definitionType == DefinitionType.TYPE) {
                    DefinitionByType definition = componentType.getAnnotation(DefinitionByType.class);
                    containers = definition.target();
                    type = definition.type();
                } else if (definitionType == DefinitionType.NAME) {
                    DefinitionByName definition = componentType.getAnnotation(DefinitionByName.class);
                    if (!definition.named().equals(componentKey)) {
                        return false;
                    }
                    containers = definition.target();
                    type = definition.type();
                } else {
                    DefinitionByQualifier definition = componentType.getAnnotation(DefinitionByQualifier.class);
                    if (!definition.qualifier().equals(componentKey)) {
                        return false;
                    }
                    containers = definition.target();
                    type = definition.type();
                }
                if (!ExoContainer.this.accepts(containers)) {
                    return false;
                }
                if (type.equals(Void.TYPE)) {
                    if (componentType.isInterface() || Modifier.isAbstract(componentType.getModifiers())) {
                        throw new IllegalArgumentException("The class " + componentType.getName() + " is an interface or an abstract class so it cannot be automatically registered without a type.");
                    }
                    if (definitionType == DefinitionType.TYPE) {
                        ExoContainer.this.registerComponentImplementation(componentType);
                    } else {
                        ExoContainer.this.registerComponentImplementation(componentKey, componentType);
                    }
                } else {
                    if (!componentType.isAssignableFrom(type)) {
                        throw new IllegalArgumentException("The class " + type.getName() + " must be a sub class of " + componentType.getName() + ".");
                    }
                    if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
                        throw new IllegalArgumentException("The class " + type.getName() + " is an interface or an abstract class so it cannot be used as default implementation.");
                    }
                    if (definitionType == DefinitionType.TYPE) {
                        ExoContainer.this.registerComponentImplementation(componentType, type);
                    } else {
                        ExoContainer.this.registerComponentImplementation(componentKey, type);
                    }
                }
                return true;
            }
        });
    }

    private boolean accepts(Class<? extends ExoContainer>[] containers) {
        for (Class<? extends ExoContainer> clazz : containers) {
            if (!this.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public <T> T getComponentInstance(Object componentKey, Class<T> bindType) {
        return this.getComponentInstance(componentKey, bindType, true);
    }

    @Override
    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        Class annotationType;
        T result = super.getComponentInstance(componentKey, bindType, autoRegistration);
        if (result != null || !autoRegistration || Object.class.equals(bindType)) {
            return result;
        }
        if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
            Class componentType = (Class)componentKey;
            if (componentType.isAnnotationPresent(DefinitionByType.class) && this.autoRegister(DefinitionType.TYPE, null, componentType)) {
                return super.getComponentInstanceOfType(componentType, false);
            }
        } else if (componentKey instanceof String ? bindType.isAnnotationPresent(DefinitionByName.class) && this.autoRegister(DefinitionType.NAME, componentKey, bindType) : componentKey instanceof Class && (annotationType = (Class)componentKey).isAnnotationPresent(Qualifier.class) && bindType.isAnnotationPresent(DefinitionByQualifier.class) && this.autoRegister(DefinitionType.QUALIFIER, componentKey, bindType)) {
            return super.getComponentInstance(componentKey, bindType, false);
        }
        return result;
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType) {
        return this.getComponentAdapter(componentKey, bindType, true);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        Class annotationType;
        ComponentAdapter<T> result = super.getComponentAdapter(componentKey, bindType, autoRegistration);
        if (result != null || !autoRegistration || Object.class.equals(bindType)) {
            return result;
        }
        if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
            Class componentType = (Class)componentKey;
            if (componentType.isAnnotationPresent(DefinitionByType.class) && this.autoRegister(DefinitionType.TYPE, null, componentType)) {
                return super.getComponentAdapterOfType(componentType, false);
            }
        } else if (componentKey instanceof String ? bindType.isAnnotationPresent(DefinitionByName.class) && this.autoRegister(DefinitionType.NAME, componentKey, bindType) : componentKey instanceof Class && (annotationType = (Class)componentKey).isAnnotationPresent(Qualifier.class) && bindType.isAnnotationPresent(DefinitionByQualifier.class) && this.autoRegister(DefinitionType.QUALIFIER, componentKey, bindType)) {
            return super.getComponentAdapter(componentKey, bindType, false);
        }
        return result;
    }

    static {
        SET_PROFILES = Collections.unmodifiableSet(new HashSet());
        LOG = ExoLogger.getLogger((String)"exo.kernel.container.ExoContainer");
    }

    private static enum DefinitionType {
        TYPE,
        NAME,
        QUALIFIER;

    }
}

