/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="war:/groovy/social/webui/space/UIInvitation.gtmpl")
public class UIInvitation
extends UIContainer {
    private final String USERS_SPACES = "users-spaces";
    private final String SPACE_PREFIX = "space::";
    private List<String> notFoundInvitees = new ArrayList<String>();
    private Map<String, String> invitees = new HashMap<String, String>();
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public UIInvitation() {
        UIFormStringInput uiFormStringInput = new UIFormStringInput("users-spaces", null, null);
        this.addChild((UIComponent)uiFormStringInput);
    }

    public void setInvitees(String invitees) {
        HashMap<String, String> inviteeNames = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)invitees)) {
            SpaceService spaceService = this.getSpaceService();
            IdentityManager identityManager = this.getIdentityManager();
            String[] invitedList = invitees.split(",");
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            for (String invited : invitedList) {
                if (invited.equals(userId)) continue;
                Space space = spaceService.getSpaceByDisplayName(invited);
                if (space != null) {
                    inviteeNames.putIfAbsent("space::" + space.getPrettyName(), invited);
                    continue;
                }
                Identity identity = identityManager.getOrCreateIdentity("organization", invited, true);
                if (identity == null) {
                    this.notFoundInvitees.add(invited);
                    continue;
                }
                Profile profile = identity.getProfile();
                inviteeNames.putIfAbsent(invited, profile.getFullName());
            }
        }
        this.invitees = inviteeNames;
    }

    public Map<String, String> getInvitees() {
        return this.invitees;
    }

    public List<Identity> getSelectedIdentities() {
        this.notFoundInvitees = new ArrayList<String>();
        UIFormStringInput uiFormStringInput = (UIFormStringInput)this.getChild(UIFormStringInput.class);
        String input = (String)uiFormStringInput.getValue();
        return this.getIdentities(input);
    }

    public String getRestURL() {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(PortalContainer.getCurrentRestContextName()).append("/social/people/suggest.json?");
        builder.append("currentUser=").append(RequestContext.getCurrentInstance().getRemoteUser());
        builder.append("&typeOfRelation=").append("user_to_invite");
        return builder.toString();
    }

    public List<String> getNotFoundInvitees() {
        return this.notFoundInvitees;
    }

    private List<Identity> getIdentities(String input) {
        ArrayList<Identity> identityList = new ArrayList<Identity>();
        if (input != null) {
            String[] invitedList = input.split(",");
            IdentityManager identityManager = this.getIdentityManager();
            for (String invited : invitedList) {
                if (invited.startsWith("space::")) {
                    String spaceName = invited.substring("space::".length());
                    Identity spaceIdentity = identityManager.getOrCreateIdentity("space", spaceName, false);
                    identityList.add(spaceIdentity);
                    continue;
                }
                Identity identity = identityManager.getOrCreateIdentity("organization", invited, false);
                if (identity == null) {
                    this.notFoundInvitees.add(invited);
                    continue;
                }
                identityList.add(identity);
            }
        }
        return identityList;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        }
        return this.identityManager;
    }
}

