/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space.access;

import java.io.IOException;
import java.util.Collection;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SpaceAccessApplicationLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Log LOG = ExoLogger.getLogger(SpaceAccessApplicationLifecycle.class);
    private static final String KEEP_SPACE_ACCESS_SESSION_DATA_KEY = "social.accessed.space.data.keep";

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        if (pcontext.isResponseComplete()) {
            return;
        }
        String siteName = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
        this.moveSessionAttributeToRequest(pcontext, "social.accessed.space.type.key");
        this.moveSessionAttributeToRequest(pcontext, "social.accessed.space.key");
        this.moveSessionAttributeToRequest(pcontext, "social.accessed.space.request.path.key");
        if (pcontext.getSiteType().equals((Object)SiteType.GROUP) && pcontext.getSiteName().startsWith("/spaces/")) {
            Space space = Utils.getSpaceService().getSpaceByGroupId(siteName);
            String remoteId = Utils.getViewerRemoteId();
            if (space != null && remoteId != null) {
                this.addMembershipToIdentity(remoteId, space);
                if (Utils.getSpaceService().isSuperManager(remoteId) || SpaceUtils.isUserHasMembershipTypesInGroup((String)remoteId, (String)space.getGroupId(), (String)"*")) {
                    Utils.getSpaceService().updateSpaceAccessed(remoteId, space);
                    return;
                }
            }
            this.processSpaceAccess(pcontext, remoteId, space);
        }
    }

    private void addMembershipToIdentity(String remoteId, Space space) {
        IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteId);
        if (identity != null) {
            SpaceService spaceService = Utils.getSpaceService();
            boolean isSuperManager = spaceService.isSuperManager(remoteId);
            boolean isManager = spaceService.isManager(space, remoteId);
            boolean isMember = spaceService.isMember(space, remoteId);
            MembershipEntry memberMembership = new MembershipEntry(space.getGroupId(), "member");
            MembershipEntry managerMembership = new MembershipEntry(space.getGroupId(), "manager");
            Collection memberships = identity.getMemberships();
            if (isMember || isSuperManager) {
                memberships.add(memberMembership);
            } else {
                memberships.remove(memberMembership);
            }
            if (isManager || isSuperManager) {
                memberships.add(managerMembership);
            } else {
                memberships.remove(managerMembership);
            }
        }
    }

    private void processSpaceAccess(PortalRequestContext pcontext, String remoteId, Space space) throws IOException {
        boolean gotStatus = SpaceAccessType.SPACE_NOT_FOUND.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.SPACE_NOT_FOUND, null);
            return;
        }
        gotStatus = SpaceAccessType.NO_AUTHENTICATED.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.NO_AUTHENTICATED, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.INVITED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.INVITED_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUESTED_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUESTED_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUEST_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.CLOSED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.CLOSED_SPACE, space.getPrettyName());
            return;
        }
    }

    private void sendRedirect(PortalRequestContext pcontext, SpaceAccessType type, String spacePrettyName) throws IOException {
        String url = Utils.getURI("space-access");
        LOG.info((Object)type.toString());
        String requestPath = pcontext.getRequestURI();
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.type.key", (Object)type);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.key", (Object)spacePrettyName);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.request.path.key", (Object)requestPath);
        SpaceAccessApplicationLifecycle.markToKeepSessionData();
        pcontext.setResponseComplete(true);
        pcontext.sendRedirect(url);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        if (pcontext.getRequest().getAttribute(KEEP_SPACE_ACCESS_SESSION_DATA_KEY) == null) {
            this.removeAttributeFromSession(pcontext, "social.accessed.space.type.key");
            this.removeAttributeFromSession(pcontext, "social.accessed.space.key");
            this.removeAttributeFromSession(pcontext, "social.accessed.space.request.path.key");
        }
    }

    private void removeAttributeFromSession(PortalRequestContext pcontext, String key) {
        if (pcontext.getRequest().getAttribute(key) != null) {
            pcontext.getRequest().getSession().removeAttribute(key);
        }
    }

    private void moveSessionAttributeToRequest(PortalRequestContext pcontext, String key) {
        Object value = pcontext.getRequest().getSession().getAttribute(key);
        if (value != null) {
            pcontext.getRequest().setAttribute(key, value);
        }
    }

    public void onDestroy(Application app) throws Exception {
    }

    public static void markToKeepSessionData() {
        Util.getPortalRequestContext().getRequest().setAttribute(KEEP_SPACE_ACCESS_SESSION_DATA_KEY, (Object)true);
    }
}

