/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.jdbc.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.ContainerEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.mop.jdbc.dao.ContainerDAO;
import org.exoplatform.portal.mop.jdbc.dao.PageDAO;
import org.exoplatform.portal.mop.jdbc.dao.PermissionDAO;
import org.exoplatform.portal.mop.jdbc.dao.SiteDAO;
import org.exoplatform.portal.mop.jdbc.dao.WindowDAO;
import org.exoplatform.portal.mop.jdbc.service.JDBCModelStorageImpl$AjcClosure1;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.BodyType;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.portal.pom.data.RedirectData;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.io.IOTools;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JDBCModelStorageImpl
implements ModelDataStorage {
    private static final String IMPORTED_STATUS;
    private SiteDAO siteDAO;
    private PageDAO pageDAO;
    private WindowDAO windowDAO;
    private ContainerDAO containerDAO;
    private PermissionDAO permissionDAO;
    private SettingService settingService;
    private ConfigurationManager confManager;
    private static Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public JDBCModelStorageImpl(SiteDAO siteDAO, PageDAO pageDAO, WindowDAO windowDAO, ContainerDAO containerDAO, PermissionDAO permissionDAO, SettingService settingService, ConfigurationManager confManager) {
        this.siteDAO = siteDAO;
        this.pageDAO = pageDAO;
        this.windowDAO = windowDAO;
        this.containerDAO = containerDAO;
        this.permissionDAO = permissionDAO;
        this.settingService = settingService;
        this.confManager = confManager;
    }

    @Override
    public void create(PortalData config) throws Exception {
        if (this.getPortalConfig(config.getKey()) != null) {
            throw new IllegalArgumentException("Cannot create portal " + config.getName() + " that already exist");
        }
        SiteEntity entity = this.buildSiteEntity(null, config);
        this.siteDAO.create(entity);
        this.savePermissions(entity.getId(), config);
    }

    @Override
    public void save(PortalData config) throws Exception {
        SiteKey siteKey = new SiteKey(config.getKey().getType(), config.getKey().getId());
        SiteEntity entity = this.siteDAO.findByKey(siteKey);
        if (entity == null) {
            throw new IllegalArgumentException("Cannot update portal " + config.getName() + " that does not exist");
        }
        entity = this.buildSiteEntity(entity, config);
        this.siteDAO.update(entity);
        this.savePermissions(entity.getId(), config);
    }

    @Override
    public PortalData getPortalConfig(PortalKey key) throws Exception {
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        SiteEntity entity = this.siteDAO.findByKey(siteKey);
        if (entity != null) {
            return this.buildPortalData(entity);
        }
        return null;
    }

    @Override
    @ExoTransactional
    public void remove(PortalData config) throws Exception {
        PortalData portalData = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)portalData);
        Object[] objectArray = new Object[]{this, portalData, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JDBCModelStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public PageData getPage(PageKey key) throws Exception {
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        org.exoplatform.portal.mop.page.PageKey pageKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, key.getName());
        PageEntity entity = this.pageDAO.findByKey(pageKey);
        return this.buildPageData(entity);
    }

    @Override
    public List<ModelChange> save(PageData page) throws Exception {
        PageKey key = page.getKey();
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        org.exoplatform.portal.mop.page.PageKey mopKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, key.getName());
        PageEntity dst = this.pageDAO.findByKey(mopKey);
        if (dst == null) {
            throw new NoSuchDataException("The page " + key + " not found");
        }
        JSONParser parser = new JSONParser();
        JSONArray pageBody = (JSONArray)parser.parse(dst.getPageBody());
        List<ComponentData> children = page.getChildren();
        this.cleanDeletedComponents(pageBody, children);
        List<ComponentEntity> newBody = this.saveChildren(children);
        dst.setChildren(newBody);
        dst.setPageBody(((JSONArray)dst.toJSON().get((Object)"children")).toJSONString());
        this.pageDAO.update(dst);
        return Collections.emptyList();
    }

    @Override
    public <S> String getId(ApplicationState<S> state) throws Exception {
        Long id;
        if (state instanceof TransientApplicationState) {
            TransientApplicationState tstate = (TransientApplicationState)state;
            return tstate.getContentId();
        }
        if (state instanceof PersistentApplicationState) {
            PersistentApplicationState pstate = (PersistentApplicationState)state;
            id = Safe.parseLong((String)pstate.getStorageId());
        } else if (state instanceof CloneApplicationState) {
            CloneApplicationState cstate = (CloneApplicationState)state;
            id = Safe.parseLong((String)cstate.getStorageId());
        } else {
            throw new AssertionError();
        }
        WindowEntity window = (WindowEntity)this.windowDAO.find(id);
        if (window != null) {
            return window.getContentId();
        }
        return null;
    }

    @Override
    public <S> S load(ApplicationState<S> state, ApplicationType<S> type) throws Exception {
        if (state instanceof TransientApplicationState) {
            TransientApplicationState transientState = (TransientApplicationState)state;
            Object prefs = transientState.getContentState();
            if (prefs == null && type.getContentType().getStateClass().equals(Portlet.class)) {
                return (S)new Portlet();
            }
            return prefs;
        }
        Long id = state instanceof CloneApplicationState ? Long.valueOf(Safe.parseLong((String)((CloneApplicationState)state).getStorageId())) : Long.valueOf(Safe.parseLong((String)((PersistentApplicationState)state).getStorageId()));
        WindowEntity window = (WindowEntity)this.windowDAO.find(id);
        if (window != null) {
            byte[] customization = window.getCustomization();
            if (customization != null) {
                return (S)IOTools.unserialize((byte[])window.getCustomization());
            }
            if (type.getContentType().getStateClass().equals(Portlet.class)) {
                return (S)new Portlet();
            }
            return null;
        }
        return null;
    }

    @Override
    public <S> ApplicationState<S> save(ApplicationState<S> state, S preferences) throws Exception {
        if (state instanceof TransientApplicationState) {
            throw new AssertionError((Object)"Does not make sense");
        }
        Long id = state instanceof CloneApplicationState ? Long.valueOf(Safe.parseLong((String)((CloneApplicationState)state).getStorageId())) : Long.valueOf(Safe.parseLong((String)((PersistentApplicationState)state).getStorageId()));
        WindowEntity window = (WindowEntity)this.windowDAO.find(id);
        if (window != null) {
            if (preferences != null) {
                window.setCustomization(IOTools.serialize((Serializable)((Serializable)preferences)));
            } else {
                window.setCustomization(null);
            }
            this.windowDAO.update(window);
        }
        return state;
    }

    @Override
    public <T> LazyPageList<T> find(Query<T> q) throws Exception {
        return this.find(q, null);
    }

    @Override
    public <T> LazyPageList<T> find(Query<T> q, Comparator<T> sortComparator) throws Exception {
        Class<T> type = q.getClassType();
        if (PageData.class.equals(type)) {
            throw new UnsupportedOperationException("Use PageService.findPages to instead of");
        }
        if (PortletPreferences.class.equals(type)) {
            return new LazyPageList(new ListAccess<T>(){

                public T[] load(int index, int length) throws Exception {
                    throw new AssertionError();
                }

                public int getSize() throws Exception {
                    return 0;
                }
            }, 10);
        }
        if (PortalData.class.equals(type)) {
            SiteType siteType = SiteType.PORTAL;
            String ownerType = q.getOwnerType();
            if (ownerType != null) {
                siteType = SiteType.valueOf(ownerType.toUpperCase());
            }
            final List<SiteEntity> results = this.siteDAO.findByType(siteType);
            ListAccess<PortalData> la = new ListAccess<PortalData>(){

                public PortalData[] load(int index, int length) throws Exception {
                    List entities = results.subList(index, index + length);
                    ArrayList<PortalData> data = new ArrayList<PortalData>();
                    for (SiteEntity entity : entities) {
                        data.add(JDBCModelStorageImpl.this.buildPortalData(entity));
                    }
                    return data.toArray(new PortalData[data.size()]);
                }

                public int getSize() throws Exception {
                    return results.size();
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
        if (PortalKey.class.equals(type) && ("portal".equals(q.getOwnerType()) || "group".equals(q.getOwnerType()))) {
            String ownerType = q.getOwnerType();
            SiteType siteType = SiteType.valueOf(StringUtils.upperCase((String)ownerType));
            final List<SiteKey> keys = this.siteDAO.findSiteKey(siteType);
            ListAccess<PortalKey> la = new ListAccess<PortalKey>(){

                public PortalKey[] load(int index, int length) throws Exception {
                    ArrayList<PortalKey> results = new ArrayList<PortalKey>();
                    for (SiteKey key : keys.subList(index, index + length)) {
                        results.add(new PortalKey(key.getType().getName(), key.getName()));
                    }
                    return results.toArray(new PortalKey[results.size()]);
                }

                public int getSize() throws Exception {
                    return keys.size();
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
        throw new UnsupportedOperationException("Could not perform search on query " + q);
    }

    @Override
    public Container getSharedLayout(String siteName) throws Exception {
        String path = null;
        path = StringUtils.isBlank((String)siteName) ? "war:/conf/portal/portal/sharedlayout.xml" : "war:/conf/portal/portal/sharedlayout-" + siteName + ".xml";
        InputStream inputStream = null;
        try {
            inputStream = this.confManager.getInputStream(path);
        }
        catch (IOException e) {
            log.debug((Object)("Unable to find file '" + path + "'"), (Throwable)e);
            return this.getSharedLayout(null);
        }
        String out = IOUtil.getStreamContentAsString((InputStream)inputStream);
        ByteArrayInputStream is = new ByteArrayInputStream(out.getBytes("UTF-8"));
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        UnmarshallingContext uctx = (UnmarshallingContext)bfact.createUnmarshallingContext();
        uctx.setDocument((InputStream)is, null, "UTF-8", false);
        Container container = (Container)uctx.unmarshalElement();
        this.generateStorageName(container);
        return container;
    }

    @Override
    public void save() throws Exception {
    }

    @Override
    public String[] getSiteInfo(String workspaceObjectId) throws Exception {
        return null;
    }

    @Override
    public <S> ApplicationData<S> getApplicationData(String applicationStorageId) {
        WindowEntity window = (WindowEntity)this.windowDAO.find(Long.valueOf(Safe.parseLong((String)applicationStorageId)));
        if (window != null) {
            return this.buildWindow(window);
        }
        return null;
    }

    @Override
    public <A> A adapt(ModelData modelData, Class<A> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> A adapt(ModelData modelData, Class<A> type, boolean create) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Status getImportStatus() {
        SettingValue setting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), IMPORTED_STATUS);
        if (setting != null) {
            String value = (String)setting.getValue();
            try {
                return Status.getStatus(Integer.parseInt(value));
            }
            catch (Exception ex) {
                log.error((Object)"Can't parse setting value of import status", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void saveImportStatus(Status status) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), IMPORTED_STATUS, SettingValue.create((String)String.valueOf(status.status())));
    }

    private PageData buildPageData(PageEntity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        JSONArray pageBody = (JSONArray)parser.parse(entity.getPageBody());
        List<PermissionEntity> moveApps = this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_APP);
        List<PermissionEntity> moveContainers = this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_CONTAINER);
        PageData pageData = new PageData("page_" + entity.getId(), null, entity.getName(), null, null, null, null, null, null, null, Collections.emptyList(), this.buildChildren(pageBody), entity.getOwnerType().getName(), entity.getOwnerId(), null, false, this.buildPermission(moveApps), this.buildPermission(moveContainers));
        return pageData;
    }

    private Map<Long, WindowEntity> queryWindow(JSONArray jsonBody) {
        HashSet<Long> ids = new HashSet<Long>();
        this.filterId(jsonBody, ComponentEntity.TYPE.WINDOW, ids);
        List<WindowEntity> entities = this.windowDAO.findByIds(new LinkedList<Long>(ids));
        HashMap<Long, WindowEntity> results = new HashMap<Long, WindowEntity>();
        for (WindowEntity entity : entities) {
            results.put(entity.getId(), entity);
        }
        ids.removeAll(results.keySet());
        if (ids.size() > 0) {
            log.error("Can't find Window with ids: {}", new Object[]{StringUtils.join(ids, (String)",")});
        }
        return results;
    }

    private Set<Long> filterId(JSONArray jsonBody, ComponentEntity.TYPE type, Set<Long> ids) {
        if (jsonBody != null) {
            for (Object obj : jsonBody) {
                JSONObject component = (JSONObject)obj;
                ComponentEntity.TYPE t = ComponentEntity.TYPE.valueOf(component.get((Object)"type").toString());
                if (t.equals((Object)type)) {
                    ids.add(Safe.parseLong((String)component.get((Object)"id").toString()));
                }
                if (!ComponentEntity.TYPE.CONTAINER.equals((Object)t)) continue;
                this.filterId((JSONArray)component.get((Object)"children"), type, ids);
            }
        }
        return ids;
    }

    private Map<Long, ContainerEntity> queryContainer(JSONArray jsonBody) {
        HashSet<Long> ids = new HashSet<Long>();
        this.filterId(jsonBody, ComponentEntity.TYPE.CONTAINER, ids);
        List<ContainerEntity> entities = this.containerDAO.findByIds(new LinkedList<Long>(ids));
        HashMap<Long, ContainerEntity> results = new HashMap<Long, ContainerEntity>();
        for (ContainerEntity entity : entities) {
            results.put(entity.getId(), entity);
        }
        ids.removeAll(results.keySet());
        if (ids.size() > 0) {
            log.error("Can't find Container with ids: {}", new Object[]{StringUtils.join(ids, (String)",")});
        }
        return results;
    }

    private List<ComponentEntity> saveChildren(List<ComponentData> children) throws Exception {
        LinkedList<ComponentEntity> results = new LinkedList<ComponentEntity>();
        for (ComponentData srcChild : children) {
            Long srcChildId = Safe.parseLong((String)srcChild.getStorageId());
            ComponentEntity dstChild = null;
            if (srcChildId != null && srcChildId > 0L) {
                if (srcChild instanceof ContainerData) {
                    dstChild = (ComponentEntity)this.containerDAO.find(srcChildId);
                    if (dstChild != null) {
                        this.buildContainerEntity((ContainerEntity)dstChild, (ContainerData)srcChild);
                        this.containerDAO.update((ContainerEntity)dstChild);
                    }
                } else if (srcChild instanceof ApplicationData) {
                    dstChild = (ComponentEntity)this.windowDAO.find(srcChildId);
                    if (dstChild != null) {
                        if ((dstChild = this.buildWindowEntity((WindowEntity)dstChild, (ApplicationData)srcChild)) == null) continue;
                        this.windowDAO.update((WindowEntity)dstChild);
                    }
                } else if (srcChild instanceof BodyData) {
                    dstChild = (ComponentEntity)this.containerDAO.find(srcChildId);
                } else {
                    throw new StaleModelException("this layout component type is not supported: " + srcChild);
                }
            }
            if (dstChild == null || dstChild.getId() == null) {
                if (srcChild instanceof ContainerData) {
                    dstChild = this.buildContainerEntity(null, (ContainerData)srcChild);
                    dstChild = (ComponentEntity)this.containerDAO.create((ContainerEntity)dstChild);
                } else if (srcChild instanceof ApplicationData) {
                    dstChild = this.buildWindowEntity(null, (ApplicationData)srcChild);
                    if (dstChild == null) continue;
                    dstChild = (ComponentEntity)this.windowDAO.create((WindowEntity)dstChild);
                } else if (srcChild instanceof BodyData) {
                    dstChild = this.buildContainerEntity((BodyData)srcChild);
                    dstChild = (ComponentEntity)this.containerDAO.create((ContainerEntity)dstChild);
                } else {
                    throw new StaleModelException("Was not expecting child " + srcChild);
                }
                if (dstChild.getId() == null) {
                    throw new IllegalStateException("Id of saved child wasn't found: " + (Object)((Object)dstChild.getType()) + " / " + dstChild);
                }
            }
            this.savePermissions(dstChild.getId(), srcChild);
            if (srcChild instanceof ContainerData) {
                List<ComponentEntity> descendants = this.saveChildren(((ContainerData)srcChild).getChildren());
                ((ContainerEntity)dstChild).setChildren(descendants);
            }
            results.add(dstChild);
        }
        return results;
    }

    private ComponentEntity buildContainerEntity(BodyData bodyData) {
        ContainerEntity dst = new ContainerEntity();
        JSONObject properties = new JSONObject();
        properties.put((Object)MappedAttributes.TYPE.getName(), (Object)bodyData.getType().name());
        dst.setProperties(properties.toJSONString());
        return dst;
    }

    private List<ComponentData> buildChildren(JSONArray jsonBody) {
        Map<Long, ContainerEntity> containers = this.queryContainer(jsonBody);
        Map<Long, WindowEntity> windows = this.queryWindow(jsonBody);
        return this.buildChildren(jsonBody, containers, windows);
    }

    private List<ComponentData> buildChildren(JSONArray jsonBody, Map<Long, ContainerEntity> containers, Map<Long, WindowEntity> windows) {
        LinkedList<ComponentData> results = new LinkedList<ComponentData>();
        if (jsonBody != null) {
            for (Object component : jsonBody) {
                JSONObject jsonComponent = (JSONObject)component;
                Long id = Safe.parseLong((String)jsonComponent.get((Object)"id").toString());
                ComponentEntity.TYPE type = ComponentEntity.TYPE.valueOf(jsonComponent.get((Object)"type").toString());
                switch (type) {
                    case CONTAINER: {
                        JSONObject attrs;
                        ContainerEntity srcContainer = (ContainerEntity)this.containerDAO.find(id);
                        JSONParser parser = new JSONParser();
                        try {
                            attrs = (JSONObject)parser.parse(srcContainer.getProperties());
                        }
                        catch (ParseException e) {
                            throw new IllegalStateException(e);
                        }
                        String ctype = (String)attrs.get((Object)MappedAttributes.TYPE.getName());
                        if ("dashboard".equals(ctype)) {
                            TransientApplicationState<Object> state = new TransientApplicationState<Object>("dashboard/DashboardPortlet", null, null, null);
                            boolean showInfoBar = Boolean.parseBoolean(String.valueOf(attrs.get((Object)MappedAttributes.SHOW_INFO_BAR.getName())));
                            boolean showMode = Boolean.parseBoolean(String.valueOf(attrs.get((Object)MappedAttributes.SHOW_MODE.getName())));
                            boolean showWindowState = Boolean.parseBoolean(String.valueOf(attrs.get((Object)MappedAttributes.SHOW_WINDOW_STATE.getName())));
                            String theme = (String)attrs.get((Object)MappedAttributes.THEME.getName());
                            List<String> accessPermissions = this.buildPermission(this.permissionDAO.getPermissions(ContainerEntity.class.getName(), srcContainer.getId(), PermissionEntity.TYPE.ACCESS));
                            if (accessPermissions.isEmpty()) {
                                accessPermissions = Collections.singletonList("Everyone");
                            }
                            results.add(new ApplicationData<Object>(String.valueOf(srcContainer.getId()), String.valueOf(srcContainer.getId()), ApplicationType.PORTLET, state, String.valueOf(srcContainer.getId()), srcContainer.getTitle(), srcContainer.getIcon(), srcContainer.getDescription(), showInfoBar, showWindowState, showMode, theme, srcContainer.getWidth(), srcContainer.getHeight(), Collections.emptyMap(), accessPermissions));
                            break;
                        }
                        if (BodyType.PAGE.name().equals(ctype)) {
                            BodyData body = new BodyData(String.valueOf(id), BodyType.PAGE);
                            results.add(body);
                            break;
                        }
                        results.add(this.buildContainer(containers.get(id), jsonComponent, containers, windows));
                        break;
                    }
                    case WINDOW: {
                        results.add(this.buildWindow(windows.get(id)));
                    }
                }
            }
        }
        return results;
    }

    private ApplicationData buildWindow(WindowEntity windowEntity) {
        ApplicationType appType = this.convert(windowEntity.getAppType());
        PersistentApplicationState state = new PersistentApplicationState(String.valueOf(windowEntity.getId()));
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject jProp = (JSONObject)parser.parse(windowEntity.getProperties());
            for (Object key : jProp.keySet()) {
                properties.put(key.toString(), jProp.get(key).toString());
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        List<PermissionEntity> access = this.permissionDAO.getPermissions(WindowEntity.class.getName(), windowEntity.getId(), PermissionEntity.TYPE.ACCESS);
        return new ApplicationData(String.valueOf(windowEntity.getId()), null, appType, state, String.valueOf(windowEntity.getId()), windowEntity.getTitle(), windowEntity.getIcon(), windowEntity.getDescription(), windowEntity.isShowInfoBar(), windowEntity.isShowApplicationState(), windowEntity.isShowApplicationMode(), windowEntity.getTheme(), windowEntity.getWidth(), windowEntity.getHeight(), properties, this.buildPermission(access));
    }

    private ApplicationType convert(WindowEntity.AppType appType) {
        switch (appType) {
            case PORTLET: {
                return ApplicationType.PORTLET;
            }
        }
        return null;
    }

    private ContainerData buildContainer(ContainerEntity entity, JSONObject jsonComponent, Map<Long, ContainerEntity> containers, Map<Long, WindowEntity> windows) {
        List<ComponentData> children = this.buildChildren((JSONArray)jsonComponent.get((Object)"children"), containers, windows);
        List<PermissionEntity> access = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<PermissionEntity> moveApps = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_APP);
        List<PermissionEntity> moveConts = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_CONTAINER);
        return new ContainerData(String.valueOf(entity.getId()), entity.getWebuiId(), entity.getName(), entity.getIcon(), entity.getTemplate(), entity.getFactoryId(), entity.getTitle(), entity.getDescription(), entity.getWidth(), entity.getHeight(), this.buildPermission(access), this.buildPermission(moveApps), this.buildPermission(moveConts), children);
    }

    private void cleanDeletedComponents(JSONArray body, List<ComponentData> children) {
        HashSet<Long> windowIds = new HashSet<Long>();
        this.filterId(body, ComponentEntity.TYPE.WINDOW, windowIds);
        for (Long id : windowIds) {
            if (this.findById(id, ComponentEntity.TYPE.WINDOW, children) != null) continue;
            this.windowDAO.deleteById(id);
        }
        HashSet<Long> containerIds = new HashSet<Long>();
        this.filterId(body, ComponentEntity.TYPE.CONTAINER, containerIds);
        for (Long id : containerIds) {
            if (this.findById(id, ComponentEntity.TYPE.CONTAINER, children) != null) continue;
            this.containerDAO.deleteById(id);
        }
    }

    private ContainerEntity buildContainerEntity(ContainerEntity dst, ContainerData src) {
        if (dst == null) {
            dst = new ContainerEntity();
        }
        dst.setWebuiId(src.getId());
        dst.setDescription(src.getDescription());
        dst.setFactoryId(src.getFactoryId());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setName(src.getName());
        dst.setTemplate(src.getTemplate());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        return dst;
    }

    private WindowEntity buildWindowEntity(WindowEntity dst, ApplicationData srcChild) throws Exception {
        if (dst == null) {
            ApplicationState state;
            dst = new WindowEntity();
            ApplicationType type = srcChild.getType();
            if (type == null) {
                log.warn("Application type of instance {} is not recognized, ignore it", new Object[]{dst.getContentId()});
                return null;
            }
            if (ApplicationType.PORTLET.getName().equals(type.getName())) {
                dst.setAppType(WindowEntity.AppType.PORTLET);
            }
            if ((state = srcChild.getState()) instanceof TransientApplicationState) {
                TransientApplicationState s = (TransientApplicationState)state;
                dst.setContentId(s.getContentId());
                if (s.getContentState() != null) {
                    dst.setCustomization(IOTools.serialize((Serializable)((Serializable)s.getContentState())));
                }
            } else {
                throw new IllegalStateException("Can't create new window");
            }
        }
        dst.setDescription(srcChild.getDescription());
        dst.setHeight(srcChild.getHeight());
        dst.setIcon(srcChild.getIcon());
        dst.setProperties(this.toJSON(srcChild.getProperties()).toJSONString());
        dst.setShowApplicationMode(srcChild.isShowApplicationMode());
        dst.setShowApplicationState(srcChild.isShowApplicationState());
        dst.setShowInfoBar(srcChild.isShowInfoBar());
        dst.setTheme(srcChild.getTheme());
        dst.setTitle(srcChild.getTitle());
        dst.setWidth(srcChild.getWidth());
        return dst;
    }

    private ComponentData findById(Long id, ComponentEntity.TYPE type, List<ComponentData> children) {
        if (children != null) {
            for (ComponentData child : children) {
                ComponentData result;
                if (id.equals(Safe.parseLong((String)child.getStorageId())) && (type == ComponentEntity.TYPE.WINDOW && child instanceof ApplicationData || type == ComponentEntity.TYPE.CONTAINER && child instanceof ContainerData)) {
                    return child;
                }
                if (!(child instanceof ContainerData) || (result = this.findById(id, type, ((ContainerData)child).getChildren())) == null) continue;
                return result;
            }
        }
        return null;
    }

    private List<String> buildPermission(List<PermissionEntity> permissions) {
        ArrayList<String> results = new ArrayList<String>();
        if (permissions != null) {
            for (PermissionEntity per : permissions) {
                results.add(per.getPermission());
            }
        }
        return results;
    }

    private void savePermissions(Long id, PortalData config) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.permissionDAO.savePermissions(SiteEntity.class.getName(), id, PermissionEntity.TYPE.ACCESS, config.getAccessPermissions());
        this.permissionDAO.savePermissions(SiteEntity.class.getName(), id, PermissionEntity.TYPE.EDIT, Arrays.asList(config.getEditPermission()));
    }

    private void savePermissions(Long id, ComponentData srcChild) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        List<String> access = null;
        String typeName = srcChild.getClass().getName();
        if (srcChild instanceof ContainerData) {
            ContainerData srcData = (ContainerData)srcChild;
            typeName = ContainerEntity.class.getName();
            access = srcData.getAccessPermissions();
            this.permissionDAO.savePermissions(typeName, id, PermissionEntity.TYPE.MOVE_APP, srcData.getMoveAppsPermissions());
            this.permissionDAO.savePermissions(typeName, id, PermissionEntity.TYPE.MOVE_CONTAINER, srcData.getMoveContainersPermissions());
        } else if (srcChild instanceof ApplicationData) {
            ApplicationData srcData = (ApplicationData)srcChild;
            typeName = WindowEntity.class.getName();
            access = srcData.getAccessPermissions();
        }
        this.permissionDAO.savePermissions(typeName, id, PermissionEntity.TYPE.ACCESS, access);
    }

    private SiteEntity buildSiteEntity(SiteEntity entity, PortalData config) throws Exception {
        if (entity == null) {
            entity = new SiteEntity();
        }
        entity.setDescription(config.getDescription());
        entity.setLabel(config.getLabel());
        entity.setLocale(config.getLocale());
        entity.setName(config.getName());
        entity.setSiteType(SiteType.valueOf(config.getKey().getType().toUpperCase()));
        entity.setDefaultSiteBody(config.isDefaultLayout());
        entity.setSkin(config.getSkin());
        String propertiesString = "{}";
        Map<String, String> properties = config.getProperties();
        if (properties != null) {
            propertiesString = new JSONObject(properties).toJSONString();
        }
        entity.setProperties(propertiesString);
        ArrayList<ComponentData> children = new ArrayList<ComponentData>();
        children.add(config.getPortalLayout());
        JSONParser parser = new JSONParser();
        JSONArray pageBody = (JSONArray)parser.parse(entity.getSiteBody());
        this.cleanDeletedComponents(pageBody, children);
        List<ComponentEntity> newBody = this.saveChildren(children);
        entity.setChildren(newBody);
        entity.setSiteBody(((JSONArray)entity.toJSON().get((Object)"children")).toJSONString());
        return entity;
    }

    private PortalData buildPortalData(SiteEntity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        JSONArray siteBody = (JSONArray)parser.parse(entity.getSiteBody());
        List<ComponentData> children = this.buildChildren(siteBody);
        ContainerData rootContainer = null;
        if (children.isEmpty()) {
            throw new IllegalStateException("site doens't has root container layout");
        }
        rootContainer = (ContainerData)children.get(0);
        List<PermissionEntity> access = this.permissionDAO.getPermissions(SiteEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<PermissionEntity> edit = this.permissionDAO.getPermissions(SiteEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.EDIT);
        String editPer = edit.size() > 0 ? edit.get(0).getPermission() : null;
        List<RedirectData> redirects = Collections.emptyList();
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            if (entity.getProperties() != null) {
                JSONObject jProp = (JSONObject)parser.parse(entity.getProperties());
                for (Object key : jProp.keySet()) {
                    properties.put(key.toString(), jProp.get(key).toString());
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return new PortalData("site_" + entity.getId(), entity.getName(), entity.getSiteType().getName(), entity.getLocale(), entity.getLabel(), entity.getDescription(), this.buildPermission(access), editPer, Collections.unmodifiableMap(properties), entity.getSkin(), rootContainer, entity.isDefaultSiteBody(), redirects);
    }

    private JSONArray parse(String body) {
        JSONParser parser = new JSONParser();
        try {
            JSONArray children = (JSONArray)parser.parse(body);
            return children;
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new IllegalStateException("Can't parse body: " + body);
        }
    }

    private JSONObject toJSON(Map map) {
        JSONObject json = new JSONObject();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            json.put(entry.getKey(), entry.getValue());
        }
        return json;
    }

    private void deleteChildren(JSONArray children) {
        for (Object child : children) {
            JSONObject c = (JSONObject)child;
            Long id = Safe.parseLong((String)c.get((Object)"id").toString());
            ComponentEntity.TYPE t = ComponentEntity.TYPE.valueOf(c.get((Object)"type").toString());
            if (ComponentEntity.TYPE.CONTAINER.equals((Object)t)) {
                ContainerEntity container;
                JSONArray descendants = (JSONArray)c.get((Object)"children");
                if (descendants != null) {
                    this.deleteChildren(descendants);
                }
                if ((container = (ContainerEntity)this.containerDAO.find(id)) == null) continue;
                JSONArray dashboardChilds = this.parse(container.getContainerBody());
                this.deleteChildren(dashboardChilds);
                this.permissionDAO.deletePermissions(ContainerEntity.class.getName(), container.getId());
                this.containerDAO.delete(container);
                continue;
            }
            if (ComponentEntity.TYPE.WINDOW.equals((Object)t)) {
                WindowEntity window = (WindowEntity)this.windowDAO.find(id);
                if (window == null) continue;
                this.permissionDAO.deletePermissions(WindowEntity.class.getName(), window.getId());
                this.windowDAO.delete(window);
                continue;
            }
            throw new IllegalArgumentException("Can't delete child with type: " + (Object)((Object)t));
        }
    }

    private void generateStorageName(ModelObject obj) {
        if (obj instanceof Container) {
            for (ModelObject child : ((Container)obj).getChildren()) {
                this.generateStorageName(child);
            }
        } else if (obj instanceof Application) {
            obj.setStorageName(UUID.randomUUID().toString());
        }
    }

    static {
        JDBCModelStorageImpl.ajc$preClinit();
        IMPORTED_STATUS = Status.class.getName();
        log = ExoLogger.getExoLogger(JDBCModelStorageImpl.class);
    }

    static /* synthetic */ void remove_aroundBody0(JDBCModelStorageImpl ajc$this, PortalData config, JoinPoint joinPoint) {
        SiteKey siteKey = new SiteKey(config.getKey().getType(), config.getKey().getId());
        SiteEntity entity = ajc$this.siteDAO.findByKey(siteKey);
        if (entity == null) {
            throw new NoSuchDataException("Could not remove non existing portal " + siteKey);
        }
        String siteBody = entity.getSiteBody();
        JSONArray children = ajc$this.parse(siteBody);
        ajc$this.deleteChildren(children);
        ajc$this.permissionDAO.deletePermissions(SiteEntity.class.getName(), entity.getId());
        ajc$this.siteDAO.delete(entity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JDBCModelStorageImpl.java", JDBCModelStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.portal.mop.jdbc.service.JDBCModelStorageImpl", "org.exoplatform.portal.pom.data.PortalData", "config", "java.lang.Exception", "void"), 131);
    }
}

