/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.tree.diff;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.exoplatform.portal.tree.diff.HierarchyChangeType;
import org.exoplatform.portal.tree.diff.HierarchyContext;
import org.exoplatform.portal.tree.diff.HierarchyDiff;
import org.exoplatform.portal.tree.diff.ListChangeIterator;
import org.exoplatform.portal.tree.diff.ListDiff;

public class HierarchyChangeIterator<L1, N1, L2, N2, H>
implements Iterator<HierarchyChangeType> {
    private final HierarchyDiff<L1, N1, L2, N2, H> diff;
    private Frame frame;
    private final HierarchyContext<L1, N1, H> context1;
    private final HierarchyContext<L2, N2, H> context2;
    private final ListDiff<L1, L2, H> listDiff;

    HierarchyChangeIterator(HierarchyDiff<L1, N1, L2, N2, H> diff, HierarchyContext<L1, N1, H> context1, HierarchyContext<L2, N2, H> context2) {
        this.diff = diff;
        this.context1 = context1;
        this.context2 = context2;
        this.frame = new Frame(null, context1.getRoot(), context2.getRoot());
        this.listDiff = new ListDiff(diff.listAdapter1, diff.listAdapter2, diff.comparator);
    }

    @Override
    public boolean hasNext() {
        block22: {
            block23: {
                if (this.frame == null || this.frame.next != null) break block22;
                while (true) {
                    if (this.frame.previous == Status.INIT) {
                        H id2 = this.context2.getHierarchyAdapter().getHandle(this.frame.dstRoot);
                        if (this.frame.srcRoot == null) {
                            this.frame.next = Status.ENTER;
                            this.frame.src = null;
                            this.frame.dst = this.frame.dstRoot;
                        } else {
                            H id1 = this.context1.getHierarchyAdapter().getHandle(this.frame.srcRoot);
                            if (this.diff.comparator.compare(id1, id2) != 0) {
                                this.frame.next = Status.ERROR;
                                this.frame.src = this.frame.srcRoot;
                                this.frame.dst = this.frame.dstRoot;
                            } else {
                                this.frame.next = Status.ENTER;
                                this.frame.src = this.frame.srcRoot;
                                this.frame.dst = this.frame.dstRoot;
                            }
                        }
                        break block22;
                    }
                    if (this.frame.previous == Status.ERROR) break block22;
                    if (this.frame.previous == Status.LEAVE) {
                        this.frame = this.frame.parent;
                        if (this.frame != null) {
                            this.frame.previous = Status.RESUME;
                            continue;
                        }
                        break block22;
                    }
                    if (this.frame.previous == Status.KEEP) {
                        this.frame = new Frame(this.frame, this.frame.src, this.frame.dst);
                        continue;
                    }
                    if (this.frame.previous == Status.MOVED_IN) {
                        this.frame = new Frame(this.frame, this.frame.src, this.frame.dst);
                        continue;
                    }
                    if (this.frame.previous != Status.ADDED) break;
                    this.frame = new Frame(this.frame, this.frame.src, this.frame.dst);
                }
                if (this.frame.previous == Status.ENTER) {
                    Object children1;
                    if (this.frame.src != null) {
                        children1 = this.context1.getHierarchyAdapter().getChildren(this.frame.srcRoot);
                        this.frame.srcIt = this.diff.listAdapter1.iterator(children1, false);
                    } else {
                        children1 = null;
                        this.frame.srcIt = null;
                    }
                    L2 children2 = this.context2.getHierarchyAdapter().getChildren(this.frame.dstRoot);
                    this.frame.dstIt = this.diff.listAdapter2.iterator(children2, false);
                    this.frame.it = this.listDiff.iterator(children1, children2);
                }
                if (!this.frame.it.hasNext()) break block23;
                switch (this.frame.it.next()) {
                    case SAME: {
                        N1 next1 = this.context1.findByHandle(this.frame.srcIt.next());
                        N2 next2 = this.context2.findByHandle(this.frame.dstIt.next());
                        this.frame.next = Status.KEEP;
                        this.frame.src = next1;
                        this.frame.dst = next2;
                        break block22;
                    }
                    case ADD: {
                        this.frame.dstIt.next();
                        Object addedHandle = this.frame.it.getElement();
                        N2 added = this.context2.findByHandle(addedHandle);
                        H addedId = this.context2.getHierarchyAdapter().getHandle(added);
                        N1 a = this.context1.findByHandle(addedId);
                        if (a != null) {
                            this.frame.next = Status.MOVED_IN;
                            this.frame.src = a;
                            this.frame.dst = added;
                        } else {
                            this.frame.next = Status.ADDED;
                            this.frame.src = null;
                            this.frame.dst = added;
                        }
                        break block22;
                    }
                    case REMOVE: {
                        this.frame.srcIt.next();
                        Object removedHandle = this.frame.it.getElement();
                        N1 removed = this.context1.findByHandle(removedHandle);
                        H removedId = this.context1.getHierarchyAdapter().getHandle(removed);
                        N2 b = this.context2.findByHandle(removedId);
                        if (b != null) {
                            this.frame.next = Status.MOVED_OUT;
                            this.frame.src = removed;
                            this.frame.dst = b;
                        } else {
                            this.frame.next = Status.REMOVED;
                            this.frame.src = removed;
                            this.frame.dst = null;
                        }
                        break block22;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.frame.next = Status.LEAVE;
            this.frame.src = this.frame.srcRoot;
            this.frame.dst = this.frame.dstRoot;
        }
        return this.frame != null && this.frame.next != null;
    }

    @Override
    public HierarchyChangeType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.frame.previous = this.frame.next;
        this.frame.next = null;
        return ((Frame)this.frame).previous.changeType;
    }

    public void skip() {
        if (this.frame.previous != Status.ENTER) {
            throw new IllegalStateException("Cannot skip when in state " + (Object)((Object)this.frame.previous));
        }
        this.frame.next = Status.LEAVE;
        this.frame.src = this.frame.srcRoot;
        this.frame.dst = this.frame.dstRoot;
    }

    public N1 getSource() {
        return (N1)this.frame.src;
    }

    public N2 getDestination() {
        return (N2)this.frame.dst;
    }

    public N1 peekSourceRoot() {
        return (N1)this.frame.srcRoot;
    }

    public N2 peekDestinationRoot() {
        return (N2)this.frame.dstRoot;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class Frame {
        private final Frame parent;
        private final N1 srcRoot;
        private final N2 dstRoot;
        private ListChangeIterator<L1, L2, H> it;
        private Status previous;
        private Status next;
        private Iterator<H> srcIt;
        private Iterator<H> dstIt;
        private N1 src;
        private N2 dst;

        private Frame(Frame parent, N1 srcRoot, N2 dstRoot) {
            this.parent = parent;
            this.srcRoot = srcRoot;
            this.dstRoot = dstRoot;
            this.previous = Status.INIT;
        }
    }

    private static enum Status {
        INIT(null),
        ENTER(HierarchyChangeType.ENTER),
        KEEP(HierarchyChangeType.KEEP),
        ADDED(HierarchyChangeType.ADDED),
        REMOVED(HierarchyChangeType.REMOVED),
        MOVED_IN(HierarchyChangeType.MOVED_IN),
        MOVED_OUT(HierarchyChangeType.MOVED_OUT),
        LEAVE(HierarchyChangeType.LEAVE),
        ERROR(HierarchyChangeType.ERROR),
        RESUME(null);

        final HierarchyChangeType changeType;

        private Status(HierarchyChangeType changeType) {
            this.changeType = changeType;
        }
    }
}

