/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ExtendProfileFilter;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.IdentityDAOImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.dao.jpa.IdentityDAOImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.dao.jpa.query.ProfileQueryBuilder;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.relationship.model.Relationship;

public class IdentityDAOImpl
extends GenericDAOJPAImpl<IdentityEntity, Long>
implements IdentityDAO {
    private static final Log LOG;
    private static final int MAX_ITEMS_PER_IN_CLAUSE = 1000;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public IdentityEntity create(IdentityEntity entity) {
        IdentityEntity exists = this.findByProviderAndRemoteId(entity.getProviderId(), entity.getRemoteId());
        if (exists != null) {
            throw new EntityExistsException("Identity is existed with ProviderID=" + entity.getProviderId() + " and RemoteId=" + entity.getRemoteId());
        }
        return (IdentityEntity)super.create((Object)entity);
    }

    @Override
    public IdentityEntity findByProviderAndRemoteId(String providerId, String remoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.findByProviderAndRemoteId", IdentityEntity.class);
        query.setParameter("providerId", (Object)providerId);
        query.setParameter("remoteId", (Object)remoteId);
        try {
            return (IdentityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public long countIdentityByProvider(String providerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.countIdentityByProvider", Long.class);
        query.setParameter("providerId", (Object)providerId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Long> getAllIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.getAllIds", Long.class);
        if (limit > 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<Long> getAllIdsByProvider(String providerId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.getAllIdsByProvider", Long.class);
        query.setParameter("providerId", (Object)providerId);
        if (limit > 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> findAllIdentitiesWithConnections(long identityId, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        Query listQuery = this.getIdentitiesQuerySortedByField("organization", firstCharacterFieldName, firstCharacter, sortField, sortDirection);
        TypedQuery connectionsQuery = this.getEntityManager().createNamedQuery("SocConnection.findConnectionsByIdentityIds", ConnectionEntity.class);
        TypedQuery countQuery = this.getEntityManager().createNamedQuery("SocIdentity.countIdentitiesByProviderWithExcludedIdentity", Long.class);
        countQuery.setParameter("providerId", (Object)"organization");
        return new IdentityWithRelationshipListAccess(identityId, listQuery, (TypedQuery<ConnectionEntity>)connectionsQuery, (TypedQuery<Long>)countQuery);
    }

    @Override
    public ListAccess<IdentityEntity> findIdentities(ExtendProfileFilter filter) {
        if (filter.getConnection() != null) {
            Relationship.Type status;
            Identity owner = filter.getConnection();
            Long ownerId = Long.valueOf(owner.getId());
            List<Long> connections = this.getConnections(ownerId, status = filter.getConnectionStatus());
            if (connections.isEmpty()) {
                return new JPAListAccess<IdentityEntity>(IdentityEntity.class);
            }
            if (filter.getIdentityIds() == null || filter.getIdentityIds().isEmpty()) {
                filter.setIdentityIds(connections);
            } else {
                filter.getIdentityIds().retainAll(connections);
            }
        }
        ProfileQueryBuilder qb = ProfileQueryBuilder.builder().withFilter(filter);
        TypedQuery[] queries = qb.build(this.getEntityManager());
        return new JPAListAccess<IdentityEntity>(IdentityEntity.class, queries[0], (TypedQuery<Long>)queries[1]);
    }

    @Override
    public List<String> getAllIdsByProviderSorted(String providerId, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, long offset, long limit) {
        Query query = this.getIdentitiesQuerySortedByField(providerId, firstCharacterFieldName, firstCharacter, sortField, sortDirection);
        return this.getResultsFromQuery(query, 0, offset, limit, String.class);
    }

    @Override
    @ExoTransactional
    public void setAsDeleted(long identityId) {
        long l = identityId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new IdentityDAOImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void hardDeleteIdentity(long identityId) {
        long l = identityId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new IdentityDAOImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<IdentityEntity> findIdentitiesByIDs(List<Long> ids) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.findIdentitiesByIDs", IdentityEntity.class);
        if (this.isOrcaleDialect()) {
            return this.getFromOracleDB(query, ids);
        }
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    private List<Long> getConnections(Long ownerId, Relationship.Type status) {
        String queryName = null;
        Class returnType = null;
        if (status == null || status == Relationship.Type.ALL) {
            queryName = "SocConnection.getConnectionsWithoutStatus";
            returnType = ConnectionEntity.class;
        } else if (status == Relationship.Type.INCOMING) {
            queryName = "SocConnection.getSenderIdsByReceiverWithStatus";
            returnType = Long.class;
            status = Relationship.Type.PENDING;
        } else if (status == Relationship.Type.OUTGOING) {
            queryName = "SocConnection.getReceiverIdsBySenderWithStatus";
            returnType = Long.class;
            status = Relationship.Type.PENDING;
        } else {
            queryName = "SocConnection.getConnectionsWithStatus";
            returnType = ConnectionEntity.class;
        }
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("identityId", (Object)ownerId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (returnType == Long.class) {
            return query.getResultList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        List connectionEntities = query.getResultList();
        for (ConnectionEntity connectionEntity : connectionEntities) {
            if (connectionEntity.getReceiver().getId() == ownerId.longValue()) {
                ids.add(connectionEntity.getSender().getId());
                continue;
            }
            if (connectionEntity.getSender().getId() == ownerId.longValue()) {
                ids.add(connectionEntity.getReceiver().getId());
                continue;
            }
            LOG.warn("Neither sender neither receiver corresponds to owner with id {}. ", new Object[]{ownerId});
        }
        return ids;
    }

    private Query getIdentitiesQuerySortedByField(String providerId, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        String dbBoolFalse = this.isOrcaleDialect() || this.isMSSQLDialect() ? "0" : "FALSE";
        String dbBoolTrue = this.isOrcaleDialect() || this.isMSSQLDialect() ? "1" : "TRUE";
        StringBuilder queryStringBuilder = null;
        queryStringBuilder = this.isOrcaleDialect() ? new StringBuilder("SELECT to_char(identity_1.remote_id), identity_1.identity_id \n") : (this.isMSSQLDialect() ? new StringBuilder("SELECT try_convert(varchar(200), identity_1.remote_id) as remote_id , identity_1.identity_id, try_convert(varchar(200) \n") : new StringBuilder("SELECT identity_1.remote_id, identity_1.identity_id \n"));
        queryStringBuilder.append(" FROM SOC_IDENTITIES identity_1 \n");
        if (StringUtils.isNotBlank((CharSequence)firstCharacterFieldName) && firstCharacter > '\u0000') {
            queryStringBuilder.append(" INNER JOIN SOC_IDENTITY_PROPERTIES identity_prop_first_char \n");
            queryStringBuilder.append("   ON identity_1.identity_id = identity_prop_first_char.identity_id \n");
            queryStringBuilder.append("       AND identity_prop_first_char.name = '").append(firstCharacterFieldName).append("' \n");
            queryStringBuilder.append("       AND (lower(identity_prop_first_char.value) like '" + Character.toLowerCase(firstCharacter) + "%')\n");
        }
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotBlank((CharSequence)sortDirection)) {
            queryStringBuilder.append(" LEFT JOIN SOC_IDENTITY_PROPERTIES identity_prop \n");
            queryStringBuilder.append("   ON identity_1.identity_id = identity_prop.identity_id \n");
            queryStringBuilder.append("       AND identity_prop.name = '").append(sortField).append("' \n");
        }
        queryStringBuilder.append(" WHERE identity_1.provider_id = '").append(providerId).append("' \n");
        queryStringBuilder.append(" AND identity_1.deleted = ").append(dbBoolFalse).append(" \n");
        queryStringBuilder.append(" AND identity_1.enabled = ").append(dbBoolTrue).append(" \n");
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotBlank((CharSequence)sortDirection)) {
            queryStringBuilder.append(" ORDER BY lower(identity_prop.value) " + sortDirection);
        }
        return this.getEntityManager().createNativeQuery(queryStringBuilder.toString());
    }

    private <T> List<T> getResultsFromQuery(Query query, int fieldIndex, long offset, long limit, Class<T> clazz) {
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (offset >= 0L) {
            query.setFirstResult((int)offset);
        }
        List resultList = query.getResultList();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : resultList) {
            Object[] resultEntry = (Object[])object;
            Object resultObject = resultEntry[fieldIndex];
            if (resultObject == null) continue;
            result.add(resultObject);
        }
        return result;
    }

    public <T> List<T> getFromOracleDB(TypedQuery<T> query, List<Long> ids) {
        if (ids.size() <= 1000) {
            query.setParameter("ids", ids);
            return query.getResultList();
        }
        ArrayList<Long> selectedIds = new ArrayList<Long>(ids);
        ArrayList usersList = new ArrayList();
        int startIndex = 0;
        int endIndex = 0;
        while (endIndex < ids.size()) {
            if ((endIndex += 1000) > ids.size()) {
                endIndex = ids.size();
            }
            List includedIds = selectedIds.subList(startIndex, endIndex);
            query.setParameter("ids", includedIds);
            usersList.addAll(query.getResultList());
            startIndex = endIndex;
        }
        return usersList;
    }

    static {
        IdentityDAOImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(IdentityDAOImpl.class);
    }

    static /* synthetic */ void setAsDeleted_aroundBody0(IdentityDAOImpl ajc$this, long identityId, JoinPoint joinPoint) {
        IdentityEntity entity = (IdentityEntity)ajc$this.find(Long.valueOf(identityId));
        if (entity != null) {
            entity.setDeleted(true);
            ajc$this.update(entity);
        }
    }

    static /* synthetic */ void hardDeleteIdentity_aroundBody2(IdentityDAOImpl ajc$this, long identityId, JoinPoint joinPoint) {
        IdentityEntity entity = (IdentityEntity)ajc$this.find(Long.valueOf(identityId));
        if (entity != null) {
            ajc$this.delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IdentityDAOImpl.java", IdentityDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAsDeleted", "org.exoplatform.social.core.jpa.storage.dao.jpa.IdentityDAOImpl", "long", "identityId", "", "void"), 152);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hardDeleteIdentity", "org.exoplatform.social.core.jpa.storage.dao.jpa.IdentityDAOImpl", "long", "identityId", "", "void"), 162);
    }

    public class IdentityWithRelationshipListAccess
    implements ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> {
        private final Query identityQuery;
        private final TypedQuery<ConnectionEntity> connectionsQuery;
        private final TypedQuery<Long> countQuery;
        private final long identityId;

        public IdentityWithRelationshipListAccess(long identityId, Query identityQuery, TypedQuery<ConnectionEntity> connctionsQuery, TypedQuery<Long> countQuery) {
            this.identityQuery = identityQuery;
            this.connectionsQuery = connctionsQuery;
            this.countQuery = countQuery;
            this.identityId = identityId;
        }

        public Map.Entry<IdentityEntity, ConnectionEntity>[] load(int offset, int limit) throws Exception, IllegalArgumentException {
            List ids = IdentityDAOImpl.this.getResultsFromQuery(this.identityQuery, 1, offset, limit, Object.class);
            if (ids.isEmpty()) {
                return new Map.Entry[0];
            }
            final List<Long> idsLong = ids.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
            List<IdentityEntity> identitiesList = IdentityDAOImpl.this.findIdentitiesByIDs(idsLong);
            Map identitiesMap = identitiesList.stream().collect(Collectors.toMap(identity -> identity.getId(), Function.identity()));
            this.connectionsQuery.setParameter("identityId", (Object)this.identityId);
            this.connectionsQuery.setMaxResults(Integer.MAX_VALUE);
            List<Object> connectionsList = new ArrayList();
            if (IdentityDAOImpl.this.isOrcaleDialect()) {
                connectionsList = IdentityDAOImpl.this.getFromOracleDB(this.connectionsQuery, idsLong);
            } else {
                this.connectionsQuery.setParameter("ids", idsLong);
                connectionsList = this.connectionsQuery.getResultList();
            }
            LinkedHashMap<IdentityEntity, ConnectionEntity> map = new LinkedHashMap<IdentityEntity, ConnectionEntity>();
            for (Long identityId : idsLong) {
                IdentityEntity identityEntity = (IdentityEntity)identitiesMap.get(identityId);
                if (identityEntity == null) {
                    LOG.warn("Can't find identity with id '{}'", new Object[]{identityId});
                    continue;
                }
                for (ConnectionEntity connectionEntity : connectionsList) {
                    if (connectionEntity.getReceiver().getId() != identityEntity.getId() && connectionEntity.getSender().getId() != identityEntity.getId()) continue;
                    map.put(identityEntity, connectionEntity);
                    break;
                }
                if (map.containsKey(identityEntity)) continue;
                map.put(identityEntity, null);
            }
            ArrayList identities = new ArrayList(map.entrySet());
            identities.sort(new Comparator<Map.Entry<IdentityEntity, ConnectionEntity>>(){

                @Override
                public int compare(Map.Entry<IdentityEntity, ConnectionEntity> o1, Map.Entry<IdentityEntity, ConnectionEntity> o2) {
                    return idsLong.indexOf(o1.getKey().getId()) - idsLong.indexOf(o2.getKey().getId());
                }
            });
            return identities.toArray(new Map.Entry[0]);
        }

        public int getSize() throws Exception {
            return ((Long)this.countQuery.getSingleResult()).intValue();
        }
    }

    public static class JPAListAccess<T>
    implements ListAccess<T> {
        private final TypedQuery<T> selectQuery;
        private final TypedQuery<Long> countQuery;
        private final Class<T> clazz;

        public JPAListAccess(Class<T> clazz) {
            this.clazz = clazz;
            this.selectQuery = null;
            this.countQuery = null;
        }

        public JPAListAccess(Class<T> clazz, TypedQuery<T> selectQuery, TypedQuery<Long> countQuery) {
            this.clazz = clazz;
            this.selectQuery = selectQuery;
            this.countQuery = countQuery;
        }

        public T[] load(int offset, int limit) throws Exception, IllegalArgumentException {
            if (this.selectQuery == null) {
                return (Object[])Array.newInstance(this.clazz, 0);
            }
            if (limit > 0 && offset >= 0) {
                this.selectQuery.setFirstResult(offset);
                this.selectQuery.setMaxResults(limit);
            } else {
                this.selectQuery.setMaxResults(Integer.MAX_VALUE);
            }
            List list = this.selectQuery.getResultList();
            if (list != null && list.size() > 0) {
                Object[] arr = (Object[])Array.newInstance(this.clazz, list.size());
                return list.toArray(arr);
            }
            return (Object[])Array.newInstance(this.clazz, 0);
        }

        public int getSize() throws Exception {
            if (this.countQuery == null) {
                return 0;
            }
            return ((Long)this.countQuery.getSingleResult()).intValue();
        }
    }
}

