/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.j2ee.JbossLoginModule;
import org.jboss.security.auth.callback.MapCallback;

public class DigestAuthenticationJbossLoginModule
extends JbossLoginModule {
    private MapCallback[] mapCallback = new MapCallback[]{new MapCallback()};

    @Override
    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"In login of JbossLoginModule.");
        }
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                Authenticator authenticator;
                if (!this.digestAuthenticationIsUsed()) {
                    return super.login();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Try create identity");
                }
                if ((authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class)) == null) {
                    throw new LoginException("No Authenticator component found, check your configuration");
                }
                String userId = authenticator.validateUser(this.getCredentials());
                this.identity = authenticator.createIdentity(userId);
                this.sharedState.put("javax.security.auth.login.name", userId);
                this.subject.getPrivateCredentials().add(this.getPassword());
                this.subject.getPublicCredentials().add(this.getUsername());
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new LoginException(e.getMessage());
        }
    }

    private boolean digestAuthenticationIsUsed() throws IOException {
        try {
            this.callbackHandler.handle((Callback[])this.mapCallback);
            return true;
        }
        catch (UnsupportedCallbackException uce) {
            return false;
        }
    }

    private Credential[] getCredentials() throws IOException {
        HashMap<String, String> passwordContext;
        String password;
        String username;
        block6: {
            block5: {
                username = null;
                password = null;
                passwordContext = new HashMap<String, String>();
                passwordContext.put("qop", (String)this.mapCallback[0].getInfo("qop"));
                passwordContext.put("nonce", (String)this.mapCallback[0].getInfo("nonce"));
                passwordContext.put("cnonce", (String)this.mapCallback[0].getInfo("cnonce"));
                passwordContext.put("a2hash", (String)this.mapCallback[0].getInfo("a2hash"));
                passwordContext.put("nc", (String)this.mapCallback[0].getInfo("nc"));
                passwordContext.put("realm", (String)this.mapCallback[0].getInfo("realm"));
                try {
                    Callback[] nameCallback = new Callback[]{new NameCallback("Username")};
                    this.callbackHandler.handle(nameCallback);
                    username = ((NameCallback)nameCallback[0]).getName();
                }
                catch (UnsupportedCallbackException e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error((Object)"Error on retrieving username from callback handler! ", (Throwable)e);
                }
            }
            try {
                Callback[] passwordCallback = new Callback[]{new PasswordCallback("Password", false)};
                this.callbackHandler.handle(passwordCallback);
                password = new String(((PasswordCallback)passwordCallback[0]).getPassword());
                ((PasswordCallback)passwordCallback[0]).clearPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Error on retrieving password from callback handler! ", (Throwable)e);
            }
        }
        if (username == null || password == null) {
            return null;
        }
        return new Credential[]{new UsernameCredential(username), new PasswordCredential(password, passwordContext)};
    }

    private UsernameCredential getUsername() throws IOException {
        String username;
        block2: {
            username = null;
            try {
                Callback[] nameCallback = new Callback[]{new NameCallback("Username")};
                this.callbackHandler.handle(nameCallback);
                username = ((NameCallback)nameCallback[0]).getName();
            }
            catch (UnsupportedCallbackException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Error on retrieving username from callback handler! ", (Throwable)e);
            }
        }
        return new UsernameCredential(username);
    }

    private String getPassword() throws IOException {
        String password;
        block2: {
            password = null;
            try {
                Callback[] passwordCallback = new Callback[]{new PasswordCallback("Password", false)};
                this.callbackHandler.handle(passwordCallback);
                password = new String(((PasswordCallback)passwordCallback[0]).getPassword());
                ((PasswordCallback)passwordCallback[0]).clearPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Error on retrieving password from callback handler! ", (Throwable)e);
            }
        }
        return password;
    }
}

