/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.Serializable;
import java.util.Date;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.internal.Parameters;

public class PublicationDate
implements Serializable {
    private final long start;
    private final long end;

    public static PublicationDate startingOn(Date start) {
        Parameters.requireNonNull(start, "start");
        return new PublicationDate(Parameters.requireNonNull(start, "start").getTime(), -1L);
    }

    public static PublicationDate endingOn(Date end) {
        Parameters.requireNonNull(end, "end");
        return new PublicationDate(-1L, end.getTime());
    }

    public static PublicationDate between(Date start, Date end) {
        Parameters.requireNonNull(start, "start");
        Parameters.requireNonNull(end, "end");
        if (end.before(start)) {
            throw new IllegalArgumentException("End date must be after start date");
        }
        return new PublicationDate(start.getTime(), end.getTime());
    }

    private PublicationDate(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public boolean within(Date date) {
        Parameters.requireNonNull(date, "date");
        return this.within(date.getTime());
    }

    public boolean within(long time) {
        if (this.start != -1L && this.start > time) {
            return false;
        }
        return this.end == -1L || this.end >= time;
    }

    public Date getStart() {
        return this.start < 0L ? null : new Date(this.start);
    }

    public Date getEnd() {
        return this.end < 0L ? null : new Date(this.end);
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder().add("start", new Date(this.start)).add("end", new Date(this.end)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicationDate)) {
            return false;
        }
        PublicationDate that = (PublicationDate)o;
        return this.end == that.end && this.start == that.start;
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }
}

