/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmExtractor;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ChmParser
extends AbstractParser {
    private static final long serialVersionUID = 5938777307516469802L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-htmlhelp"), MediaType.application((String)"chm"), MediaType.application((String)"x-chm"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ChmExtractor chmExtractor = new ChmExtractor(stream);
        metadata.set("Content-Type", "application/vnd.ms-htmlhelp");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        for (DirectoryListingEntry entry : chmExtractor.getChmDirList().getDirectoryListingEntryList()) {
            if (!entry.getName().endsWith(".html") && !entry.getName().endsWith(".htm")) continue;
            xhtml.characters(this.extract(chmExtractor.extractChmEntry(entry)));
        }
        xhtml.endDocument();
    }

    private String extract(byte[] byteObject) throws TikaException {
        StringBuilder wBuf = new StringBuilder();
        ByteArrayInputStream stream = null;
        Metadata metadata = new Metadata();
        HtmlParser htmlParser = new HtmlParser();
        BodyContentHandler handler = new BodyContentHandler(-1);
        ParseContext parser = new ParseContext();
        try {
            stream = new ByteArrayInputStream(byteObject);
            htmlParser.parse(stream, (ContentHandler)handler, metadata, parser);
            wBuf.append(handler.toString() + System.getProperty("line.separator"));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            // empty catch block
        }
        return wBuf.toString();
    }
}

