/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.services.util.FileChecksum;

public class FileItem {
    protected FileInfo fileInfo;
    protected byte[] data;

    public FileItem(FileInfo fileInfo, InputStream inputStream) throws Exception {
        this.fileInfo = fileInfo;
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
            this.setChecksum(new ByteArrayInputStream(this.data));
        }
    }

    public FileItem(Long id, String name, String mimetype, String nameSpace, long size, Date updatedDate, String updater, boolean deleted, InputStream inputStream) throws Exception {
        this.fileInfo = new FileInfo(id, name, mimetype, nameSpace, size, updatedDate, updater, null, deleted);
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
            this.setChecksum(new ByteArrayInputStream(this.data));
        }
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public InputStream getAsStream() throws IOException {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return null;
    }

    public byte[] getAsByte() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
        }
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void setChecksum(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            String checksum = FileChecksum.getChecksum(inputStream);
            this.fileInfo.setChecksum(checksum);
        }
    }
}

