/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class DelegatingClassLoader
extends ClassLoader {
    private final List<ClassLoader> delegates;
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);

    public DelegatingClassLoader(ClassLoader ... delegates) {
        super(Thread.currentThread().getContextClassLoader());
        if (delegates == null || delegates.length == 0) {
            throw new IllegalArgumentException("Some delegating classloaders needs to be provided");
        }
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader delegate : this.delegates) {
            try {
                Class<?> cl = delegate.loadClass(name);
                if (cl != null) {
                    return cl;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Class " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        throw new ClassNotFoundException("Class " + name + " not found with any of delegates " + this.delegates);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader delegate : this.delegates) {
            InputStream is = delegate.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Resource " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader delegate : this.delegates) {
            URL url = delegate.getResource(name);
            if (url != null) {
                return url;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("URL " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        DelegateEnumeration<URL> ret = new DelegateEnumeration<URL>();
        for (ClassLoader delegate : this.delegates) {
            Enumeration<URL> e = delegate.getResources(name);
            if (e != null && e.hasMoreElements()) {
                ((DelegateEnumeration)ret).addEnumeration(e);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("URL " + name + " not found with classloader: " + delegate + ". Trying other delegates"));
        }
        return ret;
    }

    private static class DelegateEnumeration<E>
    implements Enumeration<E> {
        private ArrayList<Enumeration<E>> delegates = new ArrayList();
        private int current = 0;

        private DelegateEnumeration() {
        }

        private void addEnumeration(Enumeration<E> enumeration) {
            this.delegates.add(enumeration);
        }

        @Override
        public boolean hasMoreElements() {
            Enumeration<E> e = this.getCurrent();
            return e != null && e.hasMoreElements();
        }

        @Override
        public E nextElement() {
            Enumeration<E> e = this.getCurrent();
            if (e != null) {
                return e.nextElement();
            }
            throw new NoSuchElementException();
        }

        private Enumeration<E> getCurrent() {
            if (this.delegates.size() == 0) {
                return null;
            }
            if (this.current >= this.delegates.size()) {
                return null;
            }
            Enumeration<E> e = this.delegates.get(this.current);
            if (!e.hasMoreElements()) {
                ++this.current;
                if (this.current < this.delegates.size()) {
                    return this.delegates.get(this.current);
                }
                return null;
            }
            return e;
        }
    }
}

