/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextToPDF {
    private int fontSize = 10;
    private boolean landscape = false;
    private PDSimpleFont font = PDType1Font.HELVETICA;

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        try {
            int margin = 40;
            float height = this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
            PDRectangle mediaBox = PDPage.PAGE_SIZE_LETTER;
            if (this.landscape) {
                mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
            }
            height = height * (float)this.fontSize * 1.05f;
            BufferedReader data = new BufferedReader(text);
            String nextLine = null;
            PDPage page = new PDPage(mediaBox);
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
            boolean textIsEmpty = true;
            while ((nextLine = data.readLine()) != null) {
                textIsEmpty = false;
                String[] lineWords = nextLine.replaceAll("[\\n\\r]+$", "").split(" ");
                int lineIndex = 0;
                while (lineIndex < lineWords.length) {
                    StringBuilder nextLineToDraw = new StringBuilder();
                    float lengthIfUsingNextWord = 0.0f;
                    boolean ff = false;
                    do {
                        String word1;
                        String word2 = "";
                        int indexFF = lineWords[lineIndex].indexOf(12);
                        if (indexFF == -1) {
                            word1 = lineWords[lineIndex];
                        } else {
                            ff = true;
                            word1 = lineWords[lineIndex].substring(0, indexFF);
                            if (indexFF < lineWords[lineIndex].length()) {
                                word2 = lineWords[lineIndex].substring(indexFF + 1);
                            }
                        }
                        if (word1.length() > 0 || !ff) {
                            nextLineToDraw.append(word1);
                            nextLineToDraw.append(" ");
                        }
                        if (!ff || word2.length() == 0) {
                            ++lineIndex;
                        } else {
                            lineWords[lineIndex] = word2;
                        }
                        if (ff) break;
                        if (lineIndex >= lineWords.length) continue;
                        String nextWord = lineWords[lineIndex];
                        indexFF = nextWord.indexOf(12);
                        if (indexFF != -1) {
                            nextWord = nextWord.substring(0, indexFF);
                        }
                        String lineWithNextWord = nextLineToDraw.toString() + " " + nextWord;
                        lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                    } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                    if (y < 40.0f) {
                        page = new PDPage(mediaBox);
                        doc.addPage(page);
                        if (contentStream != null) {
                            contentStream.endText();
                            contentStream.close();
                        }
                        contentStream = new PDPageContentStream(doc, page);
                        contentStream.setFont(this.font, this.fontSize);
                        contentStream.beginText();
                        y = page.getMediaBox().getHeight() - 40.0f + height;
                        contentStream.moveTextPositionByAmount(40.0f, y);
                    }
                    if (contentStream == null) {
                        throw new IOException("Error:Expected non-null content stream.");
                    }
                    contentStream.moveTextPositionByAmount(0.0f, -height);
                    y -= height;
                    contentStream.drawString(nextLineToDraw.toString());
                    if (!ff) continue;
                    page = new PDPage(mediaBox);
                    doc.addPage(page);
                    contentStream.endText();
                    contentStream.close();
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.setFont(this.font, this.fontSize);
                    contentStream.beginText();
                    y = page.getMediaBox().getHeight() - 40.0f + height;
                    contentStream.moveTextPositionByAmount(40.0f, y);
                }
            }
            if (textIsEmpty) {
                doc.addPage(page);
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        TextToPDF app = new TextToPDF();
        PDDocument doc = new PDDocument();
        try {
            try {
                if (args.length < 2) {
                    app.usage();
                }
                for (int i = 0; i < args.length - 2; ++i) {
                    if (args[i].equals("-standardFont")) {
                        app.setFont(PDType1Font.getStandardFont(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ttf")) {
                        PDTrueTypeFont font = PDTrueTypeFont.loadTTF(doc, new File(args[++i]));
                        app.setFont(font);
                        continue;
                    }
                    if (args[i].equals("-fontSize")) {
                        app.setFontSize(Integer.parseInt(args[++i]));
                        continue;
                    }
                    if (!args[i].equals("-landscape")) throw new IOException("Unknown argument:" + args[i]);
                    app.setLandscape(true);
                }
                app.createPDFFromText(doc, new FileReader(args[args.length - 1]));
                doc.save(args[args.length - 2]);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var6_7 = null;
                doc.close();
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            doc.close();
            throw throwable;
        }
        doc.close();
    }

    private void usage() {
        String[] std14 = PDType1Font.getStandard14Names();
        System.err.println("usage: jar -jar pdfbox-app-x.y.z.jar TextToPDF [options] <output-file> <text-file>");
        System.err.println("    -standardFont <name>    default:" + PDType1Font.HELVETICA.getBaseFont());
        for (int i = 0; i < std14.length; ++i) {
            System.err.println("                                    " + std14[i]);
        }
        System.err.println("    -ttf <ttf file>         The TTF font to use.");
        System.err.println("    -fontSize <fontSize>    default:10");
        System.err.println("    -landscape              sets orientation to landscape");
    }

    public PDSimpleFont getFont() {
        return this.font;
    }

    public void setFont(PDSimpleFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }
}

