/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.transport;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.websocket.server.AbstractWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.api.websocket.AbstractConfigurator;
import org.exoplatform.commons.api.websocket.AbstractEndpoint;

public class ExoWebSocketTransport
extends AbstractWebSocketTransport<Session> {
    public ExoWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            throw new IllegalArgumentException("Missing WebSocket ServerContainer");
        }
        int maxMessageSize = this.getOption("maxMessageSize", container.getDefaultMaxTextMessageBufferSize());
        container.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getDefaultMaxSessionIdleTimeout());
        container.setDefaultMaxSessionIdleTimeout(idleTimeout);
        String protocol = this.getProtocol();
        List<String> protocols = protocol == null ? null : Collections.singletonList(protocol);
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketScheduler.class, (String)mapping).subprotocols(protocols).configurator((ServerEndpointConfig.Configurator)new Configurator(context)).build();
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public void destroy() {
        Executor threadPool = this.getExecutor();
        if (threadPool instanceof LifeCycle) {
            try {
                ((LifeCycle)threadPool).stop();
            }
            catch (Exception x) {
                this._logger.trace("", (Throwable)x);
            }
        }
        super.destroy();
    }

    protected boolean checkOrigin(String origin) {
        return true;
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    protected void send(final Session wsSession, final ServerSession session, String data, final Callback callback) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending {}", (Object)data);
        }
        wsSession.getAsyncRemote().sendText(data, new SendHandler(){

            public void onResult(SendResult result) {
                Throwable failure = result.getException();
                if (failure == null) {
                    callback.succeeded();
                } else {
                    ExoWebSocketTransport.this.handleException(wsSession, session, failure);
                    callback.failed(failure);
                }
            }
        });
    }

    private class Configurator
    extends AbstractConfigurator {
        private final ServletContext servletContext;
        private WebSocketContext bayeuxContext;
        private boolean protocolMatches;

        private Configurator(ServletContext servletContext) {
            this.servletContext = servletContext;
            this.protocolMatches = true;
        }

        public void doModifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            this.bayeuxContext = new WebSocketContext(this.servletContext, request, sec.getUserProperties());
            ExoWebSocketTransport.this.modifyHandshake(request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return ExoWebSocketTransport.this.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            this.protocolMatches = ExoWebSocketTransport.this.checkProtocol(supported, requested);
            if (this.protocolMatches) {
                return super.getNegotiatedSubprotocol(supported, requested);
            }
            ExoWebSocketTransport.this._logger.warn("Could not negotiate WebSocket SubProtocols: server{} != client{}", supported, requested);
            return null;
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            return super.getNegotiatedExtensions(installed, requested);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (!ExoWebSocketTransport.this.getBayeux().getAllowedTransports().contains(ExoWebSocketTransport.this.getName())) {
                throw new InstantiationException("Transport not allowed");
            }
            if (!this.protocolMatches) {
                throw new InstantiationException("Could not negotiate WebSocket SubProtocols");
            }
            return (T)((Object)new WebSocketScheduler(this.bayeuxContext));
        }
    }

    private class WebSocketContext
    implements BayeuxContext {
        private final ServletContext context;
        private final String url;
        private final Principal principal;
        private final Map<String, List<String>> headers;
        private final Map<String, List<String>> parameters;
        private final HttpSession session;
        private final InetSocketAddress localAddress;
        private final InetSocketAddress remoteAddress;
        private final List<Locale> locales;

        private WebSocketContext(ServletContext context, HandshakeRequest request, Map<String, Object> userProperties) {
            this.context = context;
            String uri = request.getRequestURI().toString();
            String query = request.getQueryString();
            if (query != null) {
                uri = uri + "?" + query;
            }
            this.url = uri;
            this.principal = request.getUserPrincipal();
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(request.getHeaders());
            this.parameters = request.getParameterMap();
            this.session = (HttpSession)request.getHttpSession();
            this.localAddress = (InetSocketAddress)userProperties.get("javax.websocket.endpoint.localAddress");
            this.remoteAddress = (InetSocketAddress)userProperties.get("javax.websocket.endpoint.remoteAddress");
            this.locales = this.retrieveLocales(userProperties);
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        public String getHeader(String name) {
            List<String> values = this.headers.get(name);
            return values != null && values.size() > 0 ? values.get(0) : null;
        }

        public List<String> getHeaderValues(String name) {
            return this.headers.get(name);
        }

        public String getParameter(String name) {
            List<String> values = this.parameters.get(name);
            return values != null && values.size() > 0 ? values.get(0) : null;
        }

        public List<String> getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public String getCookie(String name) {
            List<String> values = this.headers.get("Cookie");
            if (values != null) {
                for (String value : values) {
                    for (HttpCookie cookie : HttpCookie.parse(value)) {
                        if (!cookie.getName().equals(name)) continue;
                        return cookie.getValue();
                    }
                }
            }
            return null;
        }

        public String getHttpSessionId() {
            return this.session == null ? null : this.session.getId();
        }

        public Object getHttpSessionAttribute(String name) {
            return this.session == null ? null : this.session.getAttribute(name);
        }

        public void setHttpSessionAttribute(String name, Object value) {
            if (this.session != null) {
                this.session.setAttribute(name, value);
            }
        }

        public void invalidateHttpSession() {
            if (this.session != null) {
                this.session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return null;
        }

        public Object getContextAttribute(String name) {
            return this.context.getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this.context.getInitParameter(name);
        }

        public String getURL() {
            return this.url;
        }

        public List<Locale> getLocales() {
            return this.locales;
        }

        private List<Locale> retrieveLocales(Map<String, Object> userProperties) {
            List localeList = (List)userProperties.get("javax.websocket.locales");
            if (localeList == null || localeList.isEmpty()) {
                return Collections.singletonList(Locale.getDefault());
            }
            return localeList;
        }
    }

    private class WSSchedulerDelegate
    extends AbstractWebSocketTransport.AbstractWebSocketScheduler {
        private Session session;

        public WSSchedulerDelegate(WebSocketContext context) {
            super((AbstractWebSocketTransport)ExoWebSocketTransport.this, (BayeuxContext)context);
        }

        protected void onClose(int code, String reason) {
            super.onClose(code, reason);
        }

        protected void onError(Throwable failure) {
            super.onError(failure);
        }

        protected void onMessage(Session wsSession, String data) {
            super.onMessage((Object)wsSession, data);
        }

        protected void close(int code, String reason) {
            try {
                this.session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
            }
            catch (IOException x) {
                this._logger.trace("Could not close WebSocket session " + this.session, (Throwable)x);
            }
        }

        protected void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            this.schedule(this.session, timeout, expiredConnectReply);
        }

        public void setSession(Session session) {
            this.session = session;
        }
    }

    private class WebSocketScheduler
    extends AbstractEndpoint
    implements AbstractServerTransport.Scheduler {
        private WSSchedulerDelegate delegate;

        private WebSocketScheduler(WebSocketContext context) {
            this.delegate = new WSSchedulerDelegate(context);
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public void schedule() {
            this.delegate.schedule();
        }

        protected void doOpen(Session wsSession, EndpointConfig config) {
            this.delegate.setSession(wsSession);
        }

        protected void doClose(Session wsSession, CloseReason closeReason) {
            this.delegate.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }

        protected void doError(Session wsSession, Throwable failure) {
            this.delegate.onError(failure);
        }

        protected void doMessage(Session wsSession, String message) {
            if (ExoWebSocketTransport.this._logger.isDebugEnabled()) {
                ExoWebSocketTransport.this._logger.debug("WebSocket Text message on {}/{}", (Object)((Object)((Object)ExoWebSocketTransport.this)).hashCode(), (Object)((Object)((Object)this)).hashCode());
            }
            this.delegate.onMessage(wsSession, message);
        }

        protected void doMessage(Session wsSession, String message, boolean arg1) {
            if (ExoWebSocketTransport.this._logger.isDebugEnabled()) {
                ExoWebSocketTransport.this._logger.debug("WebSocket Text message on {}/{}", (Object)((Object)((Object)ExoWebSocketTransport.this)).hashCode(), (Object)((Object)((Object)this)).hashCode());
            }
            this.delegate.onMessage(wsSession, message);
        }
    }
}

