/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.openid;

import com.github.scribejava.core.model.OAuth2AccessToken;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.security.SecureRandomService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.openid.OpenIdAccessTokenContext;
import org.gatein.security.oauth.openid.OpenIdProcessor;
import org.gatein.security.oauth.openid.OpenIdRequest;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthCodec;
import org.gatein.security.oauth.utils.HttpResponseContext;
import org.gatein.security.oauth.utils.OAuthPersistenceUtils;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdProcessorImpl
implements OpenIdProcessor {
    private static Logger log = LoggerFactory.getLogger(OpenIdProcessorImpl.class);
    private final String redirectURL;
    private final String authenticationURL;
    private final String accessTokenURL;
    private final String tokenInfoURL;
    private final String userInfoURL;
    private final String clientID;
    private final String clientSecret;
    private final Set<String> scopes = new HashSet<String>();
    private final String accessType;
    private final String applicationName;
    private final int chunkLength;
    private final SecureRandomService secureRandomService;

    public OpenIdProcessorImpl(ExoContainerContext context, InitParams params, SecureRandomService secureRandomService) {
        this.clientID = params.getValueParam("clientId").getValue();
        this.clientSecret = params.getValueParam("clientSecret").getValue();
        this.authenticationURL = params.getValueParam("authenticationURL").getValue();
        this.accessTokenURL = params.getValueParam("accessTokenURL").getValue();
        this.tokenInfoURL = params.getValueParam("tokenInfoURL").getValue();
        this.userInfoURL = params.getValueParam("userInfoURL").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        String scope = params.getValueParam("scope").getValue();
        this.accessType = params.getValueParam("accessType").getValue();
        ValueParam appNameParam = params.getValueParam("applicationName");
        this.applicationName = appNameParam != null && appNameParam.getValue() != null ? appNameParam.getValue() : "GateIn portal";
        if (this.clientID == null || this.clientID.length() == 0 || this.clientID.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your OpenId application");
        }
        if (this.clientSecret == null || this.clientSecret.length() == 0 || this.clientSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your OpenId application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/openidAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        this.addScopesFromString(scope, this.scopes);
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: clientId=" + this.clientID + ", clientSecret=" + this.clientSecret + ", redirectURL=" + this.redirectURL + ", scope=" + this.scopes + ", accessType=" + this.accessType + ", applicationName=" + this.applicationName + ", chunkLength=" + this.chunkLength));
        }
        this.secureRandomService = secureRandomService;
    }

    @Override
    public InteractionState<OpenIdAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OAuthException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, this.scopes);
    }

    @Override
    public InteractionState<OpenIdAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException {
        HashSet<String> scopes = new HashSet<String>();
        this.addScopesFromString(scope, scopes);
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, scopes);
    }

    protected InteractionState<OpenIdAccessTokenContext> processOAuthInteractionImpl(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("_authState");
        if (state == null || state.isEmpty()) {
            return this.initialInteraction(request, response, scopes);
        }
        if (state.equals(InteractionState.State.AUTH.name())) {
            OAuth2AccessToken tokenResponse = this.obtainAccessToken(request);
            OpenIdAccessTokenContext accessTokenContext = this.validateTokenAndUpdateScopes(new OpenIdAccessTokenContext(tokenResponse, new String[0]));
            session.removeAttribute("_authState");
            session.removeAttribute("_verificationState");
            return new InteractionState<OpenIdAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        return new InteractionState<Object>(InteractionState.State.valueOf(state), null);
    }

    protected InteractionState<OpenIdAccessTokenContext> initialInteraction(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException {
        String verificationState = String.valueOf(this.secureRandomService.getSecureRandom().nextLong());
        String authorizeUrl = this.authenticationURL + "?response_type=code&client_id=" + this.clientID + "&scope=" + this.scopes.stream().collect(Collectors.joining(" ")) + "&redirect_uri=" + this.redirectURL + "&state=" + verificationState;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting OAuth2 interaction with OpenId");
            log.trace((Object)("URL to send to OpenId: " + authorizeUrl));
        }
        HttpSession session = request.getSession();
        session.setAttribute("_verificationState", (Object)verificationState);
        session.setAttribute("_authState", (Object)InteractionState.State.AUTH.name());
        response.sendRedirect(authorizeUrl);
        return new InteractionState<Object>(InteractionState.State.AUTH, null);
    }

    protected OAuth2AccessToken obtainAccessToken(HttpServletRequest request) throws IOException {
        HttpSession session = request.getSession();
        String stateFromSession = (String)session.getAttribute("_verificationState");
        String stateFromRequest = request.getParameter("state");
        if (stateFromSession == null || stateFromRequest == null || !stateFromSession.equals(stateFromRequest)) {
            throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "Validation of state parameter failed. stateFromSession=" + stateFromSession + ", stateFromRequest=" + stateFromRequest);
        }
        String error = request.getParameter("error");
        if (error != null) {
            if ("access_denied".equals(error)) {
                throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, error);
            }
            throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, error);
        }
        String code = request.getParameter("code");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.clientID);
        params.put("client_secret", this.clientSecret);
        params.put("redirect_uri", this.redirectURL);
        params.put("grant_type", "authorization_code");
        OAuth2AccessToken tokenResponse = (OAuth2AccessToken)new OpenIdRequest<OAuth2AccessToken>(){

            @Override
            protected URL createURL() throws IOException {
                return OpenIdProcessorImpl.this.sendAccessTokenRequest();
            }

            @Override
            protected OAuth2AccessToken invokeRequest(Map<String, String> params) throws IOException, JSONException {
                String errorMessage;
                URL url = this.createURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                String urlParameters = params.keySet().stream().map(s -> s + "=" + (String)params.get(s)).collect(Collectors.joining("&"));
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("charset", "utf-8");
                conn.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
                conn.setUseCaches(false);
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                    wr.write(urlParameters.getBytes());
                }
                HttpResponseContext httpResponse = OAuthUtils.readUrlContent(conn);
                if (httpResponse.getResponseCode() == 200) {
                    return this.parseResponse(httpResponse.getResponse());
                }
                if (httpResponse.getResponseCode() == 400) {
                    errorMessage = "Error when obtaining content from OpenId. Error details: " + httpResponse.getResponse();
                    log.warn((Object)errorMessage);
                    throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, errorMessage);
                }
                errorMessage = "Unspecified IO error. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse();
                log.warn((Object)errorMessage);
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, errorMessage);
            }

            @Override
            protected OAuth2AccessToken parseResponse(String httpResponse) throws JSONException {
                JSONObject json = new JSONObject(httpResponse);
                String accessToken = json.getString("access_token");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Access Token=" + accessToken));
                }
                OAuth2AccessToken tokenResponse = new OAuth2AccessToken(accessToken, json.getString("token_type"), Integer.valueOf(json.getInt("expires_in")), null, json.has("scope") ? json.getString("scope") : null, json.toString());
                return tokenResponse;
            }
        }.executeRequest(params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained accessToken from openid: " + tokenResponse));
        }
        return tokenResponse;
    }

    @Override
    public OpenIdAccessTokenContext validateTokenAndUpdateScopes(OpenIdAccessTokenContext accessToken) throws OAuthException {
        String[] scopes;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", accessToken.getAccessToken());
        params.put("access_token", accessToken.getAccessToken());
        JSONObject tokenInfo = (JSONObject)new OpenIdRequest<JSONObject>(){

            @Override
            protected URL createURL() throws IOException {
                return OpenIdProcessorImpl.this.getTokenInfoURL();
            }

            @Override
            protected JSONObject invokeRequest(Map<String, String> params) throws IOException, JSONException {
                String errorMessage;
                URL url = this.createURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                String urlParameters = params.keySet().stream().map(s -> s + "=" + (String)params.get(s)).collect(Collectors.joining("&"));
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("charset", "utf-8");
                conn.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((OpenIdProcessorImpl.this.clientID + ":" + OpenIdProcessorImpl.this.clientSecret).getBytes()));
                conn.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
                conn.setUseCaches(false);
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                    wr.write(urlParameters.getBytes());
                }
                HttpResponseContext httpResponse = OAuthUtils.readUrlContent(conn);
                if (httpResponse.getResponseCode() == 200) {
                    return this.parseResponse(httpResponse.getResponse());
                }
                if (httpResponse.getResponseCode() == 400) {
                    errorMessage = "Error when obtaining content from OpenId. Error details: " + httpResponse.getResponse();
                    log.warn((Object)errorMessage);
                    throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, errorMessage);
                }
                errorMessage = "Unspecified IO error. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse();
                log.warn((Object)errorMessage);
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, errorMessage);
            }

            @Override
            protected JSONObject parseResponse(String httpResponse) throws JSONException {
                JSONObject json = new JSONObject(httpResponse);
                return json;
            }
        }.executeRequest(params);
        try {
            String clientId;
            if (tokenInfo.has("error")) {
                throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error during token validation: " + tokenInfo.get("error").toString());
            }
            String string = tokenInfo.has("issued_to") ? tokenInfo.getString("issued_to") : (clientId = tokenInfo.has("client_id") ? tokenInfo.getString("client_id") : null);
            if (clientId != null && !clientId.equals(this.clientID)) {
                throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Token's client ID does not match app's. clientID from tokenINFO: " + tokenInfo.get("issued_to"));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully validated accessToken from openid : " + tokenInfo));
            }
            scopes = tokenInfo.has("scope") ? tokenInfo.getString("scope").split(" ") : null;
        }
        catch (JSONException jsonException) {
            throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error during token validation: token format is ko");
        }
        return new OpenIdAccessTokenContext(accessToken.getTokenData(), scopes);
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(OpenIdAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        return null;
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, OpenIdAccessTokenContext accessToken) {
        String encodedAccessToken = codec.encodeString(accessToken.accessToken.getAccessToken());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.openid.accessToken", false, this.chunkLength);
    }

    @Override
    public OpenIdAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.openid.accessToken", false);
        String encodedAccessTokenSecret = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.openid.accessTokenSecret", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        String decodedAccessTokenSecret = codec.decodeString(encodedAccessTokenSecret);
        if (decodedAccessToken == null || decodedAccessTokenSecret == null) {
            return null;
        }
        OAuth2AccessToken token = new OAuth2AccessToken(decodedAccessToken, decodedAccessTokenSecret);
        return new OpenIdAccessTokenContext(token, new String[0]);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.openid.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.openid.accessTokenSecret", false);
    }

    @Override
    public JSONObject obtainUserInfo(OpenIdAccessTokenContext accessTokenContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessTokenContext.getAccessToken());
        OpenIdRequest<JSONObject> userInfoRequest = new OpenIdRequest<JSONObject>(){

            @Override
            protected URL createURL() throws IOException {
                return OpenIdProcessorImpl.this.getUserInfoURL();
            }

            @Override
            protected JSONObject invokeRequest(Map<String, String> params) throws IOException, JSONException {
                URL url = this.createURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + params.get("access_token"));
                HttpResponseContext httpResponse = OAuthUtils.readUrlContent(conn);
                if (httpResponse.getResponseCode() == 200) {
                    return this.parseResponse(httpResponse.getResponse());
                }
                if (httpResponse.getResponseCode() == 400) {
                    String errorMessage = "Error when obtaining content from OpenId. Error details: " + httpResponse.getResponse();
                    log.warn((Object)errorMessage);
                    throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, errorMessage);
                }
                String errorMessage = "Unspecified IO error. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse();
                log.warn((Object)errorMessage);
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, errorMessage);
            }

            @Override
            protected JSONObject parseResponse(String httpResponse) throws JSONException {
                JSONObject json = new JSONObject(httpResponse);
                return json;
            }
        };
        JSONObject uinfo = (JSONObject)userInfoRequest.executeRequest(params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained userInfo from openid: " + uinfo));
        }
        return uinfo;
    }

    @Override
    public void revokeToken(OpenIdAccessTokenContext accessToken) throws OAuthException {
    }

    private void addScopesFromString(String scope, Set<String> scopes) {
        String[] scopes2;
        for (String current : scopes2 = scope.split(" ")) {
            scopes.add(current);
        }
    }

    protected URL sendAccessTokenRequest() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("AccessToken Request=" + this.accessTokenURL));
        }
        return new URL(this.accessTokenURL);
    }

    protected URL getTokenInfoURL() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TokenInfo Request=" + this.tokenInfoURL));
        }
        return new URL(this.tokenInfoURL);
    }

    protected URL getUserInfoURL() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("UserInfo Request=" + this.userInfoURL));
        }
        return new URL(this.userInfoURL);
    }
}

