/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.CatalogGenConfig;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.ResultService;

public class CatGenConfigMetadataFactory
implements MetadataConverterIF {
    private static Logger log = LoggerFactory.getLogger(CatGenConfigMetadataFactory.class);
    private static boolean showParsedXML = false;
    private static boolean debug = false;
    private static final Namespace CATALOG_GEN_CONFIG_NAMESPACE_0_5 = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5");

    public CatGenConfigMetadataFactory() {
        log.debug("CatGenConfigMetadataFactory(): .");
    }

    private Object readMetadataContentFromURL(InvDataset dataset, String urlString) throws MalformedURLException, IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(true);
            doc = builder.build(urlString);
        }
        catch (JDOMException e) {
            log.error("CatGenConfigMetadataFactory parsing error= \n" + e.getMessage());
            throw new IOException("CatGenConfigMetadataFactory parsing error= " + e.getMessage());
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
            System.out.println("*** catalog/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        return this.readMetadataContentJdom(dataset, doc.getRootElement());
    }

    public Object readMetadataContent(InvDataset dataset, Element mdataElement) {
        log.debug("readMetadataContent(): .");
        return this.readMetadataContentJdom(dataset, mdataElement);
    }

    public Object readMetadataContentFromURL(InvDataset dataset, URI uri) throws IOException {
        return null;
    }

    public void addMetadataContent(Element mdataJdomElement, Object contentObject) {
        ArrayList catGenConfigList = (ArrayList)contentObject;
        for (CatalogGenConfig cgc : catGenConfigList) {
            mdataJdomElement.addContent((Content)this.createCatGenConfigElement(cgc));
        }
    }

    public boolean validateMetadataContent(Object contentObject, StringBuilder out) {
        boolean ok = true;
        ArrayList catGenConfigList = (ArrayList)contentObject;
        for (CatalogGenConfig catGenConf : catGenConfigList) {
            ok &= catGenConf.validate(out);
        }
        return ok;
    }

    private Object readMetadataContentJdom(InvDataset dataset, Element mdataElement) {
        Object catGenConfigNamespace = null;
        ArrayList<CatalogGenConfig> catGenConfigList = new ArrayList<CatalogGenConfig>();
        Iterator iter = mdataElement.getChildren("catalogGenConfig", CATALOG_GEN_CONFIG_NAMESPACE_0_5).iterator();
        if (!iter.hasNext()) {
            iter = mdataElement.getChildren("catalogGenConfig", mdataElement.getNamespace()).iterator();
        }
        while (iter.hasNext()) {
            Element catGenConfigElement = (Element)iter.next();
            if (debug) {
                log.debug("readMetadataContent=" + catGenConfigElement);
            }
            catGenConfigList.add(this.readCatGenConfigElement(dataset, catGenConfigElement));
        }
        return catGenConfigList;
    }

    private CatalogGenConfig readCatGenConfigElement(InvDataset parentDataset, Element catGenConfElement) {
        String type = catGenConfElement.getAttributeValue("type");
        CatalogGenConfig catGenConf = new CatalogGenConfig(parentDataset, type);
        List list = catGenConfElement.getChildren("datasetSource", catGenConfElement.getNamespace());
        for (int i = 0; i < list.size(); ++i) {
            Element dsSourceElement = (Element)list.get(i);
            catGenConf.setDatasetSource(this.readDatasetSourceElement(parentDataset, dsSourceElement));
        }
        return catGenConf;
    }

    private DatasetSource readDatasetSourceElement(InvDataset parentDataset, Element dsSourceElement) {
        int i;
        String name = dsSourceElement.getAttributeValue("name");
        String type = dsSourceElement.getAttributeValue("type");
        String structure = dsSourceElement.getAttributeValue("structure");
        String accessPoint = dsSourceElement.getAttributeValue("accessPoint");
        String createCatalogRefs = dsSourceElement.getAttributeValue("createCatalogRefs");
        Element resultServiceElement = dsSourceElement.getChild("resultService", dsSourceElement.getNamespace());
        ResultService resultService = this.readResultServiceElement(parentDataset, resultServiceElement);
        DatasetSource dsSource = DatasetSource.newDatasetSource(name, DatasetSourceType.getType(type), DatasetSourceStructure.getStructure(structure), accessPoint, resultService);
        if (createCatalogRefs != null) {
            dsSource.setCreateCatalogRefs(Boolean.valueOf(createCatalogRefs));
        }
        List list = dsSourceElement.getChildren("datasetNamer", dsSourceElement.getNamespace());
        for (i = 0; i < list.size(); ++i) {
            Element dsNamerElement = (Element)list.get(i);
            dsSource.addDatasetNamer(this.readDatasetNamerElement(parentDataset, dsNamerElement));
        }
        list = dsSourceElement.getChildren("datasetFilter", dsSourceElement.getNamespace());
        for (i = 0; i < list.size(); ++i) {
            Element dsFilterElement = (Element)list.get(i);
            dsSource.addDatasetFilter(this.readDatasetFilterElement(dsSource, dsFilterElement));
        }
        return dsSource;
    }

    private DatasetNamer readDatasetNamerElement(InvDataset parentDataset, Element dsNamerElement) {
        String name = dsNamerElement.getAttributeValue("name");
        String addLevel = dsNamerElement.getAttributeValue("addLevel");
        String type = dsNamerElement.getAttributeValue("type");
        String matchPattern = dsNamerElement.getAttributeValue("matchPattern");
        String substitutePattern = dsNamerElement.getAttributeValue("substitutePattern");
        String attribContainer = dsNamerElement.getAttributeValue("attribContainer");
        String attribName = dsNamerElement.getAttributeValue("attribName");
        DatasetNamer dsNamer = new DatasetNamer(parentDataset, name, addLevel, type, matchPattern, substitutePattern, attribContainer, attribName);
        return dsNamer;
    }

    private DatasetFilter readDatasetFilterElement(DatasetSource parentDatasetSource, Element dsFilterElement) {
        String name = dsFilterElement.getAttributeValue("name");
        String type = dsFilterElement.getAttributeValue("type");
        String matchPattern = dsFilterElement.getAttributeValue("matchPattern");
        DatasetFilter dsFilter = new DatasetFilter(parentDatasetSource, name, DatasetFilter.Type.getType(type), matchPattern);
        String matchPatternTarget = dsFilterElement.getAttributeValue("matchPatternTarget");
        dsFilter.setMatchPatternTarget(matchPatternTarget);
        if (dsFilterElement.getAttributeValue("applyToCollectionDatasets") != null) {
            boolean applyToCollectionDatasets = Boolean.valueOf(dsFilterElement.getAttributeValue("applyToCollectionDatasets"));
            dsFilter.setApplyToCollectionDatasets(applyToCollectionDatasets);
        }
        if (dsFilterElement.getAttributeValue("applyToAtomicDatasets") != null) {
            boolean applyToAtomicDatasets = Boolean.valueOf(dsFilterElement.getAttributeValue("applyToAtomicDatasets"));
            dsFilter.setApplyToAtomicDatasets(applyToAtomicDatasets);
        }
        if (dsFilterElement.getAttributeValue("rejectMatchingDatasets") != null) {
            boolean rejectMatchingDatasets = Boolean.valueOf(dsFilterElement.getAttributeValue("rejectMatchingDatasets"));
            dsFilter.setRejectMatchingDatasets(rejectMatchingDatasets);
        }
        return dsFilter;
    }

    private ResultService readResultServiceElement(InvDataset parentDataset, Element resultServiceElement) {
        String name = resultServiceElement.getAttributeValue("name");
        String serviceType = resultServiceElement.getAttributeValue("serviceType");
        String base = resultServiceElement.getAttributeValue("base");
        String suffix = resultServiceElement.getAttributeValue("suffix");
        String accessPointHeader = resultServiceElement.getAttributeValue("accessPointHeader");
        return new ResultService(name, ServiceType.getType(serviceType), base, suffix, accessPointHeader);
    }

    private Element createCatGenConfigElement(CatalogGenConfig cgc) {
        Element cgcElem = new Element("catalogGenConfig", CATALOG_GEN_CONFIG_NAMESPACE_0_5);
        if (cgc != null) {
            if (cgc.getType() != null) {
                cgcElem.setAttribute("type", cgc.getType().toString());
            }
            DatasetSource dsSource = cgc.getDatasetSource();
            cgcElem.addContent((Content)this.createDatasetSourceElement(dsSource));
        }
        return cgcElem;
    }

    private Element createDatasetSourceElement(DatasetSource dsSource) {
        Element dssElem = new Element("datasetSource", CATALOG_GEN_CONFIG_NAMESPACE_0_5);
        if (dsSource != null) {
            int j;
            if (dsSource.getName() != null) {
                dssElem.setAttribute("name", dsSource.getName());
            }
            if (dsSource.getType() != null) {
                dssElem.setAttribute("type", dsSource.getType().toString());
            }
            if (dsSource.getStructure() != null) {
                dssElem.setAttribute("structure", dsSource.getStructure().toString());
            }
            if (dsSource.getAccessPoint() != null) {
                dssElem.setAttribute("accessPoint", dsSource.getAccessPoint());
            }
            dssElem.setAttribute("createCatalogRefs", Boolean.toString(dsSource.isCreateCatalogRefs()));
            ResultService rs = dsSource.getResultService();
            dssElem.addContent((Content)this.createResultServiceElement(rs));
            List list = dsSource.getDatasetNamerList();
            for (j = 0; j < list.size(); ++j) {
                DatasetNamer dsNamer = (DatasetNamer)list.get(j);
                dssElem.addContent((Content)this.createDatasetNamerElement(dsNamer));
            }
            list = dsSource.getDatasetFilterList();
            for (j = 0; j < list.size(); ++j) {
                DatasetFilter dsFilter = (DatasetFilter)list.get(j);
                dssElem.addContent((Content)this.createDatasetFilterElement(dsFilter));
            }
        }
        return dssElem;
    }

    private Element createDatasetNamerElement(DatasetNamer dsNamer) {
        Element dsnElem = new Element("datasetNamer", CATALOG_GEN_CONFIG_NAMESPACE_0_5);
        if (dsNamer != null) {
            if (dsNamer.getName() != null) {
                dsnElem.setAttribute("name", dsNamer.getName());
            }
            dsnElem.setAttribute("addLevel", Boolean.toString(dsNamer.getAddLevel()));
            if (dsNamer.getType() != null) {
                dsnElem.setAttribute("type", dsNamer.getType().toString());
            }
            if (dsNamer.getMatchPattern() != null) {
                dsnElem.setAttribute("matchPattern", dsNamer.getMatchPattern());
            }
            if (dsNamer.getSubstitutePattern() != null) {
                dsnElem.setAttribute("substitutePattern", dsNamer.getSubstitutePattern());
            }
            if (dsNamer.getAttribContainer() != null) {
                dsnElem.setAttribute("attribContainer", dsNamer.getAttribContainer());
            }
            if (dsNamer.getAttribName() != null) {
                dsnElem.setAttribute("attribName", dsNamer.getAttribName());
            }
        }
        return dsnElem;
    }

    private Element createDatasetFilterElement(DatasetFilter dsFilter) {
        Element dsfElem = new Element("datasetFilter", CATALOG_GEN_CONFIG_NAMESPACE_0_5);
        if (dsFilter != null) {
            if (dsFilter.getName() != null) {
                dsfElem.setAttribute("name", dsFilter.getName());
            }
            if (dsFilter.getType() != null) {
                dsfElem.setAttribute("type", dsFilter.getType().toString());
            }
            if (dsFilter.getMatchPattern() != null) {
                dsfElem.setAttribute("matchPattern", dsFilter.getMatchPattern());
            }
            if (dsFilter.getMatchPatternTarget() != null) {
                dsfElem.setAttribute("matchPatternTarget", dsFilter.getMatchPatternTarget());
            }
            dsfElem.setAttribute("applyToCollectionDatasets", String.valueOf(dsFilter.isApplyToCollectionDatasets()));
            dsfElem.setAttribute("applyToAtomicDatasets", String.valueOf(dsFilter.isApplyToAtomicDatasets()));
            dsfElem.setAttribute("rejectMatchingDatasets", String.valueOf(dsFilter.isRejectMatchingDatasets()));
        }
        return dsfElem;
    }

    private Element createResultServiceElement(ResultService resultService) {
        Element rsElem = new Element("resultService", CATALOG_GEN_CONFIG_NAMESPACE_0_5);
        if (resultService != null) {
            if (resultService.getName() != null) {
                rsElem.setAttribute("name", resultService.getName());
            }
            if (resultService.getServiceType() != null) {
                rsElem.setAttribute("serviceType", resultService.getServiceType().toString());
            }
            if (resultService.getBase() != null) {
                rsElem.setAttribute("base", resultService.getBase());
            }
            if (resultService.getSuffix() != null) {
                rsElem.setAttribute("suffix", resultService.getSuffix());
            }
            if (resultService.getAccessPointHeader() != null) {
                rsElem.setAttribute("accessPointHeader", resultService.getAccessPointHeader());
            }
        }
        return rsElem;
    }
}

