/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore.model;

import java.util.Calendar;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMOperationType;

public class IDMQueueEntry {
    private long id;
    private String entityId;
    private IDMEntityType<?> entityType;
    private IDMOperationType operationType;
    private boolean processed = false;
    private int retryCount = 0;
    private Calendar creationDate;

    public IDMQueueEntry() {
    }

    public IDMQueueEntry(IDMEntityType<?> entityType, String entityId, IDMOperationType operationType) {
        if (entityType == null) {
            throw new IllegalArgumentException("'entityType' parameter shouldn't be null");
        }
        if (StringUtils.isBlank((String)entityId)) {
            throw new IllegalArgumentException("'entityId' parameter is mandatory");
        }
        if (operationType == null) {
            throw new IllegalArgumentException("'operationType' parameter shouldn't be null");
        }
        this.operationType = operationType;
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public IDMEntityType<?> getEntityType() {
        return this.entityType;
    }

    public IDMQueueEntry setEntityType(IDMEntityType<?> entityType) {
        this.entityType = entityType;
        return this;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public IDMQueueEntry setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public IDMOperationType getOperationType() {
        return this.operationType;
    }

    public IDMQueueEntry setOperationType(IDMOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public IDMQueueEntry setProcessed(boolean processed) {
        this.processed = processed;
        return this;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public IDMQueueEntry setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public IDMQueueEntry setId(long id) {
        this.id = id;
        return this;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public IDMQueueEntry setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IDMQueueEntry)) {
            return false;
        }
        IDMQueueEntry entry = (IDMQueueEntry)obj;
        return StringUtils.equals((String)entry.getEntityId(), (String)this.getEntityId()) && entry.getOperationType() == this.getOperationType() && Objects.equals(entry.getEntityType(), this.getEntityType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getEntityId(), this.getOperationType(), this.getEntityType()});
    }

    public String toString() {
        return "[entityType=" + (this.entityType == null ? null : this.entityType.getClassType().getName()) + ", entityId=" + this.entityId + ",operationType=" + (Object)((Object)this.operationType) + ",processed=" + this.processed + ",retryCount=" + this.retryCount + "]";
    }
}

