/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.badge.impl;

import java.io.InputStream;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.setting.badge.BadgeRegistry;
import org.exoplatform.addons.gamification.service.setting.badge.model.BadgeConfig;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class BadgeRegistryImpl
implements Startable,
BadgeRegistry {
    private static final Log LOG = ExoLogger.getLogger(BadgeRegistryImpl.class);
    private final Map<String, BadgeConfig> badgesMap = new HashMap<String, BadgeConfig>();
    private BadgeService badgeService;
    private FileService fileService;
    private DomainService domainService;

    public BadgeRegistryImpl(FileService fileService, NameSpaceService nameSpaceService) {
        this.fileService = fileService;
    }

    @Override
    public void addPlugin(BadgeConfig badge) {
        this.badgesMap.put(badge.getTitle(), badge);
    }

    @Override
    public boolean remove(BadgeConfig badge) {
        this.badgesMap.remove(badge.getTitle());
        return true;
    }

    public void start() {
        this.badgeService = (BadgeService)CommonsUtils.getService(BadgeService.class);
        try {
            for (BadgeConfig badge : this.badgesMap.values()) {
                BadgeDTO badgeDTO = this.badgeService.findBadgeByTitleAndDomain(badge.getTitle(), badge.getDomain());
                if (badgeDTO != null) continue;
                this.store(badge);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Rules ", (Throwable)e);
        }
    }

    private void store(BadgeConfig badgeConfig) {
        this.domainService = (DomainService)CommonsUtils.getService(DomainService.class);
        BadgeDTO badgeDTO = new BadgeDTO();
        badgeDTO.setTitle(badgeConfig.getTitle());
        badgeDTO.setDescription(badgeConfig.getDescription());
        badgeDTO.setDomain(badgeConfig.getDomain());
        badgeDTO.setDomainDTO(this.domainService.findDomainByTitle(badgeConfig.getDomain()));
        badgeDTO.setIconFileId(this.storeIcon(badgeConfig.getIcon()));
        badgeDTO.setNeededScore(badgeConfig.getNeededScore());
        badgeDTO.setEnabled(badgeConfig.isEnable());
        badgeDTO.setDeleted(false);
        badgeDTO.setLastModifiedDate(LocalDate.now().toString());
        badgeDTO.setLastModifiedBy("Gamification");
        badgeDTO.setCreatedBy("Gamification");
        badgeDTO.setCreatedDate(LocalDate.now().toString());
        this.badgeService.addBadge(badgeDTO);
    }

    private long storeIcon(String iconTitle) {
        FileItem fileItem = null;
        long iconFiledId = 0L;
        try {
            InputStream inputStream = BadgeRegistryImpl.class.getClassLoader().getResourceAsStream("medias/images/" + iconTitle);
            fileItem = new FileItem(null, iconTitle, "image/png", "gamification", (long)inputStream.available(), new Date(), "gamification", false, inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            iconFiledId = fileItem.getFileInfo().getId();
        }
        catch (Exception e) {
            LOG.error("Enable to inject icon for badge {} ", new Object[]{iconTitle, e});
        }
        return iconFiledId;
    }

    public void stop() {
    }
}

