/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.gatein.cdi.contexts.AbstractCDIPortletContext;
import org.gatein.cdi.contexts.CDIPortletContext;
import org.gatein.cdi.contexts.PortletLifecycleContextImpl;
import org.gatein.cdi.contexts.PortletRedisplayedContextImpl;

public class CDIPortletContextExtension
implements Extension {
    private Collection<CDIPortletContext> contexts;

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ArrayList<AbstractCDIPortletContext> contextList = new ArrayList<AbstractCDIPortletContext>(2);
        contextList.add(new PortletLifecycleContextImpl());
        contextList.add(new PortletRedisplayedContextImpl());
        for (CDIPortletContext cDIPortletContext : contextList) {
            afterBeanDiscovery.addContext((Context)cDIPortletContext);
        }
        this.contexts = Collections.unmodifiableCollection(contextList);
    }

    public <T extends CDIPortletContext> T getContext(Class<T> type) {
        if (type == null) {
            return null;
        }
        for (CDIPortletContext context : this.contexts) {
            if (!type.isAssignableFrom(context.getClass())) continue;
            return (T)context;
        }
        return null;
    }

    public Collection<CDIPortletContext> getContexts() {
        Collection<CDIPortletContext> collection = this.contexts;
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }
}

